/**
 * Created by harada on 2016/01/12.
 */
/************************************************************************************
 *
 * section::グローバル定数
 *
 ************************************************************************************/
VM_UI={};//UI viewmodel
//BLEPairingController={};//ペアリングコントローラー (BLEPairingController.js) シングルトン
//DeviceController={};//制御デバイス生成コントローラー (DeviceController.js) シングルトン
BP={};
TLP={};
EXT_NAME="keicore";//keigan core　 keiganc
URL_SCHEME="keigan-motor-app://";
ROBO_DATA_VAR=1;//互換性の為のロボットのデータヴァージョン
ROBO_TEMPLATE_URL="https://app-api.keigan-motor.com/ROBO_TEMPLATE/?";
FARM_VER_URL="https://app-api.keigan-motor.com/farmver.php";
FARM_PAGE_URL="https://docs.keigan-motor.com/firmware/download";
SITE_URL="https://docs.keigan-motor.com/apps/keigancore-app/";
//cordovaのOS判定
IS_CORDOVA_IOS=null;
IS_CORDOVA_ANDROID=null;

//タップイベント感度 関係
HAMMER_TAP_MAX_TIME=1500;//tapと判断する最大プレス時間(ms)
HAMMER_DOUBLETAP_MAX_TIME=1500;
HAMMER_DOUBLETAP_INT_TIME=500;//doubletapと判断するタップの間隔
HAMMER_HOLD_TIME=500;//holdと認識するまでの時間
HAMMER_HOLDUP_TIME=100;//holdupと認識するまでの時間
/************************************************************************************
 *
 * section::urlスキーム関数・デバッグ関数・アプリ初期化
 *
 ************************************************************************************/
var app = {
    initialize: function() {
        if(cordova){
            switch (cordova.platformId){
                case 'ios':
                    IS_CORDOVA_IOS=true;
                    break;
                case 'android':
                    IS_CORDOVA_ANDROID=true;
                    break;
            }
        }
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    onDeviceReady: function() {
      //StatusBar.overlaysWebView(false);//ステータスバーの表示のオーバーラップ
      //   StatusBar.show();
      //   StatusBar.hide();

        //app.receivedEvent('deviceready');//info::codepush

        //info::（iOSのみ）通常のwindow.openはwkwebview-engineとのコンフリクトで動作しない？為、InAppBrowserを使用
        if(cordova.InAppBrowser){window.open = cordova.InAppBrowser.open;}

       // codePush.sync();//codepush
      appEntryPoint();
    }
};


//info::ロボットファイル読み込み用ファイル受信、及びカスタムURLスキーム受信(keigan-motor-app)
DEBUG_G="";
function handleOpenURL(url) {
    DEBUG_G=url;
    var url = decodeURI(url);
    if(!url){return;}
    // navigator.notification.alert("handleOpenURL:"+url,null,"",['Ok']);
    //info::渡されたデータが URLスキーム経由かファイル経由かの分岐
    if(url.indexOf(URL_SCHEME)===0){
        setTimeout(function() {
            if(VM_UI.dev_save_list_input){
                VM_UI.dev_save_list_input(url);
            }else{
                UTL_LOG("UrlScheme handleOpenURL err");
            }
        }, 500);
    }else if(url.indexOf('file://')===0){
        //ファイルの中身を読み込み、その後Inbox内tmpファイルを削除
        setTimeout(function() {
            var paths=UTL_FilePathAnalyze(url);
            UTL_load_filesys(paths.protocol_directory,paths.name_ext,function(v){
               if(v){
                   if(VM_UI.dev_save_list_input){
                       VM_UI.dev_save_list_input(v);
                   }else{
                       UTL_LOG("File handleOpenURL err");
                   }
               }else{
                   UTL_LOG("File handleOpenURL err");
               };

                // //info::(廃止)tmpファイルの削除　iosのみファイル受信時に「Documents/Inbox」にコピーされる。andoridだとアプリのsandboxにコピーされない為、元のファイルを削除する事になる為廃止
                // UTL_remove_filesys(paths.protocol_directory,paths.name_ext,function(v){
                //     if(!v){
                //         UTL_LOG("remove_filesys err");
                //     }
                // });
            });
        }, 500);
    }else if(url.indexOf('content://')===0){
        //info::andoroidのみ Gmailからのcontentプロバイダー経由のファイルストリーム
        //todo::info:: GoogleDriveのcontentスキームは改行が入って handleOpenURL が 「Invalid or unexpected token」になる原因不明の問題の為、動作しない
        setTimeout(function() {
            window.plugins.DocumentContract.getContract({
                    uri: url
                },
                function(contract) {
                    console.dir(contract);
                    // Outputs
                    // {
                    //   '_display_name': 'SampleFile.pdf',
                    //   'document_id': 'foo123',
                    //   'last_modified': '/SomeDate/',
                    //   'mime_type': 'application/pdf',
                    //   'nth key': 'nth value'
                    // }
                    var file_path=contract._data;
                    if(file_path){
                        var paths=UTL_FilePathAnalyze(file_path);
                        var dir= paths.protocol?paths.protocol_directory:'file://'+paths.protocol_directory;

                        UTL_load_filesys(dir,paths.name_ext,function(v){
                            if(v){
                                if(VM_UI.dev_save_list_input){
                                    VM_UI.dev_save_list_input(v);
                                }else{
                                    UTL_LOG("Get DocumentContract handleOpenURL err");
                                }
                            }else{
                                UTL_LOG("Get DocumentContract handleOpenURL err");
                            };
                        });
                    }else{
                        UTL_LOG("Get DocumentContract NoFilePath err:");
                    }
                },
                function(error) {
                    UTL_LOG("Get DocumentContract err"+error);
                }
            );
        }, 500);
    }else{
        //info::通常のサイトURL(window.openでは別ウインドウでもhandleOpenURLがキックされる)
        return;
    }


}
/************************************************************************************
 *
 * section::KMファームヴァージョンチェッカー
 *
 *
 ************************************************************************************/
var KMFarmVersionChecker={
    _farmVersionTmpl:null,//{"KM1":{"latest_version":1.12}}
    _currentMotors:{},
    _url_str:UTL_add_getquery_prm(FARM_VER_URL,'lang',LANGUAGE),

    //最新ファームヴァージョンの取得をサーバーから行う
    loadLatestFarmVersionTmplData:function(){
        var me=this;
        if(!this._url_str){return;}
        $.getJSON(this._url_str, function() {
        }).done(function(json) {
            if(typeof json ==="object"){
                me._farmVersionTmpl=json;
                Object.keys(me._currentMotors).forEach(function (deviceName) {
                    me._updateLatestFarmVersion(deviceName);
                })
            }
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
        })
        .always(function() {
        });
    },
    //現在のモーターのヴァージョンの設定
    setCurrentFarmVersion:function(deviceuuid,modelName,version){
        if(!deviceuuid||!modelName){return;}
        this._currentMotors[deviceuuid]={modelName:modelName,currentVersion:UTL_N(version),latestVersion:0};
        this._updateLatestFarmVersion(deviceuuid);
    },
    //現在のモーターの最終ヴァージョンを反映
    _updateLatestFarmVersion:function(deviceuuid){
        var current=this._currentMotors[deviceuuid];
        if(this._farmVersionTmpl && current && this._farmVersionTmpl[current.modelName]){
            current.latestVersion=UTL_N(this._farmVersionTmpl[current.modelName].latestVersion);
        }
    },
    //アップデートが必要か？
    //@return MIX  必要時:{modelName,currentVersion,latestVersion} 不要時:null
    isUpdate:function(deviceuuid){
        if(this._currentMotors[deviceuuid]&&this._currentMotors[deviceuuid].currentVersion){
           return this._currentMotors[deviceuuid].currentVersion< this._currentMotors[deviceuuid].latestVersion;
        }
        return false;
    },
    getCurrentVersion:function(deviceuuid){
        if(this._currentMotors[deviceuuid]){
            return this._currentMotors[deviceuuid].currentVersion;
        }else{
            return "";
        }
    },
    getLatestVersion:function(deviceuuid){
        if(this._currentMotors[deviceuuid]){
            return this._currentMotors[deviceuuid].latestVersion;
        }else{
            return "";
        }
    },

};

/************************************************************************************
 *
 * section::ローカライズ関数 languages.js
 *
 ************************************************************************************/

//言語切り替え
function ChangeLang(lang){
    UTL_save_storage('LANGUAGE',lang);
    location.reload();
}


/************************************************************************************
 *
 * section::エントリーポイント（Cordova初期化完了）
 *
 ************************************************************************************/
function appEntryPoint(){

    // -------------------//
    //  DOMにプラットフォーム情報を付加
    // -------------------//
    if(IS_CORDOVA_IOS){
        $('html').addClass('CORDOVA_IOS');
    }else if(IS_CORDOVA_ANDROID){
        $('html').addClass('CORDOVA_ANDROID');
    }
    // -------------------//
    //  言語　ローカライズ
    // -------------------//
    LANGUAGE_LIST=[];//info::設定>プルダウン表記
    for(var idx in LANGUAGE_RESOURCES){LANGUAGE_LIST.push({name:idx,id:idx});}
    var r= UTL_load_storage('LANGUAGE');
    LANGUAGE=r?r:LANGUAGE_LIST[0].id;//設定言語読み込み

    // -------------------//
    //　ペアリングコントローラーとデバイスリストの接続
    //  BLEPairingController;//global ペアリングコントローラー (BLEPairingController.js) シングルトン
    //  DeviceController;//制御デバイス生成コントローラー (DeviceController.js) シングルトン
    //　・ペアリング・解除時のデバイスリストの自動追加・削除
    //　・切断時の自動再接続
    //　・コントローラー状態復帰完了時の処理
    //--------------------//

    /*
     * ●ペアリングフロー
     * 1)BLEPairingController.SearchDevice()でBLEデバイスをsearch
     * 2)BLEPairingController.GetDeviceInfolist()でsearchしたデバイス編集のリストを取得> DeviceInfolist:DeviceInfo[]
     * 3)BLEPairingController.PairingDevice(DeviceInfo) で新規接続
     * 3-2)切断は BLEPairingController.DisconPairingDevice(DeviceInfo)
     *
     * その機器がペアリング中かの判断　DeviceInfo.is_pairing に格納
     * 全てのペアリングを切断し初期化　BLEPairingController.ClearDevice()
     * スマホのBLEの有効検出　BLEPairingController.GetBLEisEnabled()
     * デバイス情報からGATTを取得（但し、一度でもペアリングしたデバイスでないと取得出来ない） BLEPairingController.GetGATTProfile(BLEDeviceInfo)
     * */
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnPairingComp,function(e){
        UTL_LOG("EV:OnPairingComp //ペアリング完了:"+ e.BLEDeviceInfo["device_name"]);
        DeviceController.AddBLEDevice(e.BLEDeviceInfo);

    });
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnDisconPairingComp,function(e){
        UTL_LOG("EV:OnDisconPairingComp //ペアリングの解除完了:"+ e.BLEDeviceInfo["device_name"]);
        DeviceController.CheckBLEDeviceStateUpdate(e.BLEDeviceInfo);
    });
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnConnectMissing,function(e){
        UTL_LOG("EV:OnConnectMissing //接続を開始しようとして失敗した:"+ e.BLEDeviceInfo["device_name"]);
    });
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnConnectionLoss,function(e){
        UTL_LOG("EV:OnConnectionLoss //接続中に接続が切れた:"+ e.BLEDeviceInfo["device_name"]);
        DeviceController.CheckBLEDeviceStateUpdate(e.BLEDeviceInfo);
    });
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnReConnectTry,function(e){
        UTL_LOG("EV:OnReConnectTry //再接続の自動処理:"+ e.BLEDeviceInfo["device_name"]+" TryCount:"+ e.TryCount);
    });
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnPairingAutoCance,function(e){
        UTL_LOG("EV:OnPairingAutoCance //デバイスが存在しない為、自動でペアリングを解除:"+ e.BLEDeviceInfo["device_name"]);
        //todo::解除時にデバイスを自動的に削除するか検討（削除しないと、過去のデバイスの残骸（重複しないデバイス）がずっと残る可能性）
        DeviceController.CheckBLEDeviceStateUpdate(e.BLEDeviceInfo);
    });
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnDiscovery,function(e){
        UTL_LOG("EV:OnDiscovery //デバイスを発見");
        UTL_LOG( {発見:e.BLEDeviceInfo});
    });
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnBLEChange,function(e){
        UTL_LOG("EV:OnBLEChange //BLEの有効無効が切り替わった:"+ e.BLEisEnabled);
    });
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnScanStateChange,function(e){
        UTL_LOG("EV:OnScanStateChange //スキャン状態変更:"+e.isScanNing);
        if(e.isScanNing==false){
            UTL_LOG({現在のデバイス:BLEPairingController.GetDeviceInfolist()});
        }
    });
    // //BLEデバイス再接続
    // DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnReconnectBLEDevice,function(e){
    //     UTL_LOG("EV:DeviceController OnReconnectBLEDevice //BLEデバイス再接続");
    //     //DeviceController.CheckBLEDeviceStateUpdate(e.BLEDeviceInfo);
    // });
    // //BLEデバイス生成完了
    // DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnCreateBLEDevice,function(e){
    //     UTL_LOG("EV:DeviceController OnCreateBLEDevice //BLEデバイス生成完了");
    //     //DeviceController.CheckBLEDeviceStateUpdate(e.BLEDeviceInfo);
    // });

    // //ビルトインデバイス生成完了
    // DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnCreateBuiltinDevice,function(e){
    //     UTL_LOG("EV:DeviceController OnCreateBuiltinDevice //ビルトインデバイス生成完了");
    // });
    //
    // //コントローラー状態復帰完了時の処理
    // DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnStateLoadComp,function(e){
    //     UTL_LOG("EV:DeviceController OnStateLoadComp //コントローラー状態復帰完了時の処理");
    //     DeviceController.CheckBLEDeviceStateAllUpdate(BLEPairingController.GetDeviceInfolist());
    // });

    // -------------------//
    //section::初期化処理
    //--------------------//
    //ペアリングとデバイスリストのUIの初期化
    VM_UI=new UI_ViewModel();
    ko.applyBindings(VM_UI);
    BLEPairingController.init();
    DeviceController.init();

    VM_UI.update_check_action();//CodePushによるアップデータのチェックとDL

    KMFarmVersionChecker.loadLatestFarmVersionTmplData();//最新ファームversionの取得をサーバーから行う
    //BLECharacteristicController.StartRec();//info::debug
    // todo::ビルトインデバイスは、端末毎に自動検出・生成ロジックにする

}

/********************
 * section::UIバインド (knockoutビューモデル)
 *********************/
//
function UI_ViewModel() {
   var self = this;
    self.EventHandler=new EventTarget();
    // -------------------//
    // section:: 各種定数
    //--------------------//
    /**
     * イベントタイプ定数
     */
    self.EventHandlerType= {
        "OnAfterPanelChange_1": "OnAfterPanelChange_1",//編集画面移動後
        "OnAfterPanelChange_2": "OnAfterPanelChange_2",//再生画面移動後
        "OnAfterPanelChange_3": "OnAfterPanelChange_3",//ペアリング画面移動後
        "OnAfterPanelChange_4": "OnAfterPanelChange_4",//リスト一覧画面移動後
        "OnAfterPanelChange_5": "OnAfterPanelChange_5",//設定画面移動後
        "OnBeforPanelChange_1": "OnBeforPanelChange_1",//編集画面移動前
        "OnBeforPanelChange_2": "OnBeforPanelChange_2",//再生画面移動前
        "OnBeforPanelChange_3": "OnBeforPanelChange_3",//ペアリング画面移動前
        "OnBeforPanelChange_4": "OnBeforPanelChange_4",//リスト一覧画面移動前
        "OnBeforPanelChange_5": "OnBeforPanelChange_5",//設定画面移動前

        //離脱前
        "OnExitPanelChange_1": "OnExitPanelChange_1",//編集画面離脱前
        "OnExitPanelChange_2": "OnExitPanelChange_2",//再生画面離脱前
        "OnExitPanelChange_3": "OnExitPanelChange_3",//ペアリング画面離脱前
        "OnExitPanelChange_4": "OnExitPanelChange_4",//リスト一覧画面離脱前
        "OnExitPanelChange_5": "OnExitPanelChange_5",//設定画面離脱前
    };

    /**
     *デバイスグリッドのアイコンサイズ
     */
    self.dev_grid_data_clo=10;//デバイスグリッドの列数 X
    self.dev_grid_data_row=10;//デバイスグリッドの行数 Y
    self.dev_grid_ico_WH=58;//デバイスグリッドのアイコンサイズ
    self.dev_grid_ico_outWH=78;//デバイスグリッドのアイコンサイズ(マージン含む)
    self.dev_grid_ico_moving=ko.observable();
    //BLEスキャン時にKEigan Motorのみ表示
    self._bleScan_is_KMonry=ko.observable((typeof UTL_load_storage('bleScan_is_KMonry')=="boolean"?UTL_load_storage('bleScan_is_KMonry'):true));
    self.bleScan_is_KMonry = ko.computed({
        read: function () {
            return  self._bleScan_is_KMonry();
        },write:function(val){
            var s=(val?true:false);
           UTL_save_storage('bleScan_is_KMonry',s);
            self._bleScan_is_KMonry(s);
        },
        owner: self}
    );
    // -------------------//
    // section:: 画面遷移処理
    //--------------------//
    self._win_panel_num=ko.observable(3);//デフォルトはペアリングリスト

    self.win_panel_num = ko.computed({
        read: function () {
            return self._win_panel_num();
        },write:function(val){
           if(val===self._win_panel_num()){return;}
            //画面遷移時のイベント　
            var old_var=self._win_panel_num.peek();
            //離脱前（古い画面）
            if(self.EventHandlerType["OnBeforPanelChange_"+old_var]){
                self.EventHandler.fire({type: self.EventHandlerType["OnBeforPanelChange_"+old_var], tar: self});
            }
            //遷移前
            if(self.EventHandlerType["OnBeforPanelChange_"+val]){
                self.EventHandler.fire({type: self.EventHandlerType["OnBeforPanelChange_"+val], tar: self});
            }
            self._win_panel_num(val);
            //遷移後
            if(self.EventHandlerType["OnAfterPanelChange_"+val]){
                setTimeout(function(){self.EventHandler.fire({type: self.EventHandlerType["OnAfterPanelChange_"+val], tar: self});},100);
            }
        },
        owner: this}
    );
    //-------------------//
    //section::設定画面
    //--------------------//
    /**
     * CodePushによる更新通知・適用処理
     */
    self.update_pending_package=ko.observable(null);
    self.update_now_package=ko.observable(null);
    self.is_update_checking=ko.observable(false);
    self.update_check_action=function(vm,ev){
        var btn_jq=ev?$(ev.target):$('<button></button>');

       btn_jq.button('loading');
        codePush.sync(function(status){
            switch (status) {
                case SyncStatus.UP_TO_DATE://最新の状態
                    self._drow_update_packages_info();
                    break;
                case SyncStatus.UPDATE_INSTALLED://利用可能なアップデートがインストール済み。再起動適用待ち
                    self._drow_update_packages_info();
                    break;
                case SyncStatus.CHECKING_FOR_UPDATE://CodePushサーバが更新のために照会
                case SyncStatus.DOWNLOADING_PACKAGE://UPDダウンロード中
                case SyncStatus.INSTALLING_UPDATE://UPDインストール中
                    return;//ボタンをアクティブにしない
                    break;
                case SyncStatus.UPDATE_IGNORED://UDPをユーザーが無視（使用しない）
                case SyncStatus.ERROR://エラー
                default :
                    break;
            }
            btn_jq.button('reset');
        });
    };
    //現在のUPDパッケージ情報と保留中のパッケージ情報の更新
    self._drow_update_packages_info=function(){
        //現在のUPDパッケージ情報
        codePush.getCurrentPackage(function (update) {
            if (update) {
                var st=update.appVersion+" "+update.label;//+" : "+update.description;
                self.update_now_package(st);
            }else{
                self.update_now_package(WORD('setting_update_check_res'));
            }
            //更新適用前(保留中)のパッケージの有無　
            // info::getCurrentPackageとgetPendingPackageは逐次処理(getCurrentPackageが処理中 ＞ getPendingPackage実行 ＞ getCurrentPackageはキャンセルされる)
            codePush.getPendingPackage(function (update) {
                if (update) {
                    var st=update.appVersion+" "+update.label+" : "+update.description;
                    self.update_pending_package(st);
                }else {
                    self.update_pending_package(null);
                    //
                }
            });
        });
    };

    /**
     * KeiganMotor 01の仮想デバイス追加(編集時組み立て用。通常はペアリングで自動追加される　) info::KM1 のみの処理
     * todo::複数シリーズ展開時はデバイス追加タブから追加可能に
     */
    self.km_virtual_device_add_action=function(){
        for(var i=0;i<AbstractDeviceList.ClassOptions.length;i++){
            var t=AbstractDeviceList.ClassOptions[i];
           if(t.device_name=="ble_KeiganMotor"){
               self.device_add_action(t,{});
           }
        }
        self.win_panel_num(1);
    };
    /**
     * 言語切り替え
     */
    self._now_language=ko.observable(LANGUAGE);
    self.now_language=ko.pureComputed({
        read: function () {
            return self._now_language();
        },write:function(val){
            //info::pureComputed内でダイアログ(Corodva Notification)プラグインを実行するとネイティブ側でスレッド警告で動作不良になる為、setTimeout関数でスレッドを分ける
            // THREAD WARNING: ['Notification'] took  Plugin should use a background thread.
            setTimeout(function(){
                self.change_language(val);
            },100);
        },owner: this
    });
    //言語切り替え
    self.change_language=function(val){
        var lang_changeword=GLOBAL_WORD(val,'alt_lang_change');
        navigator.notification.confirm(lang_changeword,
            function(id){
                if(id==1){
                    ChangeLang(val);
                }else{
                    self.now_language.notifySubscribers();//info::プルダウン戻す
                }
            },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]
        );
    };
    // -------------------//
    // section:: BLEペアリング画面
    //--------------------//
   self.ble_list=ko.observableArray();
   self.ScanState=ko.observable(false);//スキャン状態
   self.BLEisEnabled=ko.observable(false);//BLEの有効無効
    self.BLELogMsg=ko.observable();//ログメッセージ 1行
    //ペアリング画面遷移後
    self.EventHandler.addListener(self.EventHandlerType.OnAfterPanelChange_3,function(e){
        _ble_list_update_notify();
    });
    //スキャン状態変更時
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnScanStateChange,function(e){
        //スキャン終了時にリストを読み直し
        if(!e.isScanNing){
           self.ble_list.removeAll();
            var ar=[];

            var ls=BLEPairingController.GetDeviceInfolist();
            for(var i=0;i<ls.length;i++){
                    ar.push(ko.observable(ls[i]));
            }

            ar.sort(function(_a,_b){
                var a=_a.peek();
                var b=_b.peek();
                if(a.is_existing <b.is_existing) {return 1};
                if(a.is_existing >b.is_existing) {return -1};
                return 0;
            });


            self.ble_list(ar);
        }
        self.ScanState(e.isScanNing);
    });

    //BLEの有効無効が切り替わった
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnBLEChange,function(e){
        self.BLEisEnabled(e.BLEisEnabled);
    });
    //デバイス新規発見
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnDiscovery,function(e){
        self.ble_list.push(ko.observable(e.BLEDeviceInfo));
    });
    //ペアリング完了
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnPairingComp,function(e){
        self.BLELogMsg(WORD('pair_BLELogMsg_comp')+":"+e.BLEDeviceInfo["device_name"] );//lang::ペアリング完了
        //info::仮想デバイスの初期化はOnPairingCompイベント後なので、仮想デバイスの表示更新はさらに遅延させる
        setTimeout(function(){
            _ble_list_update_notify();//BLEリスト表示更新
            _device_grid_update_notify();//グリッドのアイコン表示更新
        },100);
    });
    //ペアリングの解除
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnDisconPairingComp,function(e){
        self.BLELogMsg(WORD('pair_BLELogMsg_unpaired',{device_name:e.BLEDeviceInfo["device_name"]}) );//lang::ペアリング解除["device_name"]
        _ble_list_update_notify();
        _device_grid_update_notify();//グリッドのアイコン表示更新

    });
    // //デバイスが存在しない為、自動でペアリングを解除
    // BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnPairingAutoCance,function(e){
    //     self.BLELogMsg(WORD('pair_BLELogMsg_notfind',{device_name:e.BLEDeviceInfo["device_name"]}) );//lang::["device_name"]は見つからない為、解除されました
    //     _ble_list_update_notify();
    // });
    //リストのクリアー
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnClearDeviceComp,function(e){
        self.ble_list.removeAll();
       // DeviceController.Controller_state_Clear_BLE();//BLE仮想デバイスの消去
    });
    //接続中に接続が切れた
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnConnectionLoss,function(e){
        self.BLELogMsg(WORD('pair_BLELogMsg_broken',{device_name:e.BLEDeviceInfo["device_name"]}));//lang::["device_name"]の接続が切れました
        _ble_list_update_notify();
        _device_grid_update_notify();//グリッドのアイコン表示更新

    });
    //ペアリング失敗
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnConnectMissing,function(e){
        self.BLELogMsg(WORD('pair_BLELogMsg_failed',{device_name:e.BLEDeviceInfo["device_name"]}));//lang::["device_name"]の接続が失敗しました
    });
   
    //コントローラーの初期化完了
    BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnInitComp,function(e){
        $('#main_panel_wrap').show();
        //e.tar
        //リストの追加
        self.ble_list.removeAll();
        var ls=BLEPairingController.GetDeviceInfolist();
       self.ble_list.extend({rateLimit: 100});
        for(var i=0;i<ls.length;i++){
            self.ble_list.push(ko.observable(ls[i]));//前回保存時のリスト表示
        }
        self.ble_list.extend({rateLimit: 0});
        //BLE・スキャン状態の更新
        self.ScanState(BLEPairingController.GetScanState());
        self.BLEisEnabled(BLEPairingController.GetBLEisEnabled());
    });

    /**
     * ペアリング・開始・解除
     */
    self.pairing_tggl_action=function(_BLEDeviceInfo,event){
        var tar_BLEDeviceInfo=_BLEDeviceInfo;
        if(tar_BLEDeviceInfo._connectTry){return;}
        if( typeof tar_BLEDeviceInfo !== "object"){return;}
        if(!tar_BLEDeviceInfo.is_existing){ return; }//存在しない場合は処理しない
        //接続・切断のトグル
        if(tar_BLEDeviceInfo.is_pairing){
            //ロボットに接続されている場合は確認アラート
            //lang::解除しますか?
            navigator.notification.confirm(WORD('pair_alert_conf_unpaired'),
                function(id){
                    if(id==1){
                        BLEPairingController.DisconPairingDevice(tar_BLEDeviceInfo);
                    }
                },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]
            );
        }else{
            BLEPairingController.PairingDevice(tar_BLEDeviceInfo);
            _ble_list_update_notify(tar_BLEDeviceInfo);
        }
    };
    /**
    * BLEのスキャン開始と停止(トグル)
    */
    self.scan_action=function(){
       if(self.ScanState()){
           BLEPairingController.StopSearchDevice();
       }else {
           BLEPairingController.SearchDevice(self.bleScan_is_KMonry());
       }
    };

    /**
     * 全てを切断しリストを初期化
     */
    self.clear_action=function () {
        //ロボットに接続されている場合は確認アラート
        navigator.notification.confirm(WORD('pair_alert_conf_allunpair'),
            function(id){
                if(id==1){
                    BLEPairingController.ClearDevice();
                }
            },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]
        );
    };

    /**
     * ble_listの表示更新
     * @param BLEDeviceInfo Nullの場合は全てが対象
     * @private
     */
    function _ble_list_update_notify(BLEDeviceInfo){
        if(self.win_panel_num()!=3) {return;}//ペアリング画面の時のみ更新
        if(BLEDeviceInfo){
            DeviceController.CheckBLEDeviceStateUpdate(BLEDeviceInfo);
            ko.utils.arrayForEach(self.ble_list(), function(item, index){
                var fx_info =item();
                if(fx_info==BLEDeviceInfo){
                    item.notifySubscribers();
                }
            });
        }else {
            DeviceController.CheckBLEDeviceStateAllUpdate(BLEPairingController.GetDeviceInfolist());
            ko.utils.arrayForEach(self.ble_list(), function (item, index) {
                item.notifySubscribers();
            });
        }
    }

    /**
     * ファームウエアダウンロードサイトへのリンク
     * info::リンク先URLに現在の選択言語を付加してジャンプする
     */
    self.firm_dl_site_page_select_action=function(){
        var tmpl_url= UTL_add_getquery_prm(FARM_PAGE_URL,'lang',LANGUAGE);
        window.open(tmpl_url,"_system");//InAppBrowserで置き換え済み　"_system"でないとsafariで開かない 別ウインドウでもfunction:handleOpenURLがキックされる
    };

    // -------------------//
    //section::デバイス編集画面
    //--------------------//

    //info::デバイスグリッドのOBJ:{x:配置座標x,y:配置座標y,device_obs:ko.observable(デバイスの参照)}
    function Grid_obj(){
        this.x=0;//グリッドの座標
        this.y=0;
        this.device_obs=ko.observable();
        this.is_drag=ko.observable(false);//そのアイコンがドラッグかの中フラグ（CSSで使用）
    }
    //バインドの線描画オブジェクト
    //@param bind_line_shift 線の重複時に位置をシフトする判定用
    function Bind_line_obj(DeviceValBinder,bind_line_shift){
        var sl=4;//シフト線幅
        var ini=[[DeviceValBinder.owner.layout_x,DeviceValBinder.owner.layout_y],[DeviceValBinder.target_ref.owner.layout_x,DeviceValBinder.target_ref.owner.layout_y]];
        this.type_list_names=DeviceValBinder_TypeListBitToTypeNames(DeviceValBinder.type_list & DeviceValBinder.target_ref.type_list);//両方のデバイスで重複しているデータタイプのクラス名のみ表示
        var to_flow_dev= DeviceValBinder.dataflow_list < DeviceValBinder.target_ref.dataflow_list?DeviceValBinder:DeviceValBinder.target_ref;//データの方向終着側のデバイス
        this.stroke="#00ff00";
        this.stroke_width=2;
        this.points="";
        this.arrows=[];
        var flow_direction=[];//データの終端方向
        var opd=self.dev_grid_ico_outWH/2;
        //アイコン間の線描画
        //Y軸X軸の順に座標の小さいアイコンをスタートに描画
        ini.sort(function(a,b){return a[1] < b[1]? -1:(a[1] > b[1]?1:0);});
        ini.sort(function(a,b){return a[0] < b[0]? -1:(a[0] > b[0]?1:0);});
        var fx=ini[0][0];
        var fy=ini[0][1];
        var tx=ini[1][0];
        var ty=ini[1][1];
        var fs=bind_line_shift[fy][fx];
        var ts=bind_line_shift[ty][tx];
        var f_shift=Math.ceil(fs/2)*((fs%2*2)-1);
        var t_shift=Math.ceil(ts/2)*((ts%2*2)-1);
        bind_line_shift[fy][fx]++;
        bind_line_shift[ty][tx]++;


        ///描画
        var pos=[];
        pos[0]= [fx*self.dev_grid_ico_outWH+opd+(f_shift*sl),fy*self.dev_grid_ico_outWH+opd+(f_shift*sl)];//スタート
        pos[4]=[tx*self.dev_grid_ico_outWH+opd+(t_shift*sl),ty*self.dev_grid_ico_outWH+opd+(t_shift*sl)];//END

        //中間点の描画
        pos[1]=[fx<=tx?pos[0][0]+opd:pos[0][0]-opd,pos[0][1]];
        pos[2]=[pos[1][0],pos[1][1]+(ty-fy)*opd*2-(ty-fy<0?-opd:+opd)];
        pos[3]=[pos[4][0],fy>ty?pos[4][1]+opd:pos[4][1]-opd];//+(t_shift*sl)
        if(fx<=tx){
            pos[2]=[pos[2][0],pos[3][1]];//重複時の補正
        };
        //データ方向をバインダーのdataflowに合わせる
        if(fx===to_flow_dev.owner.layout_x&&fy===to_flow_dev.owner.layout_y){
            pos.reverse();
        }

        //矢印の描画
        this.arrows.push(Bind_line_arrow_obj(pos[1],pos[2]));
        this.arrows.push(Bind_line_arrow_obj(pos[2],pos[3]));

        this.points=pos.join(" ");
    };
    //バインドの線の間の矢印
    function Bind_line_arrow_obj(start_pos,end_pos){
        var pos=[start_pos[0]+(end_pos[0]-start_pos[0])/2,start_pos[1]+(end_pos[1]-start_pos[1])/2];
        var deg=(end_pos[0]<start_pos[0]?180:0)+(end_pos[1]>start_pos[1]?90:0)+(end_pos[1]<start_pos[1]?-90:0);
        var rot='rotate('+deg+','+pos[0]+','+pos[1]+')';
        return {pos:pos,rot:rot};
    };


    //グリッドのドロップ時 デバイス移動・　//info::デバイスの入れ替えは廃止、代わりにバインド対象を絞ったバインド画面を表示
    self.grid_obj_drop=function(drag_grid_obj, drop_grid_obj){
        var from_dev=drag_grid_obj.device_obs();
        var to_dev=drop_grid_obj.device_obs();
        if(!from_dev||!to_dev){
          _dev_grid_swap_grid_obj(drag_grid_obj, drop_grid_obj);//デバイスアイコンの移動
        }else{
            if(from_dev.UID===to_dev.UID){return;}
            //info::KMシリーズのみの処理　例外的に同じKM同士をD&Dしたの場合はペアリングしているBLEデバイスのみ入れ替え
            if(from_dev.UIinfo.can_motor_grid_swap&&from_dev.UIinfo.can_motor_grid_swap&&from_dev.device_name ===to_dev.device_name){
                //KMシリーズのモーターのBLEデバイスの入れ替え
                DeviceController.ReplaceDeviceBLEDeviceKeiganMotor(from_dev,to_dev);
            }else{
                //2つのデバイス間にバインド対象を絞ったバインド画面を表示
                self.device_setting_tar(from_dev);
                self.device_RefineDevice_tar(to_dev);
                self.device_setting_tab_clicked(2);//デバイスタブ
                //_dev_grid_swap_grid_obj(drag_grid_obj, drop_grid_obj);//デバイスアイコンの入れ替え
            }
        }
    };
    self.grid_obj_dragStart=function(tar,event){
        self.device_setting_tar(null);
        tar.is_drag(true);
    };
    self.grid_obj_dragEnd=function(tar,event){
        tar.is_drag(false);
    };


    //編集画面の編集中リスト名
    //todo::関数の整理
    self.now_edit_list_name=ko.computed(function() {
        var dm=self.win_panel_num();//再評価用トリガになるトラッキングObservabl パネル切り替え毎に評価 todo::別名保存時に更新されない（評価しない為。画面切り替えで更新）
        var v=DeviceController.Controller_Get_state_info();
        return v?v.name:'';
    },this);

    //デバイスの選択リストのタブ
    self.device_add_type_tab=ko.observable(AbstractDeviceList_DeviceType.Input);
    /**
     * デバイスの選択リストの生成
     * @param device_type:AbstractDeviceList_DeviceType 取得するタイプ　nullの場合はInputCTL,Module,Otherのデバイス
     * @returns {Array}
     */
    self.get_device_add_selectlists=function(device_type){
        var ad_ls=[];
        for(var i=0;i<AbstractDeviceList.ClassOptions.length;i++){
            var t=AbstractDeviceList.ClassOptions[i];
            if(device_type){
                if(t.DeviceType===device_type){
                    ad_ls.push(t);
                }
            }else{
                if(t.DeviceType===AbstractDeviceList_DeviceType.Input||t.DeviceType===AbstractDeviceList_DeviceType.Module||t.DeviceType===AbstractDeviceList_DeviceType.Robot){
                    ad_ls.push(t);
                }
            }
        }
        return ad_ls;
    };

    self.device_add_placement_grid_data=ko.observable(null);//デバイスを配置する先のデバイスグリッド情報 info::注 XYが逆 device_add_placement_grid_data[Y][X]
    //デバイスグリッドの生成 10×10
    self.dev_grid_data=new Array(self.dev_grid_data_row);
    for(var i=0;i<self.dev_grid_data.length;i++){
        self.dev_grid_data[i]=new Array(self.dev_grid_data_clo);
        var sub=self.dev_grid_data[i];
        for(var m=0;m<sub.length;m++){
            var gi=new Grid_obj();
            gi.x=m;
            gi.y=i;
            sub[m]=gi;
        }
    }

    //デバイス間のバインドライン
    self.dev_grid_bind_lines=ko.observableArray();

    ////todo::イベントの発生順と表示更新の整理
    //編集画面遷移
    self.EventHandler.addListener(self.EventHandlerType.OnExitPanelChange_1,function(e){//画面離脱前
         _dev_grid_clear();
        //todo::離脱時の停止処理等
    });
    self.EventHandler.addListener(self.EventHandlerType.OnBeforPanelChange_1,function(e){//画面遷移前
        self.device_setting_full_size(false);
        self.device_setting_tar(null);
        self.device_add_placement_grid_data(null);
       // _dev_grid_clear();
    });
    self.EventHandler.addListener(self.EventHandlerType.OnAfterPanelChange_1,function(e){//画面遷移後
        _dev_list_refresh();
    });

    //コントローラーの初期化完了
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnInitComp,function(e){
      //  _dev_list_refresh();
    });

    //ビルトインデバイスが追加された
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnCreateBuiltinDevice,function(e){
      UTL_LOG("EV:DeviceController OnCreateBuiltinDevice //ビルトインデバイス生成完了");
    });
    //BLEデバイス再接続
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnReconnectBLEDevice,function(e){
        UTL_LOG("EV:DeviceController OnReconnectBLEDevice //BLEデバイス再接続");
        _dev_list_refresh();
        _ble_list_update_notify(e.BLEDeviceInfo);

    });
    //BLEデバイスが追加された　自動
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnCreateBLEDevice,function(e){
        UTL_LOG("EV:DeviceController OnCreateBLEDevice //BLEデバイス生成完了");
        _dev_list_refresh();
        setTimeout(function(){
            _ble_list_update_notify(e.BLEDeviceInfo);
        },700);

    });
    //デバイスが削除された
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnDelete,function(e){
        _dev_list_refresh();
    });
    //コントローラー状態復帰完了時の処理
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnStateLoadComp,function(e){
        UTL_LOG("EV:DeviceController OnStateLoadComp //コントローラー状態復帰完了時の処理");
        KMFarmVersionChecker.loadLatestFarmVersionTmplData();//最新ファームversionの取得をサーバーから行う
        DeviceController.CheckBLEDeviceStateAllUpdate(BLEPairingController.GetDeviceInfolist());
    });

    //モーターのペアリングしているBLEデバイス入れ替え
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnReplaceDeviceBLE,function(e){
        //info::既にLedStateColorの入れ替えで描画イベントが発生しているため、あえて描画処理はしない
       // _device_grid_update_notify();
    });



    /**
     * デバイス編集の保存
     */
    self.list_save_action=function () {
        //上書き・新規確認
        navigator.notification.confirm("",
            function(id){
                if(id===1){
                    navigator.notification.confirm("",
                        function(ids){
                            if(ids===1){
                                DeviceController.Controller_state_save_at(null,true);//上書き
                            }
                        },WORD('list_alert_conf_overw'),[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]//lang::上書きしますか？
                    );
                }else if(id===2){
                    //新規保存　名称入力
                    navigator.notification.prompt(
                        ""
                        ,function(results){
                            if(results.buttonIndex===1){
                                DeviceController.Controller_state_save_at(results.input1,false);
                                self.win_panel_num.notifySubscribers();
                            }
                        }
                        ,WORD('list_alert_inp_name')//lang::ロボットリスト 保存名入力
                        ,[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]
                        ,DeviceController.Controller_Get_state_info().name);
                }
            },WORD('com_alert_btn_title_save'),[WORD('com_alert_btn_overw'),WORD('com_alert_btn_saveas'),WORD('com_alert_btn_cancel')] //lang::上書き保存ボタン
        );

    };

   
    /**
     * デバイスの追加 画面
     */
    self.device_add_action=function(device,event){
        var tar_grid=self.device_add_placement_grid_data();
        var option={};
        //配置先がある場合は配置先の情報を付加して生成
        if(tar_grid){
            option.layout_x=tar_grid.x;
            option.layout_y=tar_grid.y;
        }
        DeviceController.AddDevice(device.device_name,option);

        //info::モーターのみ仮想モーターとしてダミーのBLEモーターデバイスを生成

        self.device_add_placement_grid_data(null);
        _dev_list_refresh();
    };

    /**
     * デバイスの削除
     */
    self.device_remove_action=function(device,event){
        navigator.notification.confirm(WORD('edit_alert_conf_delete'),//lang::削除してもよろしいですか？
            function(id){
                if(id==1){
                    self.device_setting_tar(null);
                    DeviceController.RemoveDevice(device);
                }
            },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]
        );

    };

    /**
     * デバイスのアイコンがクリックされた（仮想デバイス）
     */
    self.device_ico_exist_click_action=function(device){
        console.log("device_ico_exist_click_action");
        if(device){
            if(self.device_setting_tar.peek()==device){
                self.device_setting_tar(null);//設定パネル表示 トグル処理
            }else{
                self.device_setting_tar(device);//設定パネル表示
            }
        }else{
            //デバイスのアイコンがクリックされた（空のグリッド）
            if(self.device_setting_tar.peek()){
                self.device_setting_tar(null);
            }
        }
    };
    /**
     * デバイスのアイコンがtouchされた（仮想デバイス）
     */
    self.device_ico_exist_touch_action=function(device,event){
        if(event.eventType===1||event.eventType===4||event.eventType===8){
            console.log("device_ico_exist_lowinput_action "+event.eventType);
        }
        //info::iosドラッグ時の画面乱れ防止CSS用
        if(event.eventType===1){
            self.dev_grid_ico_moving(true);
        }else{
            self.dev_grid_ico_moving(false);
        }

    };
    //長押しでデバイス追加　//info::重複検知を防ぐ為、デバイスから指が離れた程度のディレイをかける
    self.device_ico_empty_hold_action=function(device,grid_obj){
        setTimeout(
            function(){
                self.device_ico_exist_click_action(null);//他のデバイス選択中なら解除しておく
                self.device_add_placement_grid_data(grid_obj);
            }
            ,200
        );
    };

    //ダブルタップでデバイス追加　//info::重複検知を防ぐ為、デバイスから指が離れた程度のディレイをかける
    self.device_ico_empty_doubletap_action=function(device,grid_obj){
        setTimeout(
            function(){
                self.device_ico_exist_click_action(null);//他のデバイス選択中なら解除しておく
                self.device_add_placement_grid_data(grid_obj);
            }
            ,200
        );
    };

    //--------------------//
    //section::デバイスグリッド関係
    //--------------------//
    /**
     * 指定のアイコン座標を画面中央にくるようにスクロールする
     * @param grid_obj
     * @private
     */
    function _dev_grid_scroll_center_at(x,y){
        var jq_dev_grid_wrap=$('#dev_grid_wrap');
        var disp_H=jq_dev_grid_wrap.outerHeight(true);//要素のmargin、border、paddingを含んだ高さ
        var disp_W=jq_dev_grid_wrap.outerWidth(true);
        var ico_H=self.dev_grid_ico_outWH;
        var ico_W=self.dev_grid_ico_outWH;
        var tx=x*self.dev_grid_ico_outWH;
        var ty=y*self.dev_grid_ico_outWH;
        jq_dev_grid_wrap.stop();
        jq_dev_grid_wrap.animate({scrollTop:ty-(disp_H/2)+(ico_H/2),scrollLeft:tx-(disp_W/2)+(ico_W/2)});
    }
    /**
     * 2つのアイコン座標を画面中央にくるようにスクロールする（バインド先選択時）
     * @param from_x,from_y,to_x,to_y
     * @private
     */
    function _dev_grid_scroll_center_both(from_x,from_y,to_x,to_y){
        console.log("_dev_grid_scroll_center_both");
        var jq_dev_grid_wrap=$('#dev_grid_wrap');
        var disp_H=jq_dev_grid_wrap.outerHeight(true);
        var disp_W=jq_dev_grid_wrap.outerWidth(true);
        var ico_H=self.dev_grid_ico_outWH;
        var ico_W=self.dev_grid_ico_outWH;
        var from_pos={left:from_x*self.dev_grid_ico_outWH,top:from_y*self.dev_grid_ico_outWH};
        var to_pos={left:to_x*self.dev_grid_ico_outWH,top:to_y*self.dev_grid_ico_outWH};
        var tw=Math.abs(from_pos.left-to_pos.left)+ico_W;
        var th=Math.abs(from_pos.top-to_pos.top)+ico_H;
        var tx=(from_pos.left+to_pos.left)/2;
        var ty=(from_pos.top+to_pos.top)/2 ;
        var of_W=tw-disp_W;
        var of_H=th-disp_H;
        var pw=0; var ph=0;

        //info::両方のアイコンが画面に入りきらない場合、to側が表示されるようにto側に寄せる
        if(of_W>0){
            pw=from_pos.left>to_pos.left?-of_W:of_W;
        }
        if(of_H>0){
            ph=from_pos.top>to_pos.top?-of_H:of_H;
        }
        jq_dev_grid_wrap.stop();
        jq_dev_grid_wrap.animate({scrollTop:ty-(disp_H/2)+(ico_H/2)+ph,scrollLeft:tx-(disp_W/2)+(ico_W/2)+pw});
    }

    /**
     * 2つのアイコン座標間にターゲット線を引く
     * @param from_x,from_y,to_x,to_y
     * @private
     */
    function _dev_grid_drow_both_target_line(from_x,from_y,to_x,to_y){
        var jq_both_target_line=$('#dev_grid_both_target_line');
        var ico_H=self.dev_grid_ico_outWH;
        var ico_W=self.dev_grid_ico_outWH;
        //中心点の座標と角度を求め、配置・回転する
        var from_pos={left:from_x*self.dev_grid_ico_outWH,top:from_y*self.dev_grid_ico_outWH};
        var to_pos={left:to_x*self.dev_grid_ico_outWH,top:to_y*self.dev_grid_ico_outWH};
        var two_point=UTL_two_point_dist_angle(from_pos.left,from_pos.top,to_pos.left,to_pos.top);//2点間の距離と角度
        var center_x=(Math.max(from_pos.left,to_pos.left)-Math.min(from_pos.left,to_pos.left))/2 + Math.min(from_pos.left,to_pos.left)+ico_W/2;
        var center_y=(Math.max(from_pos.top,to_pos.top)-Math.min(from_pos.top,to_pos.top))/2 + Math.min(from_pos.top,to_pos.top)+ico_H/2;
        var scale=two_point.dist/10;

       // jq_both_target_line.css({transform:'translate('+center_x+'px,'+center_y+'px) rotate('+two_point.radi+'rad) scaleX('+scale+')'});
        jq_both_target_line.css({transform:'translate('+(center_x-10*scale*0.5)+'px,'+center_y+'px) rotate('+two_point.radi+'rad) ',width:10*scale});
        jq_both_target_line.show();
    };

    // // todo::debug::2つのアイコン座標間にターゲット線を引く（デバイスオブジェクトで指定版）
    // function _dev_grid_drow_both_target_line_from_deviceobj(from_dev,to_dev){
    //
    //     _dev_grid_scroll_center_both(from_dev.layout_x,from_dev.layout_y,to_dev.layout_x,to_dev.layout_y);//info::両方のアイコンが画面に入るように
    //     _dev_grid_drow_both_target_line(from_dev.layout_x,from_dev.layout_y,to_dev.layout_x,to_dev.layout_y);//info::2つのアイコン座標間にターゲット線を引く
    // }



    /**
     * ターゲット線のクリアー
     * @private
     */
    function _dev_grid_clear_both_target_line(){
        var jq_both_target_line=$('#dev_grid_both_target_line');
        jq_both_target_line.hide();
    };


    /**
     * デバイスグリッドの全消去
     * @private
     */
    function _dev_grid_clear(){
        for(var i=0;i<self.dev_grid_data.length;i++){
            var sub=self.dev_grid_data[i];
            for(var m=0;m<sub.length;m++){
                sub[m].device_obs(null);
            }
        }
    }

    /**
     * デバイスグリッドへのデバイスの追加
     *
     */
    function _dev_grid_add(device){
        if(device){
            //場所の重複時には空きスペースを指定
            if(self.dev_grid_data[device.layout_y][device.layout_x].device_obs.peek()){
                var pos=_dev_grid_space();
                if(pos){
                    device.layout_y=pos.y;
                    device.layout_x=pos.x;
                }
            }
        //   self.dev_grid_data[device.layout_y][device.layout_x].device_obs.extend({rateLimit: 50});
            self.dev_grid_data[device.layout_y][device.layout_x].device_obs(device);
        }
        //todo::結線の更新
    }



    /**
     * グリッドの入れ替え
     * @param from_grid_obj
     * @param to_grid_obj
     * @private
     */
    function _dev_grid_swap_grid_obj(from_grid_obj,to_grid_obj){
       if(!(from_grid_obj instanceof Grid_obj) || !(to_grid_obj instanceof Grid_obj)){return;}
            var from_dev=from_grid_obj.device_obs();
            var to_dev=to_grid_obj.device_obs();

            //デバイスの座標更新
            if(from_dev){
                from_dev.layout_y=to_grid_obj.y;
                from_dev.layout_x=to_grid_obj.x;
            }
            if(to_dev){
                to_dev.layout_y=from_grid_obj.y;
                to_dev.layout_x=from_grid_obj.x;
            }
            //グリッドの入れ替え
            to_grid_obj.device_obs(from_dev);
            from_grid_obj.device_obs(to_dev);
            //結線の更新
            _dev_grid_refresh_bind_line();
    }

    /**
     * デバイスグリッドの空きスペースの検索
     */
    function _dev_grid_space(){
        for(var i=0;i<self.dev_grid_data.length;i++){
            var sub=self.dev_grid_data[i];
            for(var m=0;m<sub.length;m++){
                if(!sub[m].device_obs.peek()){
                    return {x:m,y:i};
                }
            }
        }
        return null;
    }

    /**
     * デバイスグリッドの結線(バインド線)の描画
     * @private
     */
    var _dev_grid_bind_line_cash={};//キャッシュ用
    var _dev_grid_bind_line_shift=[];//線の重複回避用
    function _dev_grid_refresh_bind_line(){
       // console.log("_dev_grid_refresh_bind_line");
        self.dev_grid_bind_lines.removeAll();
        _dev_grid_bind_line_shift=new Array(self.dev_grid_data_clo).fill(0).map(function(x){return new Array(self.dev_grid_data_row).fill(0)});//info::注 XYが逆　_dev_grid_bind_line_shift[Y][X]
        _dev_grid_bind_line_cash={};
        // for (var i=0;i<DeviceValBinder_Binder_AllList.length;i++){}
        var devices=DeviceController.GetDevicelist();
        for(var i=0;i<devices.length;i++){
           var device= devices[i];
           var binders= device.GetBinderList();
            for(var m=0;m<binders.length;m++){
                //自身とバインド先を1対として、バインドの線描画オブジェクトを生成
                var binder=binders[m];
                var hash=binder.device_innerid+'_'+binder.binder_name;
                if(!binder.is_bind){continue;}
                if(_dev_grid_bind_line_cash[hash]){continue;}
                var obj=new Bind_line_obj(binder,_dev_grid_bind_line_shift);
                _dev_grid_bind_line_cash[hash]=obj;
                _dev_grid_bind_line_cash[binder.target_ref.device_innerid+'_'+binder.target_ref.binder_name]=obj;
                self.dev_grid_bind_lines.push(obj);
            }
        }
    }

    //--------------------//
    //section::表示更新関係
    //--------------------//

    ///info::KMのLED変更が変わった場合のアイコン更新処理
    // AbstractDeviceList.EventHandler.addListener(AbstractDeviceList.EventHandlerType.OnIconViewLedStateReDrowCall,function(e){
    //     _device_grid_update_notify(e.device);
    //     //_dev_grid_refresh_bind_line();//グリッド結線の更新
    // });
    
    ///info::ボタン、trace等のアイコン状態の表示が変わった場合のアイコン更新処理
    AbstractDeviceList.EventHandler.addListener(AbstractDeviceList.EventHandlerType.OnIconViewReDrowCall,function(e){
        var device= e.device;
        _device_grid_update_notify(device);
    });
    ///info::グリッド結線の更新処理
    AbstractDeviceList.EventHandler.addListener(AbstractDeviceList.EventHandlerType.OnBindLineViewReDrowCall,function(e){
        _dev_grid_refresh_bind_line();//グリッド結線の更新
    });

    /**
     * デバイスグリッドに配置されているデバイスのアイコン表示更新
     * @param device 更新する対象のデバイス nullの場合は全てが対象
     * @private
     */
    function _device_grid_update_notify(device){
        if(self.win_panel_num()!=1){return;}//編集画面の時のみ更新
        //console.log("_device_grid_update_notify:"+device);//todo::debug
        if(device){

            var tx= device.layout_x;
            var ty= device.layout_y;
            if(self.dev_grid_data[ty][tx]){
                //ドラッグ中はアイコンを更新しない
                if(self.dev_grid_data[ty][tx].is_drag()){
                   // console.log("ドラッグ中");
                    return;
                }
                self.dev_grid_data[ty][tx].device_obs.notifySubscribers();
            };
        }else{//nullの場合は全てが対象
            for(var i=0;i<self.dev_grid_data.length;i++){
                var sub=self.dev_grid_data[i];
                for(var m=0;m<sub.length;m++){
                    var tg=sub[m].device_obs.peek();
                    if(tg){

                        if(sub[m].is_drag()){return;}//ドラッグ中はアイコンを更新しない
                        sub[m].device_obs.notifySubscribers();
                    }
                }
            }
        }
    };

    /**
     * デバイスリストのリフレッシュ（ビルトインとBLE）
     * @private
     */
    function _dev_list_refresh(){
        if(self.win_panel_num()!=1){return;}//編集画面の時のみ更新
        //console.log("_dev_list_refresh");//info::debug用
        _dev_grid_clear();
        var ls=DeviceController.GetDevicelist();
        for(var i=0;i<ls.length;i++){
            //todo::現状は読み込み順に追加。ここで座標の重複したデバイスを予め判定して、最後に追加する処理を検討する
            _dev_grid_add(ls[i]);
        }
        _dev_grid_refresh_bind_line();
    };

    // -------------------//
    // section:: デバイス詳細オプション・バインド 各種
    //--------------------//
    self.device_binding_action_visible=ko.observable();
    self._device_setting_tar=ko.observable();
    self.device_setting_tar_publish_UI_prop_list=ko.observableArray();//公開プロパティ一覧
    self.device_setting_tar_binder_list=ko.observableArray();//デバイスの内包するバインダー一覧
    self.device_setting_tab=ko.observable();
    self.device_setting_full_size=ko.observable();//設定パネルのフルサイズ化
    self.device_binding_match_binder_list=ko.observableArray();//バインド先の適合バインダー一覧
    self._device_binding_tar=ko.observable(null);
    self._device_binding_tar_select=ko.observable(null);
    self.show_motor_Register_setting_panel_flg=ko.observable(null);//モータのレジスタ設定用パネル
    //Advance機能の表示の有無
    self._device_show_ui_category_Advance=ko.observable((typeof UTL_load_storage('device_show_ui_category_Advance')=="boolean"?UTL_load_storage('device_show_ui_category_Advance'):false));
    self.device_show_ui_category_Advance = ko.computed({
        read: function () {
            return  self._device_show_ui_category_Advance();
        },write:function(val){
            var s=(val?true:false);
            UTL_save_storage('device_show_ui_category_Advance',s);
            self._device_show_ui_category_Advance(s);
        },
        owner: this}
    );


    //バインド可能先の絞り込み指定用device
    self.device_RefineDevice_tar=ko.observable();//info::device_setting_tar変更時にクリアーされる為、device_setting_tar指定後に指定する
    //デバイス設定表示
    self.device_setting_tar= ko.pureComputed({
        read: function () {
            return self._device_setting_tar();
        },write:function(device){
            self.device_binding_tar(null);
            self.device_RefineDevice_tar(null);
            //デバイスの公開プロパティとバインダーの列挙
            self._device_setting_tar(device);
            self.device_setting_tar_publish_UI_prop_list.removeAll();
            self.device_setting_tar_binder_list.removeAll();

            // var RefineDevice=self.device_RefineDevice_tar();//todo::バグ::この関数後に設定される為意味が無い
            if(device){

                self.device_setting_tab(1);//デフォルトタブ表示 setting
                var ppl= device.GetPublishUIPropList();
                for(var i=0;i<ppl.length;i++){
                    self.device_setting_tar_publish_UI_prop_list.push(ko.observable(ppl[i]));
                }
                var bil= device.GetBinderList();
                for(var i=0;i<bil.length;i++){
                    // //todo::絞り込みオプションdevice_RefineDevice_tarに絞り込み対象のdeviceがある場合は、バインド可能対象のあるバインダーのみ表示する
                    // //
                    // if(RefineDevice && bil[i].GetCanBindingList(false,RefineDevice).length<1){
                    //     continue;
                    // }
                    self.device_setting_tar_binder_list.push(ko.observable(bil[i]));
                }
                _dev_grid_scroll_center_at(device.layout_x,device.layout_y);//対象デバイスを画面中央に
            }else{
                //デバイス設定小窓を閉じた場合
                self.device_binding_tar_select(null);
            }
        },
        owner: this}
    );
    
    //バインド先のバインダーのデバイス選択
    self.device_binding_tar_select= ko.pureComputed({
        read: function () {
            return self._device_binding_tar_select();
        },write:function(to_binder){
            self._device_binding_tar_select(to_binder);
        },
        owner: this}
    );

    //バインド可能先
    self.device_binding_tar= ko.pureComputed({
        read: function () {
            return self._device_binding_tar();
        },write:function(from_binder){
            self._device_binding_tar(from_binder);
            //info::絞り込みオプションdevice_RefineDevice_tarに絞り込み対象のdeviceがある場合は、バインド可能対象をそのdeviceのみに絞り込む
            if(from_binder instanceof DeviceValBinder){
                var RefineDevice=self.device_RefineDevice_tar();//todo::以前の展開済みのバインダーの画面が更新されない
                //適合バインダーの列挙
                self.device_binding_match_binder_list.removeAll();
                var rs= from_binder.GetCanBindingList(false,RefineDevice);
                self.device_binding_match_binder_list(rs);
            }
            self.device_binding_tar_select(null);
        }
        ,owner: this}
    );


    ///UI上で2つのデバイスが指定された場合に、そのデバイスのアイコンを画面中央にして、アイコン間にターゲット線を表示する
    ko.computed(function(){
        //console.log("ko.computed");
        var from_dev=self.device_setting_tar();
        var to_binder=self.device_binding_tar_select();
        var ref_dev=self.device_RefineDevice_tar();//バインド先の対象をこのデバイスに制限する指定（オプション）
        //info::device_RefineDevice_tarの指定がある場合は2つのターゲットは固定なので、device_RefineDevice_tarの指定が無くなるまでターゲット線を表示し続ける
        if(to_binder||ref_dev){
            var to_dev=to_binder?to_binder.owner:ref_dev;
            _dev_grid_scroll_center_both(from_dev.layout_x,from_dev.layout_y,to_dev.layout_x,to_dev.layout_y);//info::両方のアイコンが画面に入るように
            _dev_grid_drow_both_target_line(from_dev.layout_x,from_dev.layout_y,to_dev.layout_x,to_dev.layout_y);//info::2つのアイコン座標間にターゲット線を引く
        }else{
            //_dev_grid_scroll_center_at(from_dev.layout_x,from_dev.layout_y);
            _dev_grid_clear_both_target_line();
        }
    },self);
    ///////UIからのアクション関数

    //UIからのタブの切り替え押下
    self.device_setting_tab_clicked=function(val){
        //同じタブをクリックした場合はタブ以下の領域の伸張トグル表示
        if(self.device_setting_tab()==val){
            self.device_setting_full_size(! self.device_setting_full_size());
        }else{
            self.device_setting_tab(val);
        }
    };
    //バインダー(元)のリスト選択
    self.device_binder_list_click_action=function(from_binder,t_data,event){
        console.log("device_binder_list_click_action");
        if(self.device_binding_tar()==from_binder){
            self.device_binding_tar(null);//バインド先展開表示 トグル処理
        }else{
            self.device_binding_tar(from_binder);//バインド先展開表示
        }
        
        //info::選択したリストを一番上にスクロール
        var tar_jq=$(event.currentTarget).parent();
        var tar_pos=(tar_jq.offset().top-tar_jq.parent().offset().top);
      //  $('#device_setting').scrollTop(tar_pos);
        $('#device_setting').animate({
            scrollTop : tar_pos
        }, {
            queue : false
        });
    };

    //バインダー先のバインドリスト選択
    self.device_binding_tar_list_click_action=function(to_binder){
       // console.log("device_binding_tar_list_click_action");
        self.device_binding_tar_select(to_binder);//選択時　バインド先のアイコンをマーク表示
    };

    //バインダー先のリストのリンクボタン選択
    self.device_binding_tar_linkbtn_click_action=function(to_binder){
        self.device_binding_tar_select(to_binder);//選択時　バインド先のアイコンをマーク表示
        //バインド済みならバインド解除に
        if(self.device_binding_tar().IsBindingTargetEq(to_binder)){
            self.to_un_bind_action(to_binder);
        }else{
            self.to_bind(to_binder);
        }
    };
    //バインド解除
    self.to_un_bind_action=function(DeviceValBinderIns){
        navigator.notification.confirm(WORD('edit_alert_conf_unbind'),//lang::仮想デバイスバインド解除
            function(id){
                if(id==1){
                    self.to_un_bind(DeviceValBinderIns);
                }
            },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]//lang::アラートOk Cancel
        );

    };

    //選択したバインダーとのバインド
    self.to_bind=function(DeviceValBinderIns){
        var tget=self.device_binding_tar();
        tget.Binding(DeviceValBinderIns);
       // self.device_binding_tar(null);//リストを閉じる
        //バインドの表示を更新
        ko.utils.arrayForEach(self.device_setting_tar_binder_list(), function(item, index){
            // if(item()===tget){
            //     item.notifySubscribers();//バインドの表示を更新
            //
            // }
            item.notifySubscribers();//バインドの表示を更新
        });
        _device_grid_update_notify(tget.owner);//グリッドのアイコン表示更新
        _device_grid_update_notify(DeviceValBinderIns.owner);
        _dev_grid_refresh_bind_line();//グリッド結線の更新

    };

    self.to_un_bind=function(DeviceValBinderIns){
       var un_binding_ref= DeviceValBinderIns.UnBinding();
        //self.device_binding_tar(null);//リストを閉じる
        ko.utils.arrayForEach(self.device_setting_tar_binder_list(), function(item, index){
            item.notifySubscribers();//バインドの表示を更新
            // if(item()===DeviceValBinderIns){
            //    item.notifySubscribers();//バインドの表示を更新
            // }
        });
        _device_grid_update_notify(DeviceValBinderIns.owner);//グリッドのアイコン表示更新
        _device_grid_update_notify(un_binding_ref.un_binding_binder.owner);
        _dev_grid_refresh_bind_line();//グリッド結線の更新
    };


    //-------------------//
    //section::デバイス保存リスト
    //--------------------//
    self.dev_preset_list=ko.observableArray();
    self.dev_tmpl_list=ko.observableArray();//info::ロボットテンプレ
    self.dev_tmpl_list_loader_err=ko.observable(false);//ローダーエラー

    self.dev_save_list=ko.observableArray(DeviceController.Controller_Get_state_index_list());

    // //ペアリング画面遷移後
    // self.EventHandler.addListener(self.EventHandlerType.OnAfterPanelChange_4,function(e){
    //     //topへスクロール
    //     $("#dev_save_list_wrap").scrollTop(0);
    // });

    //リスト共有モード ロボットデータのshare時にdropbox等のファイルベースの共有を可能。　データのみ(メール等でコピペ) or ファイル形式(dropbox等で共有）
    self._dev_share_mode=ko.observable((typeof UTL_load_storage('dev_share_mode')=="boolean"?UTL_load_storage('dev_share_mode'):true));
    self.dev_share_mode = ko.computed({
        read: function () {
            return  self._dev_share_mode();
        },write:function(val){
            var s=(val?true:false);
            UTL_save_storage('dev_share_mode',s);
            self._dev_share_mode(s);
        },
        owner: this}
    );


    //デバイス編集の別名保存完了時
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnStateSaveAtComp,function(e){
        //UTL_LOG("デバイス編集の保存完了 "+JSON.stringify(e));
        self.dev_save_list.removeAll();
        self.dev_save_list(DeviceController.Controller_Get_state_index_list());
    });
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnDeleteStateIndexListAtComp,function(e){
        //UTL_LOG("デバイスリストの削除完了 "+JSON.stringify(e));
        self.dev_save_list.removeAll();
        self.dev_save_list(DeviceController.Controller_Get_state_index_list());
    });
    //デバイスリストのロード完了 ペアリングを解除しアプリを再起動
    DeviceController.EventHandler.addListener(DeviceController.EventHandlerType.OnStateLoadAtComp,function(e){
        //UTL_LOG("デバイスリストのロード完了 "+JSON.stringify(e));
        //info::この時点でアンロード時のデータは自動保存されない。
        //info::アプリを再起動（読み直し）する必要がある。
        BLEPairingController.EventHandler.addListener(BLEPairingController.EventHandlerType.OnClearDeviceComp,function(e){
            location.reload();
            // if(navigator.app && navigator.app.loadUrl){
            //     //navigator.app.exitApp();//android
            //     navigator.app.loadUrl(window.location.href, {wait:1500, loadingDialog:"Re,Loading App",clearHistory:true});
            //
            // }else{
            //     location.reload();//ios
            // }
        });
        BLEPairingController.ClearDevice();
    });


    /**
     * デバイス保存リストの選択時に復帰する
     */
    self.dev_save_list_select_action=function(_state_index_list,event){
        navigator.notification.confirm(WORD('list_alert_conf_load_ovw'),//lang::ロボットリスト 上書きロード
            function(id){
                if(id==1){
                    DeviceController.Controller_state_load_at(_state_index_list.uid);
                }
            },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]//lang::アラートOk Cancel
        );

    };

    /**
     * 新規作成
     * @param _state_index_list
     * @param event
     */
    self.dev_new_list_select_action=function(data,event){
        navigator.notification.confirm(WORD('list_alert_conf_new_ovw'),//lang::ロボットリスト 新規作成
            function(id){
                if(id==1){
                    DeviceController.Controller_state_load_at(null);
                }
            },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]//lang::アラートOk Cancel
        );
    };
    /**
     * デバイス保存リストの削除
     */
    self.dev_save_list_remove_action=function(_state_index_list,event){
        navigator.notification.confirm(WORD('list_alert_conf_delete'),//lang::ロボットリスト 削除
            function(id){
                if(id==1){
                    DeviceController.Controller_Delete_state_index_list_at(_state_index_list.uid);
                }
            },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]//lang::アラートOk Cancel
        );
    };
    /**
     * デバイスデータの外部出力
     */
    self.dev_save_list_export_action=function(_state_index_list,event){
      var jsondata=  DeviceController.Controller_state_export_json_at(_state_index_list.uid);
       // var b64str=LZString.compressToBase64(jsondata);
        var b64str=LZString.compressToEncodedURIComponent(jsondata);
        navigator.notification.prompt("Export data",
            function(id){

            },"",['Close'],b64str
        );
    };
    /**
     * デバイスデータの外部共有
     * info:: .kcoreのfile出力と"keigan-motor-app://"のスキームの両方に対応
     */


    self.dev_save_list_share_action=function(_state_index_list,event){
        console.log("dev_save_list_share_action");
        var jsondata=  DeviceController.Controller_state_export_json_at(_state_index_list.uid);
        //var b64str=LZString.compressToBase64(jsondata);
        var b64str=LZString.compressToEncodedURIComponent(jsondata);
     
        //info::リスト共有モード別の処理
        // window.plugins.socialsharing.share(_state_index_list.name,_state_index_list.name,null,URL_SCHEME+b64str);//info::カスタムurlスキームはFB等共有出来ないアプリが多い
        if(self.dev_share_mode()){
            //ファイルベースでの共有 　ロボットデータのshare時にdropbox等のファイルベースの共有を可能
            var f_name =_state_index_list.name+'.'+EXT_NAME;
            var f_name = f_name+'.'+EXT_NAME;//info::googl drive対策　同じ拡張子を2つ付加
            UTL_save_filesys(cordova.file.cacheDirectory,f_name,b64str,function(v){
                if(v){

                    var options = {
                        message: _state_index_list.name, // not supported on some apps (Facebook, Instagram)
                        subject: null, // fi. for email
                        // files: ['data:text/plain,'+b64str], // an array of filenames either locally or remotely
                        files:[cordova.file.cacheDirectory+f_name],
                        //url:cordova.file.cacheDirectory+f_name,
                        url:null,
                        chooserTitle: 'Pick an app' // Android only, you can override the default share sheet title
                    };
                    var onSuccess = function(result) {
                        console.log("Share completed? " + result.completed); // On Android apps mostly return false even while it's true
                        console.log("Shared to app: " + result.app); // On Android result.app is currently empty. On iOS it's empty when sharing is cancelled (result.completed=false)
                    };

                    var onError = function(msg) {
                        console.log("Sharing failed with message: " + msg);
                    };
                    window.plugins.socialsharing.shareWithOptions(options, onSuccess, onError);
                  
                }
            });
        }else{
            //urlスキーム付きのデータのみの共有
            var f_name=_state_index_list.name;
                var options = {
                    message: URL_SCHEME+b64str, // not supported on some apps (Facebook, Instagram)
                    subject: f_name, // fi. for email
                    //files: ['data:text/plain,'+b64str], // an array of filenames either locally or remotely
                    files:null,
                    //url:cordova.file.cacheDirectory+f_name,
                    url:null,
                    chooserTitle: 'Pick an app' // Android only, you can override the default share sheet title
                };
                var onSuccess = function(result) {
                    console.log("Share completed? " + result.completed); // On Android apps mostly return false even while it's true
                    console.log("Shared to app: " + result.app); // On Android result.app is currently empty. On iOS it's empty when sharing is cancelled (result.completed=false)
                };

                var onError = function(msg) {
                    console.log("Sharing failed with message: " + msg);
                };
                window.plugins.socialsharing.shareWithOptions(options, onSuccess, onError);
            }



    };
    /**
     * デバイスデータの外部取り込み
     */
    self.dev_save_list_input_action=function(_state_index_list,event){
        bootbox.prompt(
            {
                title:"Input data",
                buttons: {
                    cancel: {
                        label: '<i class="fa fa-times"></i>'+WORD('com_alert_btn_cancel')
                    },
                    confirm: {
                        label: '<i class="fa fa-check"></i>'+WORD('com_alert_btn_ok')
                    }
                },
                callback:function(result) {
                    if (result) {
                        self.dev_save_list_input(result);
                    }
                }
            });

        // navigator.notification.prompt("Input data",
        //     function(results){
        //         if(results.buttonIndex==1){
        //             self.dev_save_list_input(results.input1);
        //         }
        //     },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')],""
        // );


    };
    /**
     * ロボットテンプレのAJAXロード
     */
    self.dev_save_list_load_tmpl_list=function(vm,ev){
            var url_str=UTL_add_getquery_prm(ROBO_TEMPLATE_URL,'lang',LANGUAGE);//リンク先URLに現在の選択言語を付加してジャンプする
                url_str=UTL_add_getquery_prm(url_str,'datavar',ROBO_DATA_VAR);

            var btn_jq=$(ev.target);
            $.getJSON(url_str, function() {
                btn_jq.button('loading');
            }).done(function(json) {
                //テンプレートの
                
                
                self.dev_tmpl_list(json);
                self.dev_tmpl_list_loader_err(false);
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                // console.log("エラー：" + textStatus);
                // console.log("テキスト：" + jqXHR.responseText);
                self.dev_tmpl_list_loader_err(true);
            })
            .always(function() {
                setTimeout(function() {
                    btn_jq.button('reset');
                }, 1000);
            });
    };
    /**
     *  テンプレートからのデータの取り込み
     */
    self.dev_save_list_tmpl_input_action=function(data_val){
        self.dev_save_list_input(data_val);
    };

    /**
     * デバイスデータの外部取り込み
     * @param stream
     */
    self.dev_save_list_input=function(stream){
        var b64str=(stream.indexOf(URL_SCHEME)!==-1?stream.slice(URL_SCHEME.length+stream.indexOf(URL_SCHEME)):stream);//URLスキーム付きはプロトコルとデータを分離
        //var json_str = LZString.decompressFromBase64(b64str);
        var json_str = LZString.decompressFromEncodedURIComponent(b64str);
        try{
            var res=JSON.parse(json_str);
            //info::データヴァージョンの互換チェック(201707定義) 同じヴァージョンのみ
            if( UTL_N(res.DATA_VAR) != UTL_N(ROBO_DATA_VAR)){
                navigator.notification.alert(WORD('list_alert_conf_datavarerr',{robo_data_var:ROBO_DATA_VAR,data_var:res.DATA_VAR}),null,"",['Ok']);//lang::ロボットリスト データヴァージョンエラー
                return;
            }
            if(res.name){
                navigator.notification.confirm(WORD('list_alert_conf_inpdata',{name:res.name}),//lang::{{name}} をリストに読みこみます。よろしいですか
                    function(id){
                        if(id==1){
                            DeviceController.Controller_state_data_inport(res);//デバイスリストに保存
                            // navigator.notification.alert("Import completed",null,"",['Ok']);
                            self.win_panel_num(4);//リスト画面へ遷移
                            $("#dev_save_list_wrap").scrollTop(0);//topへスクロール
                        }
                    },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]
                );
            }else{
                navigator.notification.alert(WORD('list_alert_conf_dataerr'),null,"",['Ok']);//lang::ロボットリスト データ取り込みエラー
            }
        }catch (e){
            navigator.notification.alert(WORD('list_alert_conf_dataerr'),null,"",['Ok']);//lang::ロボットリスト データ取り込みエラー
        }
    };

    //画面遷移イベント(デバイス保存リスト)
    self.EventHandler.addListener(self.EventHandlerType.OnAfterPanelChange_4,function(e){//画面遷移後
        //self.dev_save_list_preset_load();
       // self.dev_save_list_load_tmpl_list();//テンプレートのロード
    });

    //-------------------//
    //section::再生画面
    //--------------------//
    self.dev_play_ui_list=ko.observableArray();
    //編集切り替え
    self._dev_play_ui_editmode=ko.observable(false);
    self.dev_play_ui_editmode= ko.computed({
        read: function () {
            return self._dev_play_ui_editmode();
        },write:function(val){
            self._dev_play_ui_editmode(val);
            self.dev_play_ui_refresh();
        }
    });

    //再生画面の更新
    self.dev_play_ui_refresh=function(){
        if(self.win_panel_num()==2){
            self.dev_play_ui_list(null);
            var list=DeviceController.GetDevicelist();
            list.sort(function(a, b){
                return a.device_ui_order - b.device_ui_order ;
            });
            self.dev_play_ui_list(list);
        };
    };

    //画面遷移イベント(再生画面イベント)
    self.EventHandler.addListener(self.EventHandlerType.OnExitPanelChange_2,function(e){//画面離脱前
        //todo::離脱時の停止処理等
    });
    self.EventHandler.addListener(self.EventHandlerType.OnBeforPanelChange_2,function(e){//画面遷移前

    });
    self.EventHandler.addListener(self.EventHandlerType.OnAfterPanelChange_2,function(e){//画面遷移後
        //再生画面の更新
        var list=DeviceController.GetDevicelist();
        list.sort(function(a, b){
            return a.device_ui_order - b.device_ui_order ;
        });
        self.dev_play_ui_list(list);
        self.dev_play_ui_refresh();
    });

    
    //リサイズハンドル操作（ドラッグ開始）
    self.dev_play_edit_resize_handle_dragstart=function(device, event,element){
        self.resize_handle_data.target_dom=$(event.target).parent().parent();
       // self.resize_handle_data.target_dom=$(event.srcEvent.currentTarget).parent();
        self.resize_handle_data.t_width=self.resize_handle_data.target_dom.outerWidth();
        self.resize_handle_data.t_height=self.resize_handle_data.target_dom.height();
    };
    //リサイズハンドル操作（ドラッグ中）
    self.resize_handle_data={target_dom:null,t_width:0,t_height:0};
    self.dev_play_edit_resize_handle_drag=function(data, event,element){
        //console.log("dev_play_edit_resize_handle_drag eventType: deltaX:"+event.gesture.deltaX+" center.pageX:"+event.gesture.center.pageX);
        if(self.resize_handle_data.target_dom){
            self.resize_handle_data.target_dom.width(self.resize_handle_data.t_width+event.deltaX);
            self.resize_handle_data.target_dom.height(self.resize_handle_data.t_height+event.deltaY);
        };
    };
    //リサイズハンドル操作（ドラッグ終了）
    self.dev_play_edit_resize_handle_dragend=function(device, event,element){
       // console.log("dev_play_edit_resize_handle_dragend");
       //  //現在の親のサイズから自分のサイズを%に変換し格納 info::複数デバイスでのデータ交換の為、相対サイズが必要
       //  var sw=self.resize_handle_data.target_dom.parent().innerWidth();
       //  var sh=self.resize_handle_data.target_dom.parent().innerHeight();
       //  var pw=Math.floor(self.resize_handle_data.target_dom.innerWidth()*100/sw);
       //  var ph=Math.floor(self.resize_handle_data.target_dom.innerHeight()*100/sh);
       // device.device_ui_size_par={width:pw+'%',height:ph+'%'};
        //  self.resize_handle_data.target_dom.css({width:pw+'%',height:ph+'%'});//編集中

        //計算ズレの為相対サイズに
        device.device_ui_size_px={width:self.resize_handle_data.target_dom.innerWidth()+'px',height:self.resize_handle_data.target_dom.innerHeight()+'px'};


        self.resize_handle_data.target_dom=null;
       // self.dev_play_ui_refresh();
    };
    // self.dev_play_edit_resize_handle_dragleave=function(device, event){
    //    // console.log("dev_play_edit_resize_handle_dragleave:");
    //     self.resize_handle_data.target_dom=null;
    // };

    
    //編集時ドロップUI入れ替え
    self.dev_play_edit_drop=function(from_data, to_data){
        if(from_data.item===to_data.item ||!this.data.tar_over_l_r){return;}
        var del_idx=self.dev_play_ui_list.indexOf(from_data.item);
        self.dev_play_ui_list.splice(del_idx,1);
        var ins_idx=self.dev_play_ui_list.indexOf(to_data.item);
        self.dev_play_ui_list.splice(ins_idx+(this.data.tar_over_l_r<0?0:1),0,from_data.item);

        //順番のインデックスを保存
        ko.utils.arrayForEach(self.dev_play_ui_list(), function(device,idx) {
            device.device_ui_order=idx;
        });
    };
    self.dev_play_edit_dragStart=function(data,event){

        if ( $(event.target).hasClass("drag_handle")) {
            data.is_drag=true;
            return true;
        } else {
            return false;
        }
    
    };
    self.dev_play_edit_dragEnd=function(data,event){

        data.is_drag=false;
        $(this.element).toggleClass('over_left',false);
        $(this.element).toggleClass('over_right',false);
    };
    self.dev_play_edit_dragOver = function (event, dragData, zoneData) {
        if(dragData.item===zoneData.item){return;}
        // var ch_sw=(event.pageX-(this.left+(this.width/2)));
        var ch_sw=(event.touches[0].pageX-(this.left+(this.width/2)));
        var tar_over_l_r=ch_sw>0?1:(ch_sw<0?-1:0);//info::ドラッグOVER位置がターゲットの左よりか右寄りか
        this.data['tar_over_l_r']=tar_over_l_r;
        $(this.element).toggleClass('over_left',tar_over_l_r===-1);
        $(this.element).toggleClass('over_right',tar_over_l_r===1);

    };
    //ドラッグしながら通り過ぎた
    self.dev_play_edit_dragLeave = function (event, dragData, zoneData) {
        $(this.element).toggleClass('over_left',false);
        $(this.element).toggleClass('over_right',false);
    };
    
    //-------------------//
    //section::その他
    //--------------------//
    /**
     * サイトへのリンク
     * info::リンク先URLに現在の選択言語を付加してジャンプする
     */
    self.site_page_select_action=function(){
        var tmpl_url= UTL_add_getquery_prm(SITE_URL,'lang',LANGUAGE);
        window.open(tmpl_url,"_system");//InAppBrowserで置き換え済み　"_system"でないとsafariで開かない 別ウインドウでもfunction:handleOpenURLがキックされる
    };
   

}
// //クリック遅延回避
$(function() {
   // FastClick.attach(document.body);
  //  FastClick.attach(document.body);//info::必須　これが無いとiosでtapとクリックイベントが2回起こる グリッドデバイスのアイコンで使用 css needsclickで無効？
   // $(document).on('touchmove.noScroll','.over_lay_panel .panel_bg', function(e) {
   //      e.preventDefault();
   //      e.stopPropagation();
   //  });
   //  $(document).on('touchmove.noScroll','.over_lay_panel .panel_base', function(e) {
   //      //todo::PushBtn等のスクロールしないモーダルでバックがスクロールする。e.stopPropagation();を入れると上のダイヤル等canvas要素が入力出来ない
   //     // e.stopPropagation();
   //  });
});

