LANGUAGE_RESOURCES={
    en:{
        translation:{
            alt_lang_change:'In order to switch languages, the application ends once.',//'言語を切り替える為、アプリは一度終了します。',
            
            //編集画面
            edit_hed_title:'Edit',//編集
            edit_switchs_save:'Save',//保存
            edit_setting_tab_setting:'Setting',
            edit_setting_tab_binder:'Binder',
            edit_device_add_hed_title:'Add',
            edit_device_setting_MotorSetting_title:'Motor Setting',

            //デバイス追加タブ
            edit_device_add_type_tab_robot:'Robot',
            edit_device_add_type_tab_input:'Input',
            edit_device_add_type_tab_module:'Other',
            //再生画面
            play_hed_title:'Play',//再生
            play_switchs_edit:'Edit',//編集

            //ペアリング画面
            pair_hed_title:'List',//ペアリング
            pair_hed_BLE_enable:'Enable',//BLE有効
            pair_hed_BLE_disble:'Disable',//BLE無効
            pair_switchs_scan:'Scan',//BLEスキャン
            pair_switchs_clr:'Clear',//BLE全解除
            pair_farm_upd:'Firmware update is possible. LatestVersion:',//ファームウエアーのアップデートが可能です。LatestVersion
            pair_firm_dl_site:'Firmware update',
            //BLEの接続状況ログ表示
            pair_BLELogMsg_comp:'Pairing completed',//ペアリング完了
            pair_BLELogMsg_unpaired:'Unpaired',//ペアリング解除
            pair_BLELogMsg_notfind:'{{device_name}} was disconnected because it can not be found.',//["device_name"]は見つからない為、解除されました
            pair_BLELogMsg_broken:'{{device_name}} has been disconnected.',//["device_name"]の接続が切れました
            pair_BLELogMsg_failed:'{{device_name}} connection failed.',//["device_name"]の接続が失敗しました
            pair_BLELogMsg_reconnect:'Reconnect the {{device_name}} :{{count}}',//["device_name"]の再接続

            //ロボットリスト一覧画面
            list_hed_title:'List',//設定
            list_btn_inport:'Import',//読み込み
            list_btn_new:'New',//新規作成
            list_btn_site_page:'Site',//外部サイト
            list_hed_title_templ:'Template',//テンプレ
            list_btn_templ_load:'Load template',//テンプレの読み込み

            //設定画面
            setting_hed_title:'Setting',//設定
            setting_update_var_t:'Version',//プログラムversion
            setting_update_check:'Check for updates',//UPDATEのチェック
            setting_update_check_res:'There is no update',//更新プログラムはありません
            setting_update_pending_restart:'The update has been installed. please restart the application',//'更新プログラムがインストールされました。適用するにはアプリをリスタート（タスクス画面からスワイプで終了）して下さい',
            setting_switchs_language:'Language',//言語
            setting_switchs_scan:'Display only Motor when scanning',//スキャン時Motorのみ表示
            setting_switchs_motor:'Addition of virtual motor',//仮想Keiganモーターの追加
            setting_switchs_add:'Add',//追加
            setting_switchs_share_mode:'Test function:Enable data sharing on a file basis such as DropBox',//ロボットデータのshare時にdropbox等のファイルベースの共有を可能
            setting_switchs_show_ui_category_Advance:'Show Advanced Module Settings',//仮想デバイスのAdvance向けの設定・バインダーを表示するか
            //確認ダイアログ等
            pair_alert_conf_unpaired:'Do you want to disconnect it?',//ペアリングの解除確認
            pair_alert_conf_allunpair:'Do you want to disconnect all pairing?',//全てのペアリングを解除しますか？
            list_alert_conf_overw:'Do you want to overwrite it?',//ロボットリスト 上書きしますか？
            list_alert_inp_name:'Save Name',//ロボットリスト 保存名入力
            list_alert_conf_load_ovw:'Would you like to load this data? The current data will be deleted',//ロボットリスト「このデータをロードしますか？現在のデータは削除されます
            list_alert_conf_new_ovw:'Do you want to create a new one? The current data will be deleted',//ロボットリスト 新規作成しますか？現在のデータは削除されます
            list_alert_conf_delete:'Are you sure you want to permanently delete it',//ロボットリスト 削除
            list_alert_conf_dataerr:'The data is broken',//ロボットリスト データ取り込みエラー
            list_alert_conf_datavarerr:'Because the data version is different, it will not load. (appvar:{{robo_data_var}} datavar:{{data_var}})',//ロボットリスト データヴァージョンエラー「データのバージョンが違うため、読み込みません」
            list_alert_conf_inpdata:'Are you sure you want to import {{name}}?',//ロボットリスト データインポート
            edit_alert_conf_delete:'Are you sure you want to permanently delete it',//編集画面 仮想デバイス削除
            edit_alert_conf_unbind:'Are you sure you want to un binding it',//編集画面 デバイスバインド解除

            //共通 ダイアログボタン
            com_alert_btn_title_save:'Specify save method',//上書き保存
            com_alert_btn_overw:'Overwrite',//上書き保存
            com_alert_btn_saveas:'Save as',//別名保存
            com_alert_btn_ok:'Ok',//OKボタン
            com_alert_btn_cancel:'Cancel',//キャンセル
            com_close:'Close',

            com_load_err:'Error loading'
        }
    },
    ja:{
        translation:{
            alt_lang_change:'言語を切り替える為、アプリは一度終了します。',
            //編集画面
            edit_hed_title:'編集',//編集
            edit_switchs_save:'保存',//保存
            edit_setting_tab_setting:'設定',
            edit_setting_tab_binder:'バインド',
            edit_device_add_hed_title:'追加',
            edit_device_setting_MotorSetting_title:'モーター初期設定',
            //デバイス追加タブ
            edit_device_add_type_tab_robot:'ロボット',
            edit_device_add_type_tab_input:'インプット',
            edit_device_add_type_tab_module:'その他',

            //再生画面
            play_hed_title:'再生',//再生
            play_switchs_edit:'編集',//編集

            //ペアリング画面
            pair_hed_title:'List',//ペアリング
            pair_hed_BLE_enable:'BLE有効',
            pair_hed_BLE_disble:'BLE無効',
            pair_switchs_scan:'Scan',//BLEスキャン
            pair_switchs_clr:'Clear',//BLE全解除
            pair_farm_upd:'ファームウェアのアップデートが可能です。',
            pair_firm_dl_site:'アップデート',
            //BLEの接続状況ログ表示
            pair_BLELogMsg_comp:'ペアリング完了',//ペアリング完了
            pair_BLELogMsg_unpaired:'ペアリング解除',//ペアリング解除
            pair_BLELogMsg_notfind:'{{device_name}}は見つからない為、解除されました',//["device_name"]は見つからない為、解除されました
            pair_BLELogMsg_broken:'{{device_name}}の接続が切れました',//["device_name"]の接続が切れました
            pair_BLELogMsg_failed:'{{device_name}}の接続が失敗しました',//["device_name"]の接続が失敗しました
            pair_BLELogMsg_reconnect:'{{device_name}}の再接続:{{count}}',//["device_name"]の再接続
            
            //ロボットリスト一覧画面
            list_hed_title:'リスト',
            list_btn_inport:'読み込み',
            list_btn_new:'新規',
            list_btn_site_page:'Site',
            list_hed_title_templ:'テンプレート',//テンプレ
            list_btn_templ_load:'テンプレートの読み込み',//テンプレの読み込み

            //設定画面
            setting_hed_title:'設定',
            setting_update_var_t:'プログラムVer',
            setting_update_check:'UPDATEのチェック',
            setting_update_check_res:'更新プログラムはありません',//
            setting_update_pending_restart:'更新プログラムがインストールされました。適用するにはアプリをリスタート（タスクス画面からスワイプで終了）して下さい',
            setting_switchs_language:'言語',
            setting_switchs_scan:'スキャン時Motorのみ表示',
            setting_switchs_motor:'仮想Keiganモーターの追加',
            setting_switchs_add:'追加',
            setting_switchs_share_mode:'試験機能：DropBox等のファイルベースでのデータ共有を可能にする',//ロボットデータのshare時にdropbox等のファイルベースの共有を可能
            setting_switchs_show_ui_category_Advance:'高度なモジュール設定を表示',//仮想デバイスのAdvance向けの設定・バインダーを表示するか
            //確認ダイアログ等
            pair_alert_conf_unpaired:'解除しますか?',//ペアリングの解除確認
            pair_alert_conf_allunpair:'全てのペアリングを解除しますか？',//全てのペアリングを解除しますか？
            list_alert_conf_overw:'上書きしますか？',//ロボットリスト 上書きしますか？
            list_alert_inp_name:'名前を付けて保存',//ロボットリスト 保存名入力
            list_alert_conf_load_ovw:'このデータをロードしますか？現在のデータは削除されます',//ロボットリスト 上書きロード
            list_alert_conf_new_ovw:'新規作成しますか？現在のデータは削除されます',//ロボットリスト 新規作成しますか？現在のデータは削除されます
            list_alert_conf_delete:'削除してもよろしいですか？',//ロボットリスト 削除
            list_alert_conf_dataerr:'データが壊れています',//ロボットリスト データ取り込みエラー
            list_alert_conf_datavarerr:'データのバージョンが異なる為、読み込みません (appvar:{{robo_data_var}} datavar:{{data_var}})',//ロボットリスト データヴァージョンエラー
            list_alert_conf_inpdata:'{{name}} をリストに読みこみます。よろしいですか?',//ロボットリスト データインポート
            edit_alert_conf_delete:'削除してもよろしいですか？',//編集画面 仮想デバイス削除
            edit_alert_conf_unbind:'バインドを解除します。よろしいですか？',//編集画面 仮想デバイスバインド解除

            //共通 ダイアログボタン
            com_alert_btn_title_save:'保存方法を選んで下さい',//上書き保存
            com_alert_btn_overw:'上書き保存',//上書き保存
            com_alert_btn_saveas:'別名保存',//別名保存
            com_alert_btn_ok:'Ok',//OKボタン
            com_alert_btn_cancel:'Cancel',//キャンセル
            com_close:'閉じる',

            com_load_err:'読み込みエラー'//ロードエラー
        }
    }
};


/************************************************************************************
 *
 * section::ローカライズ処理 http://i18next.com/docs/api/
 *
 ************************************************************************************/
i18next.init(
    {
        fallbackLng: 'en',
        resources: LANGUAGE_RESOURCES
    }
);
// 'translation' はデフォルトのネームスペース。initの引数でデフォルトのネームスペースを変えることもできる
// i18next.addResources('en', 'translation',LANGUAGE_TXT.en);
// i18next.addResources('ja', 'translation',LANGUAGE_TXT.ja);

LANGUAGE=UTL_load_storage('LANGUAGE');
LANGUAGE=LANGUAGE?LANGUAGE:'en';//default英語

i18next.changeLanguage(LANGUAGE);


/**
 * テキスト出力
 * @param msg_tag
 * @param Interpolation 言語により前後する名詞
 */
function WORD(msg_tag,Interpolation){
    return i18next.t(msg_tag,Interpolation);
}
//言語を指定してWORDを取得（言語切り替え時の警告等）
function GLOBAL_WORD(lang,msg_tag){
    return i18next.getFixedT(lang)(msg_tag);
}
