
//ブラウザのキャッシュは効いているのに safariのDEVツールではxhrが溜まる(ディスクが占有される？)為
//desvgにcash機能を実装
(function() {
    "use strict";
    var desvg_xhr_cash={};
    var desvg_cash = function(selector, removeInlineCss,cb) {
        removeInlineCss = removeInlineCss || false;

        var images,
            imagesLength,
            sortImages = {},

            // load svg file
            loadSvg = function (imgURL, replaceImages,cb) {
                // set up the AJAX request
                //info::1度読み込んだファイルはXMLテキストとしてキャッシュして再利用、xhrの重複ロードを防止する(ブラウザキャッシュが効かない為実装)
                if(!desvg_xhr_cash[imgURL]){
                    var xhr = new XMLHttpRequest();
                    xhr.open('GET', imgURL, true);
                    //info::キャッシュは効いているのに、実行の度にtmpデータが毎回累積されている。chrome のツールではsvgはStatus Code:200 OK (from disk cache) になるがmobile safariのDEVツールではxhrが溜まる(ディスクが占有される？)
                    // xhr.setRequestHeader('Cache-Control', 'private');
                    // xhr.setRequestHeader('Cache-Control', 'max-age=3600');
                    // xhr.setRequestHeader('Expires', 'Sat, 25 Feb 2017 20:45:07 GMT');
                    xhr.onload = function() {
                        var xml,
                            xmltxt,
                            svg,
                            paths,
                            replaceImagesLength;

                        // get the response in XML format
                        //xml = xhr.responseXML;
                        xmltxt=xhr.responseText;

                        // bail if no XML
                        if (!xmltxt) {
                            return;
                        }
                        //desvg_xhr_cash[imgURL]=xml.cloneNode(true);
                        desvg_xhr_cash[imgURL]= xmltxt;

                        //parse
                        var parser = new DOMParser();
                        xml = parser.parseFromString(desvg_xhr_cash[imgURL], "text/xml");

                        replaceImagesLength = replaceImages.length;

                        // this will be the <svg />
                        svg = xml.documentElement;

                        // get all the SVG paths
                        paths = svg.querySelectorAll('path');

                        if (removeInlineCss) {
                            // if `removeInlineCss` is true then remove the style attributes from the SVG paths
                            for (var i = 0; i < paths.length; i++) {
                                paths[i].removeAttribute('style');
                            }
                        }
                        svg.removeAttribute('xmlns:a');

                        while(replaceImagesLength--) {
                            replaceImgWithSvg(replaceImages[replaceImagesLength], svg.cloneNode(true));
                        }
                        if(typeof cb ==="function"){
                            cb();
                        }
                    };
                    //console.log("debug");
                    xhr.send();
                }else{
                    //console.time("svg time");
                    setTimeout(function(){
                       // console.timeEnd("svg time");
                        var xml,
                            svg,
                            paths,
                            replaceImagesLength;
                        var parser = new DOMParser();
                        xml = parser.parseFromString(desvg_xhr_cash[imgURL], "text/xml");
                        replaceImagesLength = replaceImages.length;

                        // this will be the <svg />
                        svg = xml.documentElement;

                        // get all the SVG paths
                        paths = svg.querySelectorAll('path');

                        if (removeInlineCss) {
                            for (var i = 0; i < paths.length; i++) {
                                paths[i].removeAttribute('style');
                            }
                        }
                        svg.removeAttribute('xmlns:a');

                        while(replaceImagesLength--) {
                            replaceImgWithSvg(replaceImages[replaceImagesLength], svg.cloneNode(true));
                        }
                        if(typeof cb ==="function"){
                            cb();
                        }
                   },0);
                }
            },

            
            // replace the original <img /> with the new <svg />
            replaceImgWithSvg = function (img, svg) {
                var imgID = img.id,
                    imgClasses = img.getAttribute('class');

                if (imgID) {
                    // re-assign the ID attribute from the <img />
                    svg.id = imgID;
                }

                if (imgClasses) {
                    // re-assign the class attribute from the <img />
                    svg.setAttribute('class', imgClasses + ' replaced-svg');
                }

                img.parentNode.replaceChild(svg, img);
            };



        // grab all the elements from the document matching the passed in selector
        images = document.querySelectorAll(selector);
        imagesLength = images.length;

        // sort images array by image url
        while (imagesLength--) {
            var _img = images[imagesLength],
              _imgURL;

            if (_img.getAttribute('data-src')) {
              _imgURL = _img.getAttribute('data-src')
            } else {
               var xhr_relative_path= _img.getAttribute('xhr_relative_path');
                xhr_relative_path=xhr_relative_path?xhr_relative_path:'';
              _imgURL = xhr_relative_path+_img.getAttribute('src')
            }

            if (sortImages[_imgURL]) {
                sortImages[_imgURL].push(_img);
            } else {
                sortImages[_imgURL] = [_img];
            }
        }

        // loops over the matched urls
        for (var key in sortImages) {
            //todo::相対xhr_relative_pathを付加
            if (sortImages.hasOwnProperty(key)) {
                loadSvg(key, sortImages[key],cb);
            }
        }
    };

    window.deSVG = desvg_cash;
})();

