/**
 * hammerjs tapイベントの親要素へのイベントの伝播を止める
 *
 */
// ko.bindingHandlers.tapBubble = {
//     init: function(element) {
//             ko.utils.registerEventHandler(element, "touch", function(event) {
//                 event.cancelBubble = true;
//                 if (event.originalEvent && event.originalEvent.gesture && event.originalEvent.gesture.stopPropagation) {
//                     // event.originalEvent.gesture.stopPropagation();
//                     event.originalEvent.gesture.preventDefault();//info::hammerjs のイベントキャンセル
//                 }
//     });
//     }
// };
ko.bindingHandlers.tap_hammerjsBubble = {
    init: function(element) {
        ko.utils.registerEventHandler(element, "touch", function(event) {
            event.cancelBubble = true;
            if (event.originalEvent && event.originalEvent.gesture && event.originalEvent.gesture.stopPropagation) {
                //event.originalEvent.gesture.stopPropagation();
                 event.originalEvent.gesture.preventDefault();//info::hammerjs のイベントキャンセル
            }
        });
    }
};

/**
 * wait panel　お待ち下さい
 * @type {{init: init, update: update}}
 */
ko.bindingHandlers.wait_panel = {
    init: function(element, valueAccessor) {
        //var base_dir=UTL_get_dir_path('global/js/bindingHandlers.js','');//プリローダ画像用の絶対パス生成
        //var preloader_img_path=base_dir+'js/preloader.gif';
        var preloader_img_path='js/preloader.gif';
        var value = valueAccessor();
        $(element).hide();
        $(element).append('<div class="waitpanel_block" style="position:absolute;"><div class="waitpanel_msg"><span class="msg"></span><span class="wait_img"><img src="'+preloader_img_path+'" alt=""/></span></div></div>');
    },
    update: function(element, valueAccessor) {
        var val=ko.utils.unwrapObservable(valueAccessor());
        if(val){
            //表示
            var parent_jw=$(element).parent();
            var waitpanel_block_jq=$('.waitpanel_block',$(element));
            var waitpanel_msg_jq=$('.waitpanel_msg',$(element));
            var w=parent_jw.width();
            var h=parent_jw.height();
            waitpanel_block_jq.width(w).height(h);//block position
            waitpanel_msg_jq.css({'top':(waitpanel_block_jq.height()-waitpanel_msg_jq.outerHeight())/2,'left':(waitpanel_block_jq.width()-waitpanel_msg_jq.outerWidth())/2});//msg position
            //$(element).fadeIn();
            $(element).show();
        }else{
            //非表示
            $(element).fadeOut();
        }
    }
};
/**
 * モーダル用 バックへのイベント透過を防止
 * @type {{init: ko.bindingHandlers.bgBlockEvent.init, update: ko.bindingHandlers.bgBlockEvent.update}}
 */
ko.bindingHandlers.ModalEventBlock = {
    init: function(element, valueAccessor) {

        //$(element).hide();
    },
    update: function(element, valueAccessor) {
        var val=ko.utils.unwrapObservable(valueAccessor());
        $(element).off('touchmove.noScroll');
        if(val){
            $(element).on('touchmove.noScroll', function(e) {
                e.preventDefault();
                e.stopPropagation();
            });
        }
    }
};

// ko.bindingHandlers.fastclick = {
//     init: function(element, valueAccessor) {
//         FastClick.attach(element);
//         return ko.bindingHandlers.click.init.apply(this, arguments);
//     }
// };
//------------------------------------------------------//
//              要素のアニメーション フィルター
//------------------------------------------------------//
/**
 * スライドイン・スライドアウト
 */
ko.bindingHandlers.SlideVisible = {
    init: function(element, valueAccessor) {
        var value = valueAccessor();
        $(element).hide();
    },
    update: function(element, valueAccessor) {
        var value =Boolean(ko.utils.unwrapObservable(valueAccessor()));
        value?$(element).animate({width:'show'}): $(element).animate({width:'hide'});
    }
};
/**
 * フェードイン・フェードアウト
 */
ko.bindingHandlers.fadeVisible = {
    init: function(element, valueAccessor) {
        var value = valueAccessor();
        $(element).hide();
    },
    update: function(element, valueAccessor) {
        var value =Boolean(ko.utils.unwrapObservable(valueAccessor()));
        value? $(element).fadeIn('slow') : $(element).fadeOut('fast');
    }
};
/**
 * フェードイン・速消し
 */
ko.bindingHandlers.fadein_hide_Visible = {
    init: function(element, valueAccessor) {
        var value = valueAccessor();
        $(element).toggle(ko.utils.unwrapObservable(value));
    },
    update: function(element, valueAccessor) {
        var value = valueAccessor();
        ko.utils.unwrapObservable(value) ? $(element).fadeIn(0.4) : $(element).hide();
    }
};

/**
 * SVG配置　動的ロード後にVMを再バインド版
 * class :SVGエレメントに付けるデフォルトのクラス
 */
ko.bindingHandlers.imgSVGvm = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
           //console.log("imgsvg init");//todo::debug
            var value_array = ko.utils.unwrapObservable(valueAccessor());

        var filepath=value_array[0];//url
        var xhr_relative_path= (cordova&&cordova.define.moduleMap["cordova-plugin-wkwebview-file-xhr.xhr-polyfill"])?value_array[1]:'';//info::xhrロード時の相対指定用ディレクトリ Cordova MACのみ
        var ucssid=UTL_Unique_uuid('svg');

        //$(element).empty();
       $(element).append(' <img id="'+ucssid+'" src="'+filepath+'" xhr_relative_path="'+xhr_relative_path+'"/>');
        element["now_svg_path"]=filepath;
        deSVG('#'+ucssid, true,function () {
            ko.applyBindingsToDescendants(bindingContext,element);//info::動的ロードしたSVGを再バインド
        });


    },
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        // var value = valueAccessor();
        // var elem_class =allBindings.get('class');
        //     elem_class=elem_class?elem_class:"";
        //  console.log("value imgSVGvm:"+value);//todo::debug
        // // return ;
        // if(element["now_svg_path"]!=value){//新規SVG生成
        //     var ucss=UTL_Unique_uuid('svg');
        //     $(element).empty();
        //     $(element).append(' <img class="'+ucss+' '+elem_class+'" src="'+value+'"/>');
        //     element["now_svg_path"]=value;
        //     deSVG('.'+ucss, true,function () {
        //         ko.applyBindingsToDescendants(bindingContext,element);//info::動的ロードしたSVGを再バインド
        //     });
        // }
    }
};
/**
 * SVG配置　JQ版 バインド無し
 * class :SVGエレメントに付けるデフォルトのクラス
 * svg_class :グラフィック内に指定するクラス　{svgID名:付加するclass複数,svgID名:付加するclass複数}
 */
ko.bindingHandlers.imgSVG = {
    init: function(element, valueAccessor, allBindings) {
        var value = ko.utils.unwrapObservable(valueAccessor());

    },
    update: function(element, valueAccessor, allBindings) {
        var value = valueAccessor();
        var elem_class =allBindings.get('class');
        elem_class=elem_class?elem_class:"";
        var svg_class=allBindings.get('svg_class');//{svgID名:付加するclass複数,svgID名:付加するclass複数}
        var svg_attr=allBindings.get('svg_attr');//{svgID名:{付加する属性:値,付加する属性:値・・},svgID名:{付加する属性:値}}

        if(element["now_svg_path"]!=value){//新規SVG生成
            var ucss=UTL_Unique_uuid('svg');
            $(element).empty();
            $(element).append(' <img class="'+ucss+' '+elem_class+'" src="'+value+'"/>');
            element["now_svg_path"]=value;
            deSVG('.'+ucss, true,function () {
                _class_rem(svg_class);
                _attr_rem(svg_attr);
            });
        }else{
            if(svg_class){
                _class_rem(svg_class);
            }
            if(svg_attr){
                _attr_rem(svg_attr);
            }
        }
        ///グラフィック部分cssの付加
        function _class_rem(_svg_class){
            var k=Object.keys(_svg_class);
            for(var i=0;i<k.length;i++){
                $(element).find('#'+k[i]).each(function(){
                    $(this).attr('class', _svg_class[k[i]]);
                });
            }
        }
        ///属性の付加
        function _attr_rem(_svg_attr){
            var k=Object.keys(_svg_attr);
            for(var i=0;i<k.length;i++){
                $(element).find('#'+k[i]).each(function(){
                    var attobj=_svg_attr[k[i]];
                    var kk=Object.keys(attobj);
                    for(var ii=0;ii<kk.length;ii++){
                        $(this).attr(kk[ii],attobj[kk[ii]]);
                    }
                });
            }
        }
    }
};

/**
 * トグルスイッチ
 * @type {{init: ko.bindingHandlers.toggleSW.init, update: ko.bindingHandlers.toggleSW.update}}
 */
ko.bindingHandlers.toggleSW = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var value = valueAccessor();
        var jq_bool=$('<input type="checkbox" data-toggle="toggle" />');//info::[bootstraptoggle]
        jq_bool.change(function(){
            var val=$(this).prop('checked');
            if(value()!==val){
                value(val);
            }
        });
        $(element).append(jq_bool);
    },
    update: function(element, valueAccessor) {
        var rvalue = ko.utils.unwrapObservable(valueAccessor());
       var jq_bool= $(element).find('input');
        jq_bool.bootstrapToggle(rvalue?'on':'off');
        // if(rvalue!==jq_bool.bootstrapToggle().prop('checked')){
        //     jq_bool.bootstrapToggle(rvalue?'on':'off');
        // }
    }
}
//------------------------------------------------------//
//    デバイスの編集可能プロパティのバインド
//------------------------------------------------------//
/**
 * デバイスの編集可能プロパティのバインド
 * info::input typeを使用モバイルのみ、IEは非対応
 * 初期化時のみ設定可能（上書きで変更は出来ない）
 * @type {{init: ko.bindingHandlers.PublishUIPropEditor.init, update: ko.bindingHandlers.PublishUIPropEditor.update}}
 */
ko.bindingHandlers.PublishUIPropEditor = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var value = valueAccessor();
        var target_device=allBindings.get('target_device');
        if(!value||!target_device){return;}
        var def_val=target_device[value.name];
        var STRUCT_READ_IntervalID=0;
        var is_send_tggl_b=false;//連続送信検出
        var publishUIPropDelegateMethods=value.publishUIPropDelegateMethods;//info::Deviceモジュール側からプロパティUIを操作する為に呼び出される。
        //型別のUI生成
        switch (value.type){
            case PublishUIProp_TYPE.INT://数値の場合
            case PublishUIProp_TYPE.FLOAT:
                var jq_num=null;
                if(value.type===PublishUIProp_TYPE.INT){
                    jq_num=$('<input type="number" class="input_num form-control" pattern="[0-9+-]*" inputmode="numeric" '+(value.lowlim!=null?'min="'+value.lowlim+'"':'')+' '+(value.maxlim!=null?'max="'+value.maxlim+'"':'')+' '+(value.step!=null?'step="'+value.step+'"':'')+' />');
                }else{
                   jq_num=$('<input type="number" class="input_num form-control" pattern="[0-9.+-]*" '+(value.lowlim!=null?'min="'+value.lowlim+'"':'')+' '+(value.maxlim!=null?'max="'+value.maxlim+'"':'')+' '+(value.step!=null?'step="'+value.step+'"':'')+' />');
                }
                //入力値->プロパティとのバインド
                jq_num.change(function(){
                    var v=$(this).val();
                    var enterval=$(this).data("enterval");
                    $(this).data("enterval",null);
                    if(enterval===v){return;}//EnterKey送信>changeでの二重送信防止

                    target_device[value.name]=UTL_N(v);
                    if(jq_range){
                        jq_range.val(UTL_N(v));
                    }
                });

                //inputフィールド　enterキーでの値確定
                jq_num.keypress( function ( e ) {
                    if ( e.keyCode == 13 ) {
                        var v=$(this).val();
                        $(this).data("enterval",v);//EnterKey送信>changeでの二重送信防止
                        target_device[value.name]=UTL_N(v);
                        if(jq_range){
                            jq_range.val(UTL_N(v));
                        }
                    }
                } );

                jq_num.val(def_val); //プロパティ->UI入力値への反映（初回のみ）
                $(element).append(jq_num);
                var jq_range;
                //setpがある場合は、スライドを追加作成
                if(value.step!=null){
                    jq_range=$('<input type="range" class="input_range form-control" '+(value.lowlim!=null?'min="'+value.lowlim+'"':'')+' '+(value.maxlim!=null?'max="'+value.maxlim+'"':'')+' '+(value.step!=null?'step="'+value.step+'"':'')+'/>');
                    //入力値->プロパティとのバインド
                    jq_range.change(function(){
                        var val=UTL_N($(this).val());
                        target_device[value.name]=val;
                        jq_num.val(val);
                    });
                    jq_range.val(def_val); //プロパティ->UI入力値への反映（初回のみ）
                    $(element).append(jq_range);
                }

                //info::Deviceモジュール側からのデータリフレッシュ表示呼び出し用
                publishUIPropDelegateMethods.refresh=function () {
                    var def_val=target_device[value.name];
                    jq_num.val(def_val);
                    if(jq_range){
                        jq_range.val(def_val);
                    }
                };

                break;
            //////////////
            case PublishUIProp_TYPE.BOOL://BOOL値の場合
                var jq_bool=$('<input type="checkbox" data-toggle="toggle" />');//info::[bootstraptoggle] http://www.bootstraptoggle.com/
                //入力値->プロパティとのバインド
                jq_bool.change(function(){
                    var val=$(this).prop('checked');
                    target_device[value.name]=val;
                });
                // jq_bool.prop('checked',def_val);
                $(element).append(jq_bool);
                jq_bool.bootstrapToggle(def_val?'on':'off');//appendしてからでないと初期化出来ない　//プロパティ->UI入力値への反映（初回のみ）
                break;
            /////////////

            case PublishUIProp_TYPE.ENUM://列挙体プルダウン
                //MOTOR_LED_STATEの選択肢作成 value.stepが列挙体になる
                if(!value.step){return;}
                var jq_enum=$('<select class="enum input_pll form-control"/>');
                $.each(value.step, function (name,value) {
                    var jq_option = $('<option>').val(value).text(name);
                    jq_enum.append(jq_option);
                });
                jq_enum.change(function(){
                    var val=UTL_N($(this).val());
                    target_device[value.name]=val;
                });

                $(element).append(jq_enum);
                jq_enum.val(def_val); //プロパティ->UI入力値への反映（初回のみ）

                //info::Deviceモジュール側からのデータリフレッシュ表示呼び出し用
                publishUIPropDelegateMethods.refresh=function () {
                    var def_val=target_device[value.name];
                    jq_enum.val(def_val);
                };

                break;
            //////////////
            case PublishUIProp_TYPE.SEND_NULL://メソッドの呼び出しのみの用途
                var jq_send_btn=$('<button class="btn btn-default send_btn" type="submit">SEND</button>');
                jq_send_btn.click(function(){
                    target_device[value.name]=null;
                });
                $(element).append(jq_send_btn);

                break;
            //////////////
            case PublishUIProp_TYPE.SEND_VAL://数値＋送信ボタン　メソッドの呼び出しのみの用途
                var jq_send_val=$('<div class="input-group send_val"><input type="number" class="form-control send_val_input" pattern="\\d*" __inputmode="numeric" ><span class="input-group-btn"><button type="button" class="btn btn-default send_val_btn">SEND</button></span></div>');
                var jq_send_val_input=jq_send_val.find('.send_val_input');
                var jq_send_val_btn=jq_send_val.find('.send_val_btn');
                jq_send_val_btn.click(function(){
                    target_device[value.name]=UTL_N(jq_send_val_input.val());
                });
                $(element).append(jq_send_val);
                jq_send_val_input.val(def_val); //プロパティ->UI入力値への反映（初回のみ）
                break;
            //////////////
            case PublishUIProp_TYPE.CONFIRM://確認ダイアログボタン
                var jq_send_btn=$('<button class="btn btn-default send_btn" type="submit">SEND</button>');
                jq_send_btn.click(function(){
                    navigator.notification.confirm(value.confirm_msg,
                        function(id){
                            if(id==1){
                                target_device[value.name]=null;
                            }
                        },"",[WORD('com_alert_btn_ok'),WORD('com_alert_btn_cancel')]
                    );
                });
                $(element).append(jq_send_btn);

                break;
            //////////////

            // case PublishUIProp_TYPE.RADIAN://radian角
            //     break;
            case PublishUIProp_TYPE.STRUCT_READ://構造体の表示のみ {position:float,speed:float,torque:float}(Keigan_Motor.GetRotationState用)
               // var jq_struct_read=$('<input type="text" class="struct_read"/>');
                var jq_struct_read=$('<div class="struct_read"/>');
                $(element).append(jq_struct_read);
                //100ms毎の値の監視
                STRUCT_READ_IntervalID=setInterval(function(){
                    var d=target_device[value.name];
                    //UTL_LOG("STRUCT_READ_Interval:"+STRUCT_READ_IntervalID);
                    // if(d){jq_struct_read.text('position:'+d.position+' speed:'+d.speed+' torque:'+d.torque);}
                    var v_str="";
                    if(d instanceof Object){
                        if(d.GetValObj){
                            v_str=JSON.stringify(d.GetValObj());
                        }else{
                            v_str=JSON.stringify(d);
                        }
                    }else{ v_str=d;}

                    jq_struct_read.text(v_str);

                    if(!$(element).is(':visible')){
                        clearInterval(STRUCT_READ_IntervalID);
                    }
                },200);
                
                break;
            //////////////
            case PublishUIProp_TYPE.KM_POSARRAY://SetPosition用引数の配列 Array[targetPosition radians,speed rad/sec,duration Xsec]
            case PublishUIProp_TYPE.KM_POSARRAY_DEG:
                var is_deg=value.type==PublishUIProp_TYPE.KM_POSARRAY_DEG;//型がKM_POSARRAY_DEGの場合（表記の切り替えで使用）

                var tmpl_posarray=
                    '<div class="km_posarray">'+
                    '<div class="input-group"><span class="title input-group-addon">position('+(is_deg?'deg':'radian')+')</span>'+
                    '<input type="number" class="input_num pos form-control" pattern="[0-9.+-]*" __inputmode="numeric" '+(value.lowlim[0]!=null?'min="'+value.lowlim[0]+'"':'')+' '+(value.maxlim[0]!=null?'max="'+value.maxlim[0]+'"':'')+' '+(value.step[0]!=null?'step="'+value.step[0]+'"':'')+' /></div>' +
                    '<input type="range" class="input_range pos form-control" '+(value.lowlim[0]!=null?'min="'+value.lowlim[0]+'"':'')+' '+(value.maxlim[0]!=null?'max="'+value.maxlim[0]+'"':'')+' '+(value.step[0]!=null?'step="'+value.step[0]+'"':'')+' />' +
                    '<div class="input-group"><span class="title input-group-addon">speed('+(is_deg?'rpm':'rad/sec')+')</span>'+
                    '<input type="number" class="input_num speed form-control" pattern="[0-9.+-]*" '+(value.lowlim[1]!=null?'min="'+value.lowlim[1]+'"':'')+' '+(value.maxlim[1]!=null?'max="'+value.maxlim[1]+'"':'')+' '+(value.step[1]!=null?'step="'+value.step[1]+'"':'')+' /></div>' +
                    '<input type="range" class="input_range speed form-control" '+(value.lowlim[1]!=null?'min="'+value.lowlim[1]+'"':'')+' '+(value.maxlim[1]!=null?'max="'+value.maxlim[1]+'"':'')+' '+(value.step[1]!=null?'step="'+value.step[1]+'"':'')+' />'+
                    '<div  style="display: none" class="input-group"><span class="title input-group-addon">duration(Xsec)</span>'+ //info::duration引数が無効な為非表示
                    '<input type="number" class="input_num duration form-control" pattern="\\d*" __inputmode="numeric" '+(value.lowlim[2]!=null?'min="'+value.lowlim[2]+'"':'')+' '+(value.maxlim[2]!=null?'max="'+value.maxlim[2]+'"':'')+' '+(value.step[2]!=null?'step="'+value.step[2]+'"':'')+' /></div>' +
                    '<input type="range" style="display: none" class="input_range duration form-control" '+(value.lowlim[2]!=null?'min="'+value.lowlim[2]+'"':'')+' '+(value.maxlim[2]!=null?'max="'+value.maxlim[2]+'"':'')+' '+(value.step[2]!=null?'step="'+value.step[2]+'"':'')+' />'+
                    '</div>';

                var jq_posarray=$(tmpl_posarray);
                var jq_range_pos=jq_posarray.find('.input_range.pos');
                var jq_range_speed=jq_posarray.find('.input_range.speed');
                var jq_range_duration=jq_posarray.find('.input_range.duration');
                var jq_num_pos=jq_posarray.find('.input_num.pos');
                var jq_num_speed=jq_posarray.find('.input_num.speed');
                var jq_num_duration=jq_posarray.find('.input_num.duration');

                //値の送信
                var _posarray_val_send=function(){
                    var _pos=UTL_N(jq_num_pos.val());
                    var _speed=UTL_N(jq_num_speed.val());
                    var _duration=UTL_N(jq_num_duration.val());
                    console.log("_posarray_val_send ",_pos,_speed,_duration);
                    target_device[value.name]=[_pos,_speed,_duration];
                };

                //テキストBOX スライダーとの値バインド
                jq_range_pos.change(function(){jq_num_pos.val($(this).val());_posarray_val_send();});
                jq_range_speed.change(function(){jq_num_speed.val($(this).val());_posarray_val_send();});
                jq_range_duration.change(function(){jq_num_duration.val($(this).val());_posarray_val_send();});

                jq_num_pos.change(function(e){
                    var uiv=$(this).val();
                    var enterval=$(this).data("enterval");
                    $(this).data("enterval",null);
                    if(enterval===uiv){return;}//EnterKey送信>changeでの二重送信防止
                    jq_range_pos.val(uiv);_posarray_val_send();
                });
                jq_num_speed.change(function(){
                    var uiv=$(this).val();
                    var enterval=$(this).data("enterval");
                    $(this).data("enterval",null);
                    if(enterval===uiv){return;}
                    jq_range_speed.val(uiv);_posarray_val_send();
                });
                jq_num_duration.change(function(){
                    var uiv=$(this).val();
                    var enterval=$(this).data("enterval");
                    $(this).data("enterval",null);
                    if(enterval===uiv){return;}
                    jq_range_duration.val(uiv);_posarray_val_send();
                });
                //EnterKey送信対応
                jq_num_pos.keypress(function(e){
                    if(e.keyCode==13){
                        var uiv=$(this).val();
                        $(this).data("enterval",uiv);//EnterKey送信>changeでの二重送信防止
                        jq_range_pos.val(uiv);
                        _posarray_val_send();
                    }}
                );
                jq_num_speed.keypress(function(e){
                    if(e.keyCode==13){
                        var uiv=$(this).val();
                        $(this).data("enterval",uiv);
                        jq_range_speed.val(uiv);
                        _posarray_val_send();
                    }}
                );
                jq_num_duration.keypress(function(e){
                    if(e.keyCode==13){
                        var uiv=$(this).val();
                        $(this).data("enterval",uiv);
                        jq_range_duration.val(uiv);
                        _posarray_val_send();
                    }}
                );


                $(element).append(jq_posarray);
                break;
            //////////////
            case PublishUIProp_TYPE.KM_LEDARRAY://LEDの点灯状態・モーターのLED色 ST_MTLedState[MOTOR_LED_STATE,R,G,B 0-255]
                var tmpl_ledarray='<div class="km_ledarray">' +
                    '<div class="input-group"><span class="title input-group-addon">state</span><select class="input_pll state form-control"/></div>' +
                    '<div class="input-group"><span class="title input-group-addon">R:<span class="val_cr"></span></span><input type="range" class="input_range cr form-control" min="0" max="255" step="1"/></div>' +
                    '<div class="input-group"><span class="title input-group-addon">G:<span class="val_cg"></span></span><input type="range" class="input_range cg form-control" min="0" max="255" step="1"/></div>' +
                    '<div class="input-group"><span class="title input-group-addon">B:<span class="val_cb"></span></span><input type="range" class="input_range cb form-control" min="0" max="255" step="1"/></div>' +
                    '</div>';

                var jq_ledarray=$(tmpl_ledarray);
                var jq_state=jq_ledarray.find('.input_pll.state');
                var jq_cr=jq_ledarray.find('.input_range.cr');
                var jq_cg=jq_ledarray.find('.input_range.cg');
                var jq_cb=jq_ledarray.find('.input_range.cb');
                var jq_val_cr=jq_ledarray.find('.val_cr');
                var jq_val_cg=jq_ledarray.find('.val_cg');
                var jq_val_cb=jq_ledarray.find('.val_cb');
                //MOTOR_LED_STATEの選択肢作成
                //$.each(target_device.MOTOR_LED_STATE, function (name,value) {
                $.each(ST_MTLedState.MOTOR_LED_STATE, function (name,value) {
                    var jq_option = $('<option>').val(value).text(name);
                    jq_state.append(jq_option);
                });


                //入力値->プロパティとのバインド
                var _change_lis=function (){
                    var _state=UTL_N(jq_state.val());
                    var _cr=UTL_N(jq_cr.val());
                    var _cg=UTL_N(jq_cg.val());
                    var _cb=UTL_N(jq_cb.val());
                    jq_val_cr.text(_cr);
                    jq_val_cg.text(_cg);
                    jq_val_cb.text(_cb);
                    target_device[value.name]=new ST_MTLedState(_state,_cr,_cg,_cb);
                };

                jq_ledarray.find('.input_pll').change(_change_lis);

                jq_ledarray.find('.input_range').change(_change_lis);

                //プロパティ->UI入力値への反映（初回のみ）
                if(def_val instanceof ST_MTLedState){
                    var ledarray=def_val.GetValArray();
                    jq_state.val(ledarray[0]);
                    jq_cr.val(ledarray[1]);
                    jq_cg.val(ledarray[2]);
                    jq_cb.val(ledarray[3]);
                }
                $(element).append(jq_ledarray);

                break;
            //////////////
            case PublishUIProp_TYPE.STRING://テキスト
                var jq_str=$('<input type="text" class="input_text form-control" />');
                //入力値->プロパティとのバインド
                jq_str.change(function(){
                    target_device[value.name]=$(this).val();
                });
                jq_str.val(def_val); //プロパティ->UI入力値への反映（初回のみ）
                $(element).append(jq_str);
                break;
            /////////////
            default:
                UTL_LOG("エラー:定義無し");
        };


    },
    update: function(element, valueAccessor) {
        //var value = valueAccessor();
    }
};

/**
 * デバイス設定 コントロール表示(入力コントローラーのみ
 * @type {{init: ko.bindingHandlers.DeviceUI.init, update: ko.bindingHandlers.DeviceUI.update}}
 */
ko.bindingHandlers.DeviceUI = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
       //var value = valueAccessor();
        // if(!value){return;}
        // //UIの生成　AbstractDeviceListUIDelegateList.js
        // AbstractDeviceListUIDelegateList.CreateUI(value,element);

    },
    update: function(element, valueAccessor) {
        var value = valueAccessor();
        $(element).empty();
        if(!value){return;}
        //UIの生成　AbstractDeviceListUIDelegateList.js
        AbstractDeviceListUIDelegateList.CreateUI(value,element);
    }
};


ko.bindingHandlers.touch = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var manager = new Hammer.Manager(element);
        var value = valueAccessor();
        var handlerFunction=typeof(value) ==='function'?value:null; //イベントcallback
        manager.on('hammer.input', function(e) {
                if(handlerFunction){
                    var res = handlerFunction.apply(viewModel,[bindingContext['$data'], arguments[0],element]);
                }
            return false;
        })
    },
    update: function(element, valueAccessor) {

    }
}

ko.bindingHandlers.tap = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var manager = new Hammer.Manager(element);
        var ev = new Hammer.Tap({taps: 1,time: HAMMER_TAP_MAX_TIME});
        manager.add(ev);
        var value = valueAccessor();

        var handlerFunction=typeof(value) ==='function'?value:null; //イベントcallback
        manager.on('tap', function(e) {
            if(handlerFunction){
                var res = handlerFunction.apply(viewModel,[bindingContext['$data'], arguments[0],element]);
            }
            return false;
        });
    },
    update: function(element, valueAccessor) {

    }
};

ko.bindingHandlers.doubletap = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var manager = new Hammer.Manager(element);
        var ev = new Hammer.Tap({event:'doubletap',taps: 2,interval:HAMMER_DOUBLETAP_INT_TIME,posThreshold:20});
        manager.add(ev);
        var value = valueAccessor();
        var handlerFunction=typeof(value) ==='function'?value:null; //イベントcallback

        manager.on('doubletap', function(e) {
            if(handlerFunction){
                var res = handlerFunction.apply(viewModel,[bindingContext['$data'], arguments[0],element]);
            }
        });
    },
    update: function(element, valueAccessor) {
    }
};

ko.bindingHandlers.hold = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var manager = new Hammer.Manager(element);
        var ev = new Hammer.Press({event:'hold',time: HAMMER_HOLD_TIME});
        manager.add(ev);
        var value = valueAccessor();
        var handlerFunction=typeof(value) ==='function'?value:null; //イベントcallback

        manager.on('hold', function(e) {
            if(handlerFunction){
                var res = handlerFunction.apply(viewModel,[bindingContext['$data'], arguments[0],element]);
            }
        });
    },
    update: function(element, valueAccessor) {

    }
};
ko.bindingHandlers.holdup = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var manager = new Hammer.Manager(element);
        var ev = new Hammer.Press({time: HAMMER_HOLD_TIME});
        manager.add(ev);
        var value = valueAccessor();
        var handlerFunction=typeof(value) ==='function'?value:null; //イベントcallback

        var pressed = false;
        manager.on('press', function(e) {
            pressed = true;
            //$(element).addClass('holdup');//tapoutで表示が残る
        });
        manager.on('pressup', function(e) {
           // $(element).removeClass('holdup');
            if(pressed){
                pressed = false;
                var res = handlerFunction.apply(viewModel,[bindingContext['$data'], arguments[0],element]);
            }
        });
    },
    update: function(element, valueAccessor) {

    }
};
ko.bindingHandlers.drag = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var manager = new Hammer.Manager(element);
        var ev = new Hammer.Pan({direction: Hammer.DIRECTION_ALL, threshold: 0});
        manager.add(ev);
        var value = valueAccessor();

        var handlerFunction=typeof(value) ==='function'?value:null; //イベントcallback
        manager.on('pan', function(e) {
            if(handlerFunction){
                var res = handlerFunction.apply(viewModel,[bindingContext['$data'], arguments[0],element]);
            }
            return false;
        });
    },
    update: function(element, valueAccessor) {
    }
};
ko.bindingHandlers.dragstart = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var manager = new Hammer.Manager(element);
        var ev = new Hammer.Pan({direction: Hammer.DIRECTION_ALL, threshold: 0});
        manager.add(ev);
        var value = valueAccessor();

        var handlerFunction=typeof(value) ==='function'?value:null; //イベントcallback
        manager.on('panstart', function(e) {
            if(handlerFunction){
                var res = handlerFunction.apply(viewModel,[bindingContext['$data'], arguments[0],element]);
            }
            return false;
        });
    },
    update: function(element, valueAccessor) {
    }
};
ko.bindingHandlers.dragend = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
        var manager = new Hammer.Manager(element);
        var ev = new Hammer.Pan({direction: Hammer.DIRECTION_ALL, threshold: 0 });
        manager.add(ev);
        var value = valueAccessor();

        var handlerFunction=typeof(value) ==='function'?value:null; //イベントcallback
        manager.on('panend', function(e) {
            if(handlerFunction){
                var res = handlerFunction.apply(viewModel,[bindingContext['$data'], arguments[0],element]);
            }
            return false;
        });
    },
    update: function(element, valueAccessor) {
    }
};