
/**
 * 数値にキャストする関数 (A)　配列内のstrを数値に変換し再格納（破壊関数）
 * UTL_arr_cast_num(&ref_ar)　
 * ref_arは参照で元の配列が変更される
 */
function UTL_arr_cast_num(ref_ar){
    var res = new Array();
    for (var t = 0; t < ref_ar.length; ++t) {
        var val = ref_ar[t];
        ref_ar[t] = parseInt(ref_ar[t], 10);
    }
}

/**
 * 両方の配列で重複している値を配列で返す
 * @param ar_a
 * @param ar_b
 * @returns {Array.<T>|*|{TAG, CLASS, ATTR, CHILD, PSEUDO}}
 * @constructor
 */
function UTL_overlap(ar_a,ar_b){
    if(!(ar_a instanceof Array && ar_b instanceof Array)){return;}
    return ar_a.filter( function(n){ return -1 != ar_b.indexOf( n ) } )
}

/**
 * カンマ区切りの数値をIntに変換（nun undefinded等は0に）
 * @param str
 * @constructor
 */
function UTL_StrSplitComma_To_IntArray(str){
   var r= String(str).split(",");
    for(var i=0;i<r.length;i++){
        r[i]=UTL_INT(r[i]);
    }
    return r;
}
/**
 * カンマ区切りの数値をNumberに変換（nun undefinded等は0に）
 * @param str
 * @constructor
 */
function UTL_StrSplitComma_To_NumArray(str){
    var r= String(str).split(",");
    for(var i=0;i<r.length;i++){
        r[i]=UTL_N(r[i]);
    }
    return r;
}

/**
 * 数値にキャストする関数 (B)　
 * str・空欄・Nullを含む数値以外の文字列はconvert_strで指定した値に変換
 * nan_convert(ソースstring:string,空欄・Nullの場合に返す値:string又はNumber)
 * 
 */
function UTL_nan_convert(str, convert_str){
    if (convert_str === undefined) {
        //convert_strが省略された場合はデフォルトで0を代入する
        convert_str = 0;
    }

    var ch=parseFloat(str,10);
    //var ch=parseInt(str,10);
    var a = (isNaN(ch) ? convert_str : ch);
    return a;
};
/**
 * 数値にキャストする関数 (C)　
 * 数値以外は0を返す
 * Infinityも0とする
 */
function UTL_N(val){
    var v=parseFloat(val,10);
    return(isNaN(v)||val===Infinity?0:v);
}
/**
 * 数値にキャストする関数
 * 全てを整数に変換（小数は切り捨て）
 * 数値以外は0を返す
 * Infinityも0とする
 */
function UTL_INT(val){
    var v=parseFloat(val,10);
    return(isNaN(v)||val===Infinity?0:Math.floor(v));
}
/**
 *
 * @param tar_filename //自分が置かれているファイルの名前
 * @param tar_dir_path //マスクする上位ディレクトリ階層数の相対記述　ex) UTL_get_dir_path('my.js','../../')
 * @returns {*}
 * @constructor
 *
 * (C) qiita.com/richmikan@github/items/f6546c1cb913c78a6338
 */
function UTL_get_dir_path(tar_filename,tar_dir_path) {
    var i, s, le;
    var sUrl = null;
    le = document.getElementsByTagName('script');
    for (i=0; i<le.length; i++) {
        s = le[i].getAttribute('src');
        if (s.length < tar_filename.length) {continue;}
        if (s.substr(s.length-tar_filename.length) !== tar_filename) {continue;}
        s = s.substr(0,s.length-tar_filename.length);
        if ((s.length>0) && s.match(/[^\/]$/)) {continue;}
        sUrl = s + tar_dir_path;
        sUrl = (sUrl.match(/\/$/)) ? sUrl : sUrl+'/';
        break;
    }
    if (i >= le.length) {
        return null;
    }

    if (sUrl.match(/^http/i)) {
    }
    else if (sUrl.match(/^\//)   ) {
        if (! location.href.match(/^(https?:\/\/[a-z0-9.-]+)/i)) {return null;}
        sUrl = RegExp.$1 + sUrl;
    }
    else                           {
        sUrl = location.href.replace(/\/[^\/]*$/, '/') + sUrl;
    }

    while (sUrl.match(/\/\.\//)) {
        sUrl = sUrl.replace(/\/\.\//g, '/');
    }

    sUrl.match(/^(https?:\/\/[A-Za-z0-9.-]+)(\/.*)$/);
    s    = RegExp.$1;
    sUrl = RegExp.$2;
    while (sUrl.match(/\/\.\.\//)) {
        while (sUrl.match(/^\/\.\.\//)) {
            sUrl = sUrl.replace(/^\/\.\.\//, '/');
        }
        sUrl = sUrl.replace(/^\/\.\.$/, '/');
        while (sUrl.match(/\/[^\/]+\/\.\.\//)) {
            sUrl = sUrl.replace(/\/[^\/]+\/\.\.\//, '/');
        }
    }
    sUrl = s + sUrl;

    return sUrl;
}
/**
 * URLを補完する httpの付加　スペースのみのnull化
 * @param url_str
 * @constructor
 */
function UTL_url_supplement(url_str){
    if(!url_str||url_str==""){
        return "";
    }
    if(url_str.indexOf("http://") == -1&&url_str.indexOf("https://") == -1){
        url_str ="http://"+url_str;
    }
    return url_str;
}

/**
 * 現在のページのURLのGETクエリ解析
 * @returns {{}}
 * @constructor
 *
 * (C) qiita.com/Evolutor_web/items/c9b940f752883676b35d
 */
function UTL_nowpage_getquery_parse(){
    var vars = {};
    var param = location.search.substring(1).split('&');
    for(var i = 0; i < param.length; i++) {
        var keySearch = param[i].search(/=/);
        var key = '';
        if(keySearch != -1) key = param[i].slice(0, keySearch);
        var val = param[i].slice(param[i].indexOf('=', 0) + 1);
        if(key != '') vars[key] = decodeURI(val);
    }
    return vars;
}

/**
 * URLパラメータをOBJで返す
 * @returns {{}}
 * @constructor
 */
function UTL_get_prm_obj(){
    var obj = {};
    //引数のクロスサイトスクリプティング検知
    var ch=location.href.toLowerCase();
    if(ch.indexOf('javascript')!=-1||ch.indexOf('expression')!=-1||ch.indexOf('eval')!=-1){
        alert('err');
        return obj;
    }
    var pm = location.href.split("?")[1];
    if (!pm) {
        return obj;
    };
    //pm = utf.URLdecode(pm);//URLデコード
    var ss = pm.split("&");
    for (i = 0; i < ss.length; i++) {
        it = ss[i].split("=");
        obj[it[0]] = it[1];
    }
    return obj;
}
/**
 * URLに指定したGetパラメータを付加する　簡易 
 * @param urlstr
 * @param key
 * @param val
 * @returns {string}
 * @constructor
 */

function UTL_add_getquery_prm(urlstr,key,val){
    var pfx=(urlstr.indexOf("?") == -1?'?':'&');
    var prm=key+'='+val;
    var r=urlstr+pfx+prm;
    return r;
}

/**
 * デバイス管理用のUUID生成
 * @returns {string}
 * @private
 */
function UTL_DeviceInner_uuid(){
    var strong = 1000;
    return "DEV"+(new Date().getTime().toString(16)  + Math.floor(strong*Math.random()).toString(16));
}
/**
 * 汎用のUUID生成
 * @returns {string}
 * @constructor
 */
function UTL_Unique_uuid(pfix){
    pfix=pfix?pfix:"";
    var strong = 1000;
    return pfix+(new Date().getTime().toString(16)  + Math.floor(strong*Math.random()).toString(16));
}

/**
 * 現在の時刻をdatetime書式(["YYYY-MM-DD 00:00:00"])で取得
 * @param date_option 日付けを指定の時刻にする場合のdate引数
 * @constructor
 */
function UTL_NowDateTime(date_option){
    var date = date_option?new Date(date_option):new Date();
    return date.getFullYear() + '-' + (('0' + (date.getMonth() + 1)).slice(-2)) + '-' + (('0' + date.getDate()).slice(-2))+' '+ (('0' + date.getHours()).slice(-2))+':'+(('0' + date.getMinutes()).slice(-2));
};
/**
 * 画像の実際のサイズを取得する image:imgタグ要素
 * @param img_obj
 * @returns {{width: *, height: (*|Number|number|string|CSSStyleDeclaration.height)}}
 * @constructor
 */
function UTL_get_img_size(img_obj){
    if(img_obj.get){
        var size_img=img_obj.get(0);
        return{width:size_img.width,height:size_img.height};
    }else{
        return{width:img_obj.width,height:img_obj.height};
    }

};
/***
 * データのファイルシステムへの保存
 * info::ios Androidのみ
 * @param file_name
 * @param obj
 * @returns {boolean}
 * @constructor
 */
function UTL_save_filesys(file_name,obj,cb){
    window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, function (fs) {
        var storage_json_str="";
        try{
            storage_json_str = JSON.stringify(obj);
        }catch(e){
            storage_json_str="";
            if(typeof cb === 'function'){
                cb(false,{});
            }
        }
        //FILE_DIR+'/'+file_name+".txt"
        fs.root.getFile(file_name+".txt", { create: true, exclusive: false }, function (fileEntry) {
            // console.log("fileEntry is file?" + fileEntry.isFile.toString());
            //ファイルの書き込み
            fileEntry.createWriter(function (fileWriter) {
                fileWriter.onwriteend = function() {
                    UTL_LOG("UTL_save_filesys Successful file write: "+fileEntry.name);
                    if(typeof cb === 'function'){
                        cb(true,{});
                    }
                };
                fileWriter.onerror = function (e) {
                    UTL_LOG("UTL_save_filesys Failed file write: " + e.toString());
                    if(typeof cb === 'function'){
                        cb(false,e);
                    }
                };
                fileWriter.write(storage_json_str);
            });
        }, function(e){
            UTL_LOG('UTL_save_filesys onErrorCreateFile'+e.toString());
            if(typeof cb === 'function'){
                cb(false,e);
            }
        });

    },  function(e){
        UTL_LOG('UTL_save_filesys onErrorLoadFs'+e.toString());
        if(typeof cb === 'function'){
            cb(false,e);
        }
    });
};
/***
 * データのファイルシステムからの読み込み
 * info::ios Androidのみ
 * @param file_name
 * @returns {boolean}
 * @constructor
 */
function UTL_load_filesys(file_name,cb){
    window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, function (fs) {
        fs.root.getFile(file_name+".txt", { create: true, exclusive: false }, function (fileEntry) {
            fileEntry.file(function (file) {
                var reader = new FileReader();
                reader.onloadend = function() {
                    UTL_LOG("UTL_load_filesys file read: " + this.result);
                    if(typeof cb === 'function'){
                        cb(this.result,{});
                    }
                };
                reader.readAsText(file);
            }, function(e){
                UTL_LOG('UTL_load_filesys onErrorReadFile'+e.toString());
                if(typeof cb === 'function'){
                    cb(false,e);
                }
            });
        }, function(e){
            UTL_LOG('UTL_load_filesys onErrorCreateFile'+e.toString());
            if(typeof cb === 'function'){
                cb(false,e);
            }
        });
    },  function(e){
        UTL_LOG('UTL_load_filesys onErrorLoadFs'+e.toString());
        if(typeof cb === 'function'){
            cb(false,e);
        }
    });
};
/**
 * 永続的データの保存
 * @param key
 * @param obj
 * @returns {boolean}
 * @constructor
 */
UTL_STORAGE_DATA_VERSION="001";//内部データヴァージョン 変更すると、既存の記憶しているデータを消去(無視)する

function UTL_save_storage(key,obj){
    var storage_json_str="";
    try{
        storage_json_str = JSON.stringify(obj);
    }catch(e){
        storage_json_str="";
    }
    if(!localStorage){
        alert('COM_ERR LocalStorage is invalid');//lang::localStorageは使えません
        return;
    }else{
        localStorage.setItem("MMP_"+UTL_STORAGE_DATA_VERSION+"_"+key,storage_json_str);
        return true;
    }
}


/**
 * 永続的データの取得
 * @param key
 * @returns {*}
 * @constructor
 */
function UTL_load_storage(key){
    var storage_json_str="";
    if(!localStorage){
        alert('COM_ERR LocalStorage is invalid');

        return;
    }else{
        storage_json_str=localStorage.getItem("MMP_"+UTL_STORAGE_DATA_VERSION+"_"+key);
    }
    var obj=null;
    try{
        obj=JSON.parse(storage_json_str);
    }catch(e){
        //alert(e);
    }
    return obj;
};

/**
 * 永続データの指定削除
 * @param key
 * @returns {boolean}
 * @constructor
 */
function UTL_remove_storage(key){
    if(!localStorage){
        alert('COM_ERR LocalStorage is invalid');
        return;
    }else{
        localStorage.removeItem("MMP_"+UTL_STORAGE_DATA_VERSION+"_"+key);
        return true;
    };
}
/**
 * 永続的データの全削除
 * @returns {boolean}
 * @constructor
 */
function UTL_all_delete_storage(){
    if(!localStorage){
        return false;
    }else{
        localStorage.clear();
        return true;
    }
}



/**
 * データのファイルシステムへの保存
 * info::ios Androidのみ
 * @param tar_dir cordova.file.cacheDirectory
 * @param file_name
 * @param data_str
 * @param cb
 * @constructor
 */
function UTL_save_filesys(tar_dir,file_name,data_str,cb){
    //info::cordova.file.documentsDirectoryは iosのみ
    window.resolveLocalFileSystemURL(tar_dir, function (fs) {

        fs.getFile(file_name, { create: true, exclusive: false }, function (fileEntry) {
            // console.log("fileEntry is file?" + fileEntry.isFile.toString());
            //ファイルの書き込み
            fileEntry.createWriter(function (fileWriter) {
                var onwriteend_cb_once_flg=false;//info::fileWriter.onwriteendが時々2回呼ばれる為、CBの重複起動防止
                fileWriter.onwriteend = function() {
                    UTL_LOG("UTL_save_filesys Successful file write: "+fileEntry.name);
                    if(typeof cb === 'function'&&!onwriteend_cb_once_flg){
                        cb(true,{});
                    }
                    onwriteend_cb_once_flg=true;
                };
                fileWriter.onerror = function (e) {
                    UTL_LOG("UTL_save_filesys Failed file write: " + e.toString());
                    if(typeof cb === 'function'){
                        cb(false,e);
                    }
                };
                fileWriter.truncate(0);//info::ファイルの中身をクリア
                var blob = new Blob([data_str], {type: 'text/plain'});//info ios必須
                fileWriter.write(blob);
            });
        }, function(e){
            UTL_LOG('UTL_save_filesys onErrorCreateFile'+e.toString());
            if(typeof cb === 'function'){
                cb(false,e);
            }
        });

    },  function(e){
        UTL_LOG('UTL_save_filesys onErrorLoadFs'+e.toString());
        if(typeof cb === 'function'){
            cb(false,e);
        }
    });
};


/**
 *データのファイルシステムからの読み込み
 * info::ios Androidのみ
 * @param tar_dir cordova.file.cacheDirectory
 * @param file_name
 * @param cb
 * @constructor
 */
function UTL_load_filesys(tar_dir,file_name,cb){

    //info::cordova.file.documentsDirectory はiosのみ　cordova.file.documentsDirectory
    window.resolveLocalFileSystemURL(tar_dir, function (fs) {
        fs.getFile(file_name, { create: false, exclusive: false }, function (fileEntry) {
            fileEntry.file(function (file) {
                var reader = new FileReader();
                reader.onloadend = function() {
                    UTL_LOG("UTL_load_filesys file read: " + this.result);
                    var data_str=this.result;
                    if(typeof cb === 'function'){
                        cb(data_str,{});
                    }
                };
                reader.readAsText(file);
            }, function(e){
                UTL_LOG('UTL_load_filesys onErrorReadFile'+e.toString());
                if(typeof cb === 'function'){
                    cb(false,e);
                }
            });
        }, function(e){
            UTL_LOG('UTL_load_filesys onErrorCreateFile'+e.toString());
            if(typeof cb === 'function'){
                cb(false,e);
            }
        });
    },  function(e){
        UTL_LOG('UTL_load_filesys onErrorLoadFs'+e.toString());
        if(typeof cb === 'function'){
            cb(false,e);
        }
    });
};

/**
 * データのファイルシステムからの削除
 * info::ios Androidのみ
 * @param tar_dir cordova.file.cacheDirectory
 * @param file_name
 * @param cb
 * @constructor
 */
function UTL_remove_filesys(tar_dir,file_name,cb){

    //info::cordova.file.documentsDirectoryは iosのみ
    window.resolveLocalFileSystemURL(tar_dir, function (fs) {
        fs.getFile(file_name, { create: true}, function (fileEntry) {
            fileEntry.remove(function () {
                UTL_LOG("UTL_remove_filesys removed: " );
                if(typeof cb === 'function'){
                    cb(true,{});
                }
            }, function(e){
                UTL_LOG('UTL_remove_filesys onError remove'+e.toString());
                if(typeof cb === 'function'){
                    cb(false,e);
                }
            });
        }, function(e){
            UTL_LOG('UTL_remove_filesys onError getFile'+e.toString());
            if(typeof cb === 'function'){
                cb(false,e);
            }
        });
    },  function(e){
        UTL_LOG('UTL_remove_filesys onError requestFileSystem'+e.toString());
        if(typeof cb === 'function'){
            cb(false,e);
        }
    });
};

/**
 * strが0以外で始まる整数のみで構成されているか
 * UTL_is_str_num_onry(str)　
 */
function UTL_is_str_num_onry(str){
    switch (typeof str){
        case "number":
            return true;
            break;
        case "string":
            return (String(parseInt(str, 10)).length == str.length);
            break;
        default:
            return false;
            break;
    }
}



/**
 *文字の置換
 *replace(対象文字,検索文字（配列）,置換文字（配列）){
 */
function UTL_replace(txtMoji, serch_txt, change_txt){
    for (var intLoop = 0; intLoop < serch_txt.length; intLoop++) {
        txtMoji = txtMoji.split(serch_txt[intLoop]).join(change_txt[intLoop]);
    }
    return txtMoji;
};

/*
 *時間計測
 * @start_time 開始時間　値が有る場合は start_timeからの経過時間
 * @return currentTime
 */
function UTL_get_time(start_time){
    var currentTime = new Date();

    if(start_time){
        return currentTime.getTime()-start_time;
    }else{

        return currentTime.getTime();
    }
}

// コードチェック（文字,範囲小,範囲大）
function UTL_checkCode(str, min, max){
    var len = str.length;
    while (len--) {
        var num = str.substr(len, 1).charCodeAt(0);
        if (num < min || num > max) {
            return false;
            break;
        }
    }
    return true;
}
//端末のOS判定
function UTL_userAgent(){
    var ua;
    var agent = navigator.userAgent;
    if (agent.search(/iPad/) != -1) {
        ua = "ipad";
    }
    else
    if (agent.search(/Android/) != -1) {
        ua = "android";
    }
    else {
        ua = "pc";
    };
    return ua;
};
/**
 * 単位変換　degree >> radian
 * @param degree
 * @returns {number}
 * @constructor
 */
function UTL_conv_deg_to_radi(degree){
    return degree*0.017453292519943295;
}
/**
 * 単位変換　radian >> degree
 * @param radian
 * @returns {number}
 * @constructor
 */
function UTL_conv_radi_to_deg(radian){
    return radian/0.017453292519943295;
}
/**
 * 速度 rpm ->radian/sec に変換
 * @param rpm
 * @returns {number}
 * @constructor
 */
function UTL_conv_rpm_to_radi_sec(rpm){
    //速度 rpm ->radian/sec(Math.PI*2/60)
    return rpm*0.10471975511965977;
}
/**
 * 2点間の距離と角度を求める
 * @param from_x,from_y,to_x,to_y
 * @returns {number}
 * @constructor
 */
function UTL_two_point_dist_angle(from_x,from_y,to_x,to_y){
        var distance= Math.sqrt(Math.pow(from_x - to_x, 2) + Math.pow(from_y - to_y, 2));
        var radian=Math.atan2(from_y - to_y,from_x - to_x);
        return{dist:distance,radi:radian,deg:UTL_conv_radi_to_deg(radian)};
}
/**
 * ローカルのファイルパスからファイル名、パス等に分割 todo::適当ロジック改良
 * @param file_path
 * @returns {Array}
 */
function UTL_FilePathAnalyze(file_path) {
    //todo::[/hogehoge.txt]等ファイルのみの記述は想定外
    // Extract a file name with the extension.
    var fsidx=file_path.lastIndexOf("/");
    var name_ext = fsidx!=-1?file_path.substring(fsidx+1, file_path.length):file_path;
    var protocol_directory=fsidx!=-1?file_path.substring(0,fsidx+1):file_path;
    var pridx=file_path.indexOf("://");
    var protocol= pridx!=-1? protocol_directory.substring(0, pridx):'';
    var directory= pridx!=-1? protocol_directory.substring(pridx+3, protocol_directory.length):protocol_directory;

    var neidx=name_ext.lastIndexOf(".");
    var ext = neidx!=-1?name_ext.substring(neidx+1, name_ext.length):'';
    var name = neidx!=-1?name_ext.substring(0, neidx):name_ext;
    return {name:name,name_ext:name_ext,ext:ext,directory:directory,protocol_directory:protocol_directory,protocol:protocol};
}
/**
 * 指定したプロパティがSetterか調べる target_obj自身か直近のprototypeまで
 * 　(setterプロパティの動的指定時に、setterと間違えて関数や定数の参照を上書きするのを防止する為に使用)
 * @param target_obj
 * @param prop_name
 * @returns {boolean}
 * @constructor
 */
function UTL_IsSetterOnePerentProto(target_obj,prop_name){
    if(!target_obj){return false;}
    var d=Object.getOwnPropertyDescriptor(target_obj,prop_name);
    if(!d){
        d=Object.getOwnPropertyDescriptor(Object.getPrototypeOf(target_obj),prop_name);
    }
    return d!==undefined?Boolean(d.set):false;
}

/**
 * 16進のカラーコードからLED特性に最適化したRGB値に変換
 * @param rgbPureHex 元のRGBコード #RRGGBB or ARRAY
 *  @param is_return_rgbcode_str "#FFAABB"の16進コードで返すか
 * @returns {number[r,g,b]}
 * @constructor
 */

function URL_ConvartLedOptRGBCode(rgbPureHex,is_return_rgbcode_str){
    var rval=null;
    var rgb_ar=[0,0,0];//rgb内部値

    //入力変換 #rrbbgg
    if(typeof rgbPureHex === "string"){
       var r=URL_ConvartRGBArrayFromRGBCode(rgbPureHex);
        rgb_ar=r;
    }else if(rgbPureHex instanceof Array){  //入力変換 array
        rgb_ar[0]=rgbPureHex[0];
        rgb_ar[1]=rgbPureHex[1];
        rgb_ar[2]=rgbPureHex[2];
    }
    //変換処理
    //rval=rgbPureHex;//todo::変換式
    if(is_return_rgbcode_str){
        return "#"+('00'+parseInt(rgb_ar[0]).toString(16)).slice(-2)+('00'+parseInt(rgb_ar[1]).toString(16)).slice(-2)+('00'+parseInt(rgb_ar[2]).toString(16)).slice(-2);
    }else{
        return rgb_ar;    
    }
}
/**
 * 16進のカラーコードからRGB値に変換
 * @param rgbCode
 * @returns {number[]}
 * @constructor
 */
function URL_ConvartRGBArrayFromRGBCode(rgbCode){
    var rgb_ar=[0,0,0];//rgb内部値
    //入力変換 #rrbbgg
    if(typeof rgbCode === "string"){
        var t= rgbCode.split("#").join('');
        if(t.length===3){
            var r_g_b= t.split("");
            rgb_ar[0]=parseInt(r_g_b[0],16)*17;
            rgb_ar[1]=parseInt(r_g_b[1],16)*17;
            rgb_ar[2]=parseInt(r_g_b[2],16)*17;
        }else if(t.length===6){
            var r_g_b=t.match(/[\s\S]{1,2}/g) || [];
            rgb_ar[0]=parseInt(r_g_b[0],16);
            rgb_ar[1]=parseInt(r_g_b[1],16);
            rgb_ar[2]=parseInt(r_g_b[2],16);
        }
    }
    return rgb_ar;
}
/**
 * BLEのadvertisingデータのparse Android用
 * advertisingデータのフォーマット　https://fabo.gitbooks.io/bledocs/content/nordic/beaconadvdata.html
 * @param arrayBuffer
 * @constructor
 */
function UTL_parseAdvertisementPacket(arrayBuffer) {
    var advObj=__UTL_parseAdvertisementPacket(arrayBuffer);
    var keys=Object.keys(advObj);
    for(var cnt=0;cnt<keys.length;cnt++){
        var key=keys[cnt];
        switch (key) {
            case "0x02": // Partial list of 16-bit UUIDs
            case "0x03": // Complete list of 16-bit UUIDs
                var data=new Uint8Array(advObj[key]);
                if(data.length>1){
                    var hexStr=UTL_toHexString(data[1])+UTL_toHexString(data[0]);//リトルエンディアン hex表記stringに変換
                    advObj["advDataServiceUUIDs16bit"]=hexStr+"-0000-1000-8000-00805f9b34fb";
                }
                break;
            case "0x06":// Partial list of 128-bit UUIDs
            case "0x07":// Complete list of 128-bit UUIDs
                var ini=new Uint8Array(advObj[key]);
                if(ini.length>=16){
                    var data=[];
                    for(var i=0;i<ini.length;i++){
                        data[i]=ini[i];
                    }
                    data.reverse();//UUIDはリトルエンディアンなので最下位バイトから組み立て
                    var hexStr=(data.map(function (value, index, array) {
                        return UTL_toHexString(value)+(index==3||index==5||index==7||index==9?'-':''); //4,6,8,10バイト目のセパレータ
                    })).join('');
                    advObj["advDataServiceUUIDs"]=hexStr;
                }
                break;
            case "0x08":// Shortened local name
            case "0x09"://Complete local name
                advObj["advDataLocalName"]=UTL_parseBLEStringPacket(advObj[key]);
                break;
            case "0xff"://Manufacture Specific
                advObj["advDataSpecific"]=UTL_parseBLEStringPacket(advObj[key]);
                break;

        }
    }
    return advObj;
}
/**
 * BLEのStringパケットをUTF8のテキストにparse (要TextDecoder)
 * @param arrayBuffer
 * @constructor
 */
function UTL_parseBLEStringPacket(uint8arrayBuffer) {
    var uarray = new Uint8Array(uint8arrayBuffer);
    var asciiStr="";
    if(TextDecoder){
        asciiStr=new TextDecoder("utf-8").decode(uarray);
    }else{
        asciiStr="ERR_TextDecoderNotWork";
    };
    return asciiStr;
}
/**
 * 内部用　BLEのadvertisingデータのparse Android用
 * @param arrayBuffer
 * @constructor
 */

__UTL_parseAdvertisementPacket=function(buffer) {
    var length, type, data, i = 0, advertisementData = {};
    var bytes = new Uint8Array(buffer);

    while (length !== 0) {

        length = bytes[i] & 0xFF;
        i++;

        // decode type constants from https://www.bluetooth.org/en-us/specification/assigned-numbers/generic-access-profile
        type = bytes[i] & 0xFF;
        i++;

        data = bytes.slice(i, i + length - 1).buffer; // length includes type byte, but not length byte
        i += length - 2;  // move to end of data
        i++;

        advertisementData["0x"+UTL_toHexString(type)] = data;
    }

    return advertisementData;
};

/**
 * 0xnnの16進表示に変換
 * @param i
 * @returns {string}
 * @constructor
 */
function UTL_toHexString(i) {
    var hex;

    hex = i.toString(16);

    // zero padding
    if (hex.length === 1) {
        hex = "0" + hex;
    }

    return hex;
}
/**
 * JSONからparse出来る場合はパースする。出来ない場合は入力値を返す失敗はnull
 * @param jsonstr
 * @returns {*}
 * @constructor
 */
function UTL_TRY_JSON_parse(jsonstr){
    if(typeof jsonstr==="string"){
        var r=null;
        try{
            r= JSON.parse(jsonstr)
        }catch (e){

        }
        return r;
    }else{
        return jsonstr;
    }
}
/**
 * デバッグ用メッセージ console.logのラッパー
 * @constructor
 */
UTL_LOG=(function(){
   return console.log.bind(console);
})();


//オブジェクトのdeepコピー ビルトイン拡張  ex) UTL_clone(obj):copy object
UTL_clone = (function() {
    /**
     * Clones (copies) an Object using deep copying.
     *
     * This function supports circular references by default, but if you are certain
     * there are no circular references in your object, you can save some CPU time
     * by calling clone(obj, false).
     *
     * Caution: if `circular` is false and `parent` contains circular references,
     * your program may enter an infinite loop and crash.
     *
     * @param `parent` - the object to be cloned
     * @param `circular` - set to true if the object to be cloned may contain
     *    circular references. (optional - true by default)
     * @param `depth` - set to a number if the object is only to be cloned to
     *    a particular depth. (optional - defaults to Infinity)
     * @param `prototype` - sets the prototype to be used when cloning an object.
     *    (optional - defaults to parent prototype).
     */
    function clone(parent, circular, depth, prototype) {
        var filter;
        if (typeof circular === 'object') {
            depth = circular.depth;
            prototype = circular.prototype;
            filter = circular.filter;
            circular = circular.circular;
        }
        // maintain two arrays for circular references, where corresponding parents
        // and children have the same index
        var allParents = [];
        var allChildren = [];

        var useBuffer = typeof Buffer != 'undefined';

        if (typeof circular == 'undefined')
            circular = true;

        if (typeof depth == 'undefined')
            depth = Infinity;

        // recurse this function so we don't reset allParents and allChildren
        function _clone(parent, depth) {
            // cloning null always returns null
            if (parent === null)
                return null;

            if (depth === 0)
                return parent;

            var child;
            var proto;
            if (typeof parent != 'object') {
                return parent;
            }

            if (clone.__isArray(parent)) {
                child = [];
            } else if (clone.__isRegExp(parent)) {
                child = new RegExp(parent.source, __getRegExpFlags(parent));
                if (parent.lastIndex) child.lastIndex = parent.lastIndex;
            } else if (clone.__isDate(parent)) {
                child = new Date(parent.getTime());
            } else if (useBuffer && Buffer.isBuffer(parent)) {
                child = new Buffer(parent.length);
                parent.copy(child);
                return child;
            } else {
                if (typeof prototype == 'undefined') {
                    proto = Object.getPrototypeOf(parent);
                    child = Object.create(proto);
                }
                else {
                    child = Object.create(prototype);
                    proto = prototype;
                }
            }
            if (circular) {
                var index = allParents.indexOf(parent);

                if (index != -1) {
                    return allChildren[index];
                }
                allParents.push(parent);
                allChildren.push(child);
            }

            for (var i in parent) {
                var attrs;
                if (proto) {
                    attrs = Object.getOwnPropertyDescriptor(proto, i);
                }

                if (attrs && attrs.set == null) {
                    continue;
                }
                child[i] = _clone(parent[i], depth - 1);
            }

            return child;
        }

        return _clone(parent, depth);
    }
    /**
     * Simple flat clone using prototype, accepts only objects, usefull for property
     * override on FLAT configuration object (no nested props).
     *
     * USE WITH CAUTION! This may not behave as you wish if you do not know how this
     * works.
     */
    clone.clonePrototype = function clonePrototype(parent) {
        if (parent === null)
            return null;

        var c = function () {};
        c.prototype = parent;
        return new c();
    };

// private utility functions

    function __objToStr(o) {
        return Object.prototype.toString.call(o);
    }
    clone.__objToStr = __objToStr;

    function __isDate(o) {
        return typeof o === 'object' && __objToStr(o) === '[object Date]';
    }
    clone.__isDate = __isDate;

    function __isArray(o) {
        return typeof o === 'object' && __objToStr(o) === '[object Array]';
    }
    clone.__isArray = __isArray;

    function __isRegExp(o) {
        return typeof o === 'object' && __objToStr(o) === '[object RegExp]';
    }
    clone.__isRegExp = __isRegExp;

    function __getRegExpFlags(re) {
        var flags = '';
        if (re.global) flags += 'g';
        if (re.ignoreCase) flags += 'i';
        if (re.multiline) flags += 'm';
        return flags;
    }
    clone.__getRegExpFlags = __getRegExpFlags;

    return clone;
})();


