// -------------------//
// 各デバイスで使用する構造体 ES6
// info::「Object.assign」IE11 not work
// -------------------//


/**
 * section::構造体の基本メソッド
 * EQ:同じ値を持つかの比較
 * Clone:複製
 * GetValObj:値の取得（Obj）
 * GetValArray:値の取得（配列）
 */
class ST_Base{
    constructor(){
    }
    //値の比較
    EQ (tar) {
        if(! tar ){return false;}
        if(this.constructor===tar.constructor){
            if(this.GetValArray){
                return this.GetValArray().toString()===tar.GetValArray().toString();
            }else if(this.GetValObj){
                return JSON.stringify(this.GetValObj())===JSON.stringify(tar.GetValObj());// bad::遅い
            }
        }
        return false;
    }
    //複製
    Clone () {
        return Object.assign(new this.constructor(),this);
    }
    //取得 Object
    GetValObj () {
        return Object.assign({},this);
    }
    GetValArray () {
        var k=Object.keys(this);
        var r=[];
        for(var i=0;i<k.length;i++){
            r.push(this[k[i]]);
        }
        return r;
    }
};

/**
 * section::BLEデバイスの情報
 * device_name:String BLEのデバイス名
 * device_uuid:String BLEのUUID OSにで自動で付けられる
 * service_uuid:String
 * is_pairing:bool (ペアリングするか? true/false)
 * is_existing:bool (デバイスの存在 true/false)
 * LedStateColor:[r,g,b]//LED色の初期値
 */
class ST_BLEDeviceInfo extends ST_Base{
    /**
     * @param BLEApiRawObj
     */
    constructor (BLEApiRawObj){
        super();
        if(!BLEApiRawObj){return;}
        this.device_name=BLEApiRawObj["name"] !== undefined ? BLEApiRawObj["name"] : "";
        this.device_uuid=BLEApiRawObj["id"] !== undefined ? BLEApiRawObj["id"] : "";
        this.is_pairing=false;
        this.is_existing=true;
        this._connectTry=false;//BLEの接続処理中のフラグ（info::Androidのble.connectの接続完了CB発火前の重複接続で切断出来ない問題回避用）
        this._exisScan=false;//存在確認の為のマーカー（SearchDeviceスキャン処理用 (false:未処理・検出済み 1:検出処理中 )
        this.main_service_uuid=null;
        
        //LED色の初期値
        this.LedStateColor=[];
        if(this.device_name && this.device_name.split('#').length==2){
            this.LedStateColor=URL_ConvartRGBArrayFromRGBCode(this.device_name.split('#')[1]);
        }


        if(BLEApiRawObj.advertising){
            var s_uuid=null;
            if(BLEApiRawObj.advertising.kCBAdvDataServiceUUIDs instanceof Array){ //info::advertisingデータの取得 iosは BLEApiRawObj.advertisingにparseされたadvertisingオブジェクトが返る
               s_uuid=BLEApiRawObj.advertising.kCBAdvDataServiceUUIDs[0];//info::代表的なサービスUUID デバイスの製品識別に使用
            }else if(BLEApiRawObj.advertising instanceof ArrayBuffer){//info::advertisingデータの取得 androidは BLEApiRawObj.advertisingにbufferで返る為parseする
              //  var adData = new Uint8Array(BLEApiRawObj.advertising);
               var uuids= UTL_parseAdvertisementPacket(BLEApiRawObj.advertising);
                s_uuid=uuids["advDataServiceUUIDs"];
            }
            console.log(s_uuid);
            this.main_service_uuid=String(s_uuid).toLowerCase();//何故かBLEのAPIが大文字で返って来る為

        }


    }
}

/**
 * section::XY座標
 */
class ST_Vector2 extends ST_Base {
    constructor (x, y) {
        super();
        this.x = x ? x : 0;
        this.y = y ? y : 0;
    }
    move (dx, dy) {
        this.x += dx;
        this.y += dy;
    }
    //2点間の距離
    Distance (vector2) {
        if (!(vector2 instanceof ST_Vector2)) {return;}
        return Math.sqrt(Math.pow((this.x-vector2.x),2) + Math.pow((this.y-vector2.y),2));
    }
    //2点間の角度
    Radian (vector2) {
        if (!(vector2 instanceof ST_Vector2)) {return;}
        return Math.atan2(this.y-vector2.y,this.x-vector2.x);
    }
    //0,0からの距離
    DistanceFromZero() {
        return Math.sqrt(Math.pow(this.x,2) + Math.pow(this.y,2));
    }
    //0,0からの角度
    RadianFromZero() {
        return Math.atan2(this.y,this.x);
    }
}
/**
 * section::XYZ 3次元ベクトル
 */
class ST_Vector3 extends ST_Base {
    constructor(x,y,z) {
        super();
        this.x = x?x:0;
        this.y = y?y:0;
        this.z = z?z:0;
    }
    //移動
    move (dx, dy,dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }
    //2点間の距離
    Distance (vector3) {
        if (!(vector3 instanceof ST_Vector3)) {return;}
        return Math.sqrt(Math.pow((this.x-vector3.x),2) + Math.pow((this.y-vector3.y),2)+ Math.pow((this.z-vector3.z),2));
    }
    //2点間の角度(回転方向の情報なし)
    Radian (vector3) {
        if (!(vector3 instanceof ST_Vector3)) {return;}
        //todo::2点間の角度(回転方向の情報なし)
    }
    //0,0からの距離
    DistanceFromZero () {
        return Math.sqrt(Math.pow(this.x,2) + Math.pow(this.y,2)+ Math.pow(this.z,2));
    }
    //0,0,0からの角度
    RadianFromZero () {
        //todo::0,0,0からの角度
    }
}

/**
 * KEIGANモーターLED　点灯・色状態
 * State MOTOR_LED_STATE
 * ColorR 0-255
 * ColorG 0-255
 * ColorB 0-255
 * */
class ST_MTLedState extends ST_Base {
    static get MOTOR_LED_STATE(){
        return{
            "MOTOR_LED_STATE_OFF":0,//LED消灯
            "MOTOR_LED_STATE_ON_SOLID":1,//LED点灯（点灯しっぱなし）
            "MOTOR_LED_STATE_ON_FLASH":2,//LED点滅（一定間隔で点滅）
            "MOTOR_LED_STATE_ON_DIM":3  //LEDがゆっくり輝度変化する
        }
    }
    constructor(State,ColorR,ColorG,ColorB) {
        super();
        this.State=UTL_N(State);
        this.ColorR=UTL_N(ColorR);
        this.ColorG=UTL_N(ColorG);
        this.ColorB=UTL_N(ColorB);
    }
}

/**
 * section::モーター回転情報
 */
class ST_MTRotState extends ST_Base {
    //変速比変換　配列等引き渡し(静的)
    static ConvertGearRatio(Array_or_rotst,gear_ratio){
        if(!Number.isFinite(gear_ratio)){
            return Array_or_rotst;
        }
        switch (Array_or_rotst.constructor){
            case ST_Vector3:
                return [Array_or_rotst.x*gear_ratio,Array_or_rotst.y*gear_ratio,Array_or_rotst.z];
                break;
            case ST_MTRotState:
                return Array_or_rotst.Clone().ConvertGearRatio(gear_ratio);
                break;
            case Array:
                return [Array_or_rotst[0]*gear_ratio,Array_or_rotst[1]*gear_ratio,Array_or_rotst[2]];
                break;
            default:
                return Array_or_rotst;
                break;
        }
    }
    static get MAX_TORQUE(){
        return 0.3;//0.3 N・m
    }
    static get MAX_SPEED_RPM(){
        return 300;//300rpm
    }
    static get MAX_SPEED_RADIAN(){
        return UTL_conv_rpm_to_radi_sec(300);
    }
    static get MAX_POSITION(){
        return 3*Math.pow(10,38);//info::「return　3e+38」はminifyでエラー
        //return　3e+38;//radian 4byte float　1.175494 10-38  < 3.402823 10+38
    }
    constructor(Position, Speed, Torque) {
        super();
        this.Position = UTL_N(Position);
        this.Speed = UTL_N(Speed);
        this.Torque = UTL_N(Torque);
    }
    //info::破壊関数 変速比変換 トルクは変わらない
    ConvertGearRatio(gear_ratio){
        if(Number.isFinite(gear_ratio)){
            this.Position =this.Position*gear_ratio;
            this.Speed = this.Speed*gear_ratio;
        }
        return this;
    }
}


/**
 * section::汎用操作プロトコル
 * Command 制御するコマンド名
 * Val　
 * targetID 仮想デバイスID　command指定時にこの値があると、指定したデバイスIDのみが処理する
 */
class ST_CtlProtocol extends ST_Base {
    constructor(Command,Val,targetID) {
        super();
        this.Command= Command!=undefined?Command:undefined;
        this.Val= Val!=undefined?Val:undefined;
        this.targetID=targetID!=undefined?targetID:undefined;
    }
}
/**
 * section::汎用通知プロトコル
 * NotifyName 通知の種類(任意のタグ)
 * Val　
 * originID 発生元の仮想デバイスID
 */
class ST_NotifyProtocol extends ST_Base {
    constructor(NotifyName,Val,originID) {
        super();
        this.NotifyName= NotifyName!=undefined?NotifyName:undefined;
        this.Val= Val!=undefined?Val:undefined;
        this.originID=originID!=undefined?originID:undefined;
    }
}


