//Copyright (c) 2010 Nicholas C. Zakas. All rights reserved.
//MIT License
//https://www.nczonline.net/blog/2010/03/09/custom-events-in-javascript/
function EventTarget(){
    this._listeners = {};
   // this._FilterHocks = {};
}

EventTarget.prototype = {

    constructor: EventTarget,
    addListener: function(type, listener){
        if(typeof listener !=="function"){
            throw new Error("addListener listener Error function onry");

        }
        // if(typeof this._FilterHocks[type]==="function"){
        //     this._FilterHocks[type]();
        // }
        if (typeof this._listeners[type] === "undefined"){
            this._listeners[type] = [];
        }else {
            //同じリスナーの重複バインドを防止
            var tg=this._listeners[type];
            for(var i=0;i<tg.length;i++){
                if(tg[i]===listener){
                   // console.log("info::同じリスナーを重複バインドしようとした");//todo::debug
                    return;
                }
            }
        }

        this._listeners[type].push(listener);
       // DEBUG_EventTarget_lisCounter(1);//info::debug
    },
    
    ////特定のイベントをバインド時のホックフィルター（デバイスのバインド時に1対1のみのバインドを許可する場合等で使用）
    //addListenerFilterHock:function(type,Hockfunc){
    //    this._FilterHocks[type]=Hockfunc;
    //},
    fire: function(event){
        if (typeof event === "string"){
            event = { type: event };
        }
        if (!event.target){
            event.target = this;
        }

        if (!event.type){  //falsy
            throw new Error("Event object missing 'type' property.");
        }

        if (this._listeners[event.type] instanceof Array){
            var listeners = this._listeners[event.type];
            for (var i=0, len=listeners.length; i < len; i++){
                listeners[i].call(this, event);
            }
        }
    },

    removeListener: function(type, listener){
        if (this._listeners[type] instanceof Array){
            var listeners = this._listeners[type];
            if(typeof listener ==="string"){
                for (var i=0, len=listeners.length; i < len; i++){
                    if (listeners[i].name === listener){
                        listeners.splice(i, 1);
                       // DEBUG_EventTarget_lisCounter(-1);//info::debug
                        break;
                    }
                }
            }else if(typeof listener ==="function"){
                for (var i=0, len=listeners.length; i < len; i++){
                    if (listeners[i] === listener){
                        listeners.splice(i, 1);
                        //DEBUG_EventTarget_lisCounter(-1);//info::debug
                        break;
                    }
                }
            }else{
                throw new Error("removeListener listener Type Error");
            }
        }
    }
};

///info::debug::リスナーの登録数カウント（デバッグメモリーリーク検出用）
// var _EventTarget_lisCounter=0;
// function DEBUG_EventTarget_lisCounter(cnt){
//     _EventTarget_lisCounter+=cnt;
//     console.log("lisCounter:"+_EventTarget_lisCounter);
// }