/**************************************************************************************
 * デバイス値バインダー　　DeviceValBinder
 * ●イベント EventHandler
 *   OnBindChange(this) バインド解除
 *   OnDestory(this)
 *   ●公開プロパティ
 *   ・ValSettrCB:function //ValSet時のリスナーCB function(val){}
 *   ・ValGettrCB:function //ValGet時のリスナーCB function(){return val;}
 *   ・device_innerid:str //デバイスUID　_AbstractDevice_base.PROP.UIDを使用
 *   ・binder_name このバインダーの名前（キー データ保存に使用 変更不可）
 *   ・binder_show_name このバインダーのUIに表示する名称
 *   ・binder_info_txt バインダーの説明
 *   ・type_list:bit //このバインダーのデータ型のbitフラグ
 *   ・dataflow_list:bit //このバインダーのデータ接続方向タイプのbitフラグ
 *   ・allow_Comparator:bit //許可する接続タイプのbitフラグ
 *   　　ここに記述があると、記述中のどれかに合致するtype_listの物が接続出来る。 空は全て許可
 *
 *   ・binding_binder_info:{binding_binder_device_innerid,binding_binder_name} //バインド先情報取得(状態保存に使用)　
 *
 *   ・Par_Val: Get:(バインド先のValGettrCB) Set:(バインド先のValSettrCB)//バインド先の値の送受信
 *   ・My_Val: Get:(自身のValGettrCB) Set:(自身のValSettrCB)//自分自身へののバインダーの値操作（モーターの設定画面での入力確認用等で使用）
 *   ・is_bind: Get:Bool //どこかにバインド済みか
 *   ・target_ref: Get:ref //バインド先の参照を取得
 *   ●メソッド（スタテック）
 *   ・DeviceValBinder_AllReBind() //全てのバインダーの再バインドを行う（データ復帰時）
 *   ●メソッド
 *   ・Binding(DeviceBinder) //バインドを行う
 *   ・UnBinding() //バインド解除
 *   ・IsBindingTypeMatch(DeviceBinder):Bool //バインド可能なタイプか
 *   ・IsBindingTargetEq(DeviceBinder) //バインド先がDeviceBinderと同じ物か? :Bool
 *   ・Destory() //オブジェクトの廃棄（実際に廃棄はしない(出来ない) リストからの削除と廃棄イベント発行を行う)
 *
 *   ●メソッド（内部）
 *   ・ReBind()//復帰時自動再バインド用
 *************************************************************************************/


/************************************************************************************
 *
 * 定数定義　todo::JSのbit演算は32bitなので容量的にtype_listにdataflow_listを纏められるかも
 *
 ************************************************************************************/

//バインドのデータ型の種類 値はバインダー種別の適合ビットフラグ.xls参照
DeviceValBinder_TYPE_LIST={
        //デバイスタイプ 1-8bit
        // "DEVICE_MASTER":0x80      //10000000 接続の主となる属性（モジュール等）
        // ,"DEVICE_SLAVE":0x40      //01000000　接続の従となる属性（入力・モーター等）
        "DEVICE_MODULE":0x10  //00010000 　旧"DEVICE_LOGIC":モジュールは機能がまとまったものを示すので、ロボットや入力問わず汎用的に使える。
        ,"DEVICE_INPUT":0x8      //00001000　入力装置
        ,"DEVICE_MOTOR":0x4     //00000100
        ,"DEVICE_ROBOT":0x1    //00000001 ,旧"DEVICE_MODULE"　動作を実現する機能体
        ,"DEVICE_ALL":0xFF
        //変数型 9-20bit
        ,"VAL_MT_LEDSTATE":0x80000//20
        ,"VAL_STRING":0x40000//19
        ,"VAL_CTL_REC":0x20000//18
        ,"VAL_CTL_MT":0x10000//bitNum 17
        ,"VAL_MT_ROTSTATE":0x8000//bitNum 16
        ,"VAL_FLOAT":0x4000//bitNum 15
        ,"VAL_INT":0x2000//bitNum 14
        ,"VAL_NUMBER":0x4000|0x400|0x2000//DeviceValBinder_TYPE_LIST.VAL_FLOAT | DeviceValBinder_TYPE_LIST.VAL_BOOL | DeviceValBinder_TYPE_LIST.VAL_INT
        ,"VAL_ARRAY":0x1000//bitNum 13
        ,"VAL_OBJ":0x800//bitNum 12
        ,"VAL_BOOL":0x400//bitNum 11
        ,"VAL_VECTOR2":0x200//bitNum 10
        ,"VAL_VECTOR3":0x100//bitNum 9
        ,"VAL_ALL":0xFFFFF00//28
};

//UIに表示するバインダーのカテゴリ　通常とAdvanceタブ
DeviceValBinder_UI_SHOW_TYPE={
    "Normal":0,
    "Advance":1

};
DeviceValBinder_TYPE_MASK_LIST={
    "DEVICE_MASK":0xFF  //デバイスタイプ 1-8bit
    ,"VAL_MASK":0xFFFFF00  //変数型 9-28bit
    ,"DATA_FLOW_MASK":0xFF  //データ方向 1-8bit
};

DeviceValBinder_DATA_FLOW_LIST={
    //データ方向 1-8bit
    "DATA_FLOW_OUT":0x8//00001000
    ,"DATA_FLOW_GET":0x4//00000100
    ,"DATA_FLOW_IN":0x2//00000010
    ,"DATA_FLOW_PULL":0x1//00000001
};


/**
 * スタテック変数・関数
 */
DeviceValBinder_Binder_AllList=[];//生成されたバインダーの全リスト
//全てのバインダーの再バインドを行う（データ復帰時）
DeviceValBinder_AllReBind =function(){
    for(var i=0;i<DeviceValBinder_Binder_AllList.length;i++){
        DeviceValBinder_Binder_AllList[i].ReBind();
    }
};
/**
 * DeviceValBinder_TYPE_LISTのbitフラグに該当するNameをリストで返す
 * @param type_list_bit
 * @returns {Array}
 * @constructor
 */
DeviceValBinder_TypeListBitToTypeNames = function(type_list_bit){
    var ar=[];
    if(DeviceValBinder_TYPE_LIST.VAL_ALL===(DeviceValBinder_TYPE_LIST.VAL_ALL & type_list_bit)){//VAL_ALLのみ判定
        ar.push("VAL_ALL");
    }else{
        var k=Object.keys(DeviceValBinder_TYPE_LIST);
        for(var i=0;i<k.length;i++){
            if(DeviceValBinder_TYPE_LIST[k[i]]===(DeviceValBinder_TYPE_LIST[k[i]] & type_list_bit)){//&演算はVAL_ALL除け
                //VAL_NUMBERの場合VAL_INT、VAL_FLOAT、VAL_BOOLは抽出しない
                if((DeviceValBinder_TYPE_LIST.VAL_NUMBER===(DeviceValBinder_TYPE_LIST.VAL_NUMBER&type_list_bit)&&
                    (DeviceValBinder_TYPE_LIST[k[i]]===DeviceValBinder_TYPE_LIST.VAL_INT||DeviceValBinder_TYPE_LIST[k[i]]===DeviceValBinder_TYPE_LIST.VAL_BOOL||DeviceValBinder_TYPE_LIST[k[i]]===DeviceValBinder_TYPE_LIST.VAL_FLOAT))){
                    continue;
                }
                ar.push(k[i]);
            }
        }
    }
    return ar;
};

/**
 * DeviceValBinder_TYPE_LISTのbitフラグに該当する変数型「VAL_XXX」のみのNameをリストで返す
 * バインダーの型表示用でDEVICEタイプを除く表示用
 * @param type_list_bit
 * @returns {Array}
 * @constructor
 */
DeviceValBinder_TypeListBitToTypeNames_AtVariableOnry = function(type_list_bit){
    var ar=[];
    if(DeviceValBinder_TYPE_LIST.VAL_ALL===(DeviceValBinder_TYPE_LIST.VAL_ALL & type_list_bit)){//VAL_ALLのみ判定
        ar.push("VAL_ALL");
    }else{
        var k=Object.keys(DeviceValBinder_TYPE_LIST);
        for(var i=0;i<k.length;i++){
            //デバイスタイプ(1-8bit)の名称は除く
            if(DeviceValBinder_TYPE_LIST[k[i]]&DeviceValBinder_TYPE_LIST.DEVICE_ALL){
                continue;
            }
            if(DeviceValBinder_TYPE_LIST[k[i]]===(DeviceValBinder_TYPE_LIST[k[i]] & type_list_bit)){//&演算はVAL_ALL除け
                //VAL_NUMBERの場合VAL_INT、VAL_FLOAT、VAL_BOOLは抽出しない
                if((DeviceValBinder_TYPE_LIST.VAL_NUMBER===(DeviceValBinder_TYPE_LIST.VAL_NUMBER&type_list_bit)&&
                    (DeviceValBinder_TYPE_LIST[k[i]]===DeviceValBinder_TYPE_LIST.VAL_INT||DeviceValBinder_TYPE_LIST[k[i]]===DeviceValBinder_TYPE_LIST.VAL_BOOL||DeviceValBinder_TYPE_LIST[k[i]]===DeviceValBinder_TYPE_LIST.VAL_FLOAT))){
                    continue;
                }
                ar.push(k[i]);
            }
        }

    }
    return ar;
};
/**
 * DeviceValBinder_DATA_FLOW_LISTのbitフラグに該当するNameをリストで返す
 * @param data_flow_list_bit
 * @returns {Array}
 * @constructor
 */
DeviceValBinder_DataFlowListBitToDataFlowNames = function(data_flow_list_bit){
    var ar=[];
    var k=Object.keys(DeviceValBinder_DATA_FLOW_LIST);
    for(var i=0;i<k.length;i++){
        if(DeviceValBinder_DATA_FLOW_LIST[k[i]]===(DeviceValBinder_DATA_FLOW_LIST[k[i]] & data_flow_list_bit)){
            ar.push(k[i]);
        }
    }
    return ar;
};
/**
 * コンストラクタ
 * @param arg:{}
 * @param ValSettrCB バインド先から変更を通知された時のCB function(val){}
 * @param ValGettrCB バインド先から取得要求時のCB function(){return val;}
 * @param device_innerid デバイスUID
 * @param binder_name このバインダーの名前（キー データ保存に使用 変更不可）
 * @param binder_show_name このバインダーのUIに表示する名称
 * @param binder_info_txt バインダーの説明
 * @param type_list 自身の接続タイプの型の配列
 * @param dataflow_list このバインダーのデータ接続方向タイプのbitフラグ
 * @param allow_Comparator:bit 許可する接続タイプの値 
 * @param binding_binder_info バインド先情報(指定があると生成時に指定先に自動バインドされる 復帰用){binding_binder_device_innerid:接続先のデバイスUID,binding_binder_name:接続先のバインダーの名前}
 * @param is_private  バインダーをプライベートで非公開(DeviceValBinder_Binder_AllListに登録しない。バインドリストに表示しない)　仮想デバイス内での仮想デバイスの内部生成用
 * @constructor
 */


function DeviceValBinder(arg) {
    "use strict";
    if(!arg.is_private){
        DeviceValBinder_Binder_AllList.push(this);
    }
    this.EventHandler=new EventTarget();

    this._ValSettrCB= (typeof arg.ValSettrCB==="function")?arg.ValSettrCB:function(val){};
    this._ValGettrCB= (typeof arg.ValGettrCB==="function")?arg.ValGettrCB:function(){return undefined;};
    this._device_innerid=arg.device_innerid;
    this._binder_name=arg.binder_name;
    this._binder_show_name=arg.binder_show_name?arg.binder_show_name:this._binder_name;
    this._binder_info_txt=arg.binder_info_txt?arg.binder_info_txt:'';
    this._owner=arg.owner;
    this._type_list=arg.type_list?arg.type_list:0;
    this._dataflow_list=arg.dataflow_list?arg.dataflow_list:0;
    this._allow_Comparator=arg.allow_Comparator?arg.allow_Comparator:0;
    

    //binding_binder_infoの展開
    this._binding_binder_device_innerid=arg.binding_binder_info?arg.binding_binder_info.binding_binder_device_innerid:undefined; //接続先のデバイスUID
    this._binding_binder_name=arg.binding_binder_info?arg.binding_binder_info.binding_binder_name:undefined; //接続先のバインダーの名前
    this._binding_binder_show_name=arg.binding_binder_info?arg.binding_binder_info.binding_binder_show_name:undefined;
    this._binding_binder_ref=undefined;//接続先のバインダーの参照

    this._ui_show_type=arg.ui_show_type!=undefined?arg.ui_show_type:DeviceValBinder_UI_SHOW_TYPE.Normal;
////
};

/**
 * デバイスタイプ、変数型、データ方向、のどちからの指定が無い場合にデフォルト値(全て許可)を設定する
 * @param bits
 * @returns {*}
 */
DeviceValBinder.prototype._allow_Comparator_default_mask=function(bits){
    if(bits){
        var f_dev= ((bits & DeviceValBinder_TYPE_MASK_LIST.DEVICE_MASK)===0)?(bits | DeviceValBinder_TYPE_MASK_LIST.DEVICE_MASK):bits;
        var f_val= ((bits & DeviceValBinder_TYPE_MASK_LIST.VAL_MASK)===0)?(bits | DeviceValBinder_TYPE_MASK_LIST.VAL_MASK):bits;
        return f_dev|f_val;
    }else{
       return bits;
    }

};
/**
 * イベントタイプ定数
 */
DeviceValBinder.prototype.EventHandlerType={"OnBindChange":"OnBindChange","OnDestory":"OnDestory"};
/**
 * パブリックプロパティ
 */
Object.defineProperty(DeviceValBinder.prototype,'device_innerid',{get:function() {return this._device_innerid;}});//デバイスUID(R)
Object.defineProperty(DeviceValBinder.prototype,'binder_name',{get:function() {return this._binder_name;}});//このバインダーの名前(R)
Object.defineProperty(DeviceValBinder.prototype,'binder_show_name',{get:function() {return this._binder_show_name;}});
Object.defineProperty(DeviceValBinder.prototype,'binder_info_txt',{get:function() {return this._binder_info_txt;}});
Object.defineProperty(DeviceValBinder.prototype,'owner_name',{get:function() {return this._owner.device_name+" "+this._owner.device_sub_name;}});//このバインダーの所有者名(R)
Object.defineProperty(DeviceValBinder.prototype,'owner',{get:function() {return this._owner;}});//このバインダーの所有者(R)

Object.defineProperty(DeviceValBinder.prototype,'owner_device_type',{get:function() {return this._owner.device_type;}});

Object.defineProperty(DeviceValBinder.prototype,'type_list',{get:function() {return this._type_list;}});//自身の接続タイプの値
Object.defineProperty(DeviceValBinder.prototype,'dataflow_list',{get:function() {return this._dataflow_list;}});//このバインダーのデータ接続方向タイプのbitフラグ

Object.defineProperty(DeviceValBinder.prototype,'type_names',{get:function() {return DeviceValBinder_TypeListBitToTypeNames(this._type_list)}});//バインダーの接続タイプ名
Object.defineProperty(DeviceValBinder.prototype,'type_names_variable_onry',{get:function() {return DeviceValBinder_TypeListBitToTypeNames_AtVariableOnry(this._type_list)}});//バインダーの接続タイプ名 変数型のみ
Object.defineProperty(DeviceValBinder.prototype,'dataflow_names',{get:function() {return DeviceValBinder_DataFlowListBitToDataFlowNames(this._dataflow_list)}});//バインダーのデータ方向名

Object.defineProperty(DeviceValBinder.prototype,'allow_Comparator',{get:function() {return this._allow_Comparator;}});//許可する接続タイプの値
Object.defineProperty(DeviceValBinder.prototype,'binding_binder_info',{get:function() {return {binding_binder_device_innerid:this._binding_binder_device_innerid,binding_binder_name:this._binding_binder_name,binding_binder_show_name:this._binding_binder_show_name};}});//バインド先情報取得(状態保存に使用)(R)

Object.defineProperty(DeviceValBinder.prototype,'is_bind',{get:function() {return this._binding_binder_ref?true:false;}});//どこかにバインドされているか
Object.defineProperty(DeviceValBinder.prototype,'is_binding_compatible',{//バインド済みの場合、バインダーの型がお互い適合している状態でバインドされているか
    get:function() {
        if(this.is_bind){
            return this.IsBindingTypeMatch(this.target_ref);
        }else{
            return true;
        }
    }
});//どこかにバインドされているか
Object.defineProperty(DeviceValBinder.prototype,'target_ref',{get:function() {return this._binding_binder_ref;}});//バインド先のデバイス

Object.defineProperty(DeviceValBinder.prototype,'ui_show_type',{get:function() {return this._ui_show_type;}});//バインド先のデバイス

//バインド先のバインダーの値操作
Object.defineProperty(DeviceValBinder.prototype,'Par_Val',{
    get:function() {
        if(!this._binding_binder_ref){return undefined;}
        return this._binding_binder_ref._ValGettrCB();
    },
    set:function(val){
        if(!this._binding_binder_ref){return;}
        this._binding_binder_ref._ValSettrCB(val);
    }
});


/**
 * バインドを行う
 * @param DeviceValBinderIns DeviceValBinderインスタンス
 * @constructor
 */
DeviceValBinder.prototype.Binding=function(DeviceValBinderIns){
    if(!DeviceValBinderIns){
       // this.UnBinding();
        return false;
    }
    if(DeviceValBinderIns instanceof DeviceValBinder){
       //バインド可能か検証してバインド
       if(this.IsBindingTypeMatch(DeviceValBinderIns)){
           //既にバインドしている、バインド先は先に解除する
           if(this._binding_binder_ref){
               this._binding_binder_ref._UnBinding();
           }
            this._Binding(DeviceValBinderIns);
            //バインド先のバインドbinding_binder_refも自分に書き換える
            DeviceValBinderIns._Binding(this);
           return true;
       }else{
           return false;
       }
    }else{
        return false;
    }
};
/**
 * バインドを行う（バインド先型チェック無し 自動再バインド用）
 * @param DeviceValBinderIns DeviceValBinderインスタンス
 * @constructor
 */
DeviceValBinder.prototype.BindingNocheck=function(DeviceValBinderIns){
    if(!DeviceValBinderIns){
        // this.UnBinding();
        return false;
    }
    if(DeviceValBinderIns instanceof DeviceValBinder){
            //既にバインドしている、バインド先は先に解除する
            if(this._binding_binder_ref){
                this._binding_binder_ref._UnBinding();
            }
            this._Binding(DeviceValBinderIns);
            //バインド先のバインドbinding_binder_refも自分に書き換える
            DeviceValBinderIns._Binding(this);
            return true;
    }else{
        return false;
    }
};

DeviceValBinder.prototype._Binding=function(DeviceValBinderIns){
        this._binding_binder_device_innerid=DeviceValBinderIns._device_innerid;
        this._binding_binder_name=DeviceValBinderIns._binder_name;
        this._binding_binder_show_name=DeviceValBinderIns._binder_show_name;
        this._binding_binder_ref=DeviceValBinderIns;
        this.EventHandler.fire({type: this.EventHandlerType.OnBindChange, binder:this,binding_binder:DeviceValBinderIns});//バインド変更イベント
};


/**
 * バインド解除
 * @constructor
 */
DeviceValBinder.prototype.UnBinding=function(){
    if(this._binding_binder_ref instanceof DeviceValBinder){
        this._binding_binder_ref._UnBinding();
    }
    return this._UnBinding();
};
DeviceValBinder.prototype._UnBinding=function(){
    //var old_binding_binder_device_innerid=this._binding_binder_device_innerid;
    var old_binding_binder_ref=this._binding_binder_ref;
    this._binding_binder_device_innerid=undefined;
    this._binding_binder_name=undefined;
    this._binding_binder_show_name=undefined;
    this._binding_binder_ref=undefined;
    this.EventHandler.fire({type: this.EventHandlerType.OnBindChange, binder:this,un_binding_binder:old_binding_binder_ref});//バインド変更イベント
    return {binder:this,un_binding_binder:old_binding_binder_ref};
};

/**
 * 復帰時自動再バインド用
 * @constructor
 */
DeviceValBinder.prototype.ReBind=function(){
    var binding_binder_device_innerid=this._binding_binder_device_innerid;
    var binding_binder_name=this._binding_binder_name;

    if(!binding_binder_device_innerid || !binding_binder_name){return;}
    var is_bind_comp=false;//バインド先が存在してバインド出来たか
    for(var i=0;i<DeviceValBinder_Binder_AllList.length;i++){
        var tar=DeviceValBinder_Binder_AllList[i];
        if(tar._device_innerid===binding_binder_device_innerid && tar._binder_name===binding_binder_name)
        {
          //  this.Binding(tar);
            this.BindingNocheck(tar);
            is_bind_comp=true;
            UTL_LOG("バインド:"+ binding_binder_name+" UID:"+binding_binder_device_innerid);
        }
    }
    if(!is_bind_comp){
        UTL_LOG("バインド先が存在しない:"+ binding_binder_name+" UID:"+binding_binder_device_innerid);
    }
};

/**
 * DeviceValBinderInsが自身とバインド可能なタイプか検査する
 * @param DeviceValBinderIns 検査対象のバインダー
 * @returns {boolean}
 * @constructor
 */
DeviceValBinder.prototype.IsBindingTypeMatch=function(DeviceValBinderIns){
    if(!(DeviceValBinderIns instanceof DeviceValBinder)){return false;};

    //許可リストにある全てのタイプと合致するか
    var ch_from=this._allow_Comparator_default_mask(this._allow_Comparator) & this._allow_Comparator_default_mask(DeviceValBinderIns._type_list);
    var ch_to=this._allow_Comparator_default_mask(DeviceValBinderIns._allow_Comparator) & this._allow_Comparator_default_mask(this._type_list);

    var ch_from_dev=Boolean(ch_from & DeviceValBinder_TYPE_MASK_LIST.DEVICE_MASK)&& Boolean(ch_to & DeviceValBinder_TYPE_MASK_LIST.DEVICE_MASK);
    var ch_from_val=Boolean(ch_from & DeviceValBinder_TYPE_MASK_LIST.VAL_MASK)&& Boolean(ch_to & DeviceValBinder_TYPE_MASK_LIST.VAL_MASK);

    //データ方向(DeviceValBinder_DATA_FLOW_LIST)は DATA_FLOW_OUT<-->DATA_FLOW_IN  DATA_FLOW_GET<-->DATA_FLOW_PULL が互いに接続可能
    var ch_from_data=
        (this._dataflow_list & DeviceValBinder_DATA_FLOW_LIST.DATA_FLOW_OUT?(DeviceValBinderIns._dataflow_list & DeviceValBinder_DATA_FLOW_LIST.DATA_FLOW_IN):0)|
        (this._dataflow_list & DeviceValBinder_DATA_FLOW_LIST.DATA_FLOW_IN?(DeviceValBinderIns._dataflow_list & DeviceValBinder_DATA_FLOW_LIST.DATA_FLOW_OUT):0)|
        (this._dataflow_list & DeviceValBinder_DATA_FLOW_LIST.DATA_FLOW_GET?(DeviceValBinderIns._dataflow_list & DeviceValBinder_DATA_FLOW_LIST.DATA_FLOW_PULL):0)|
        (this._dataflow_list & DeviceValBinder_DATA_FLOW_LIST.DATA_FLOW_PULL?(DeviceValBinderIns._dataflow_list & DeviceValBinder_DATA_FLOW_LIST.DATA_FLOW_GET):0);


    return ch_from_dev && ch_from_val && Boolean(ch_from_data);
};
/**
 * バインダーのUPDATEイベント（モーター入れ替え時のイベント発生用）
 * @constructor
 */
DeviceValBinder.prototype.BindingUpdateNotify=function(){
    if(this._binding_binder_ref){
        this.EventHandler.fire({type: this.EventHandlerType.OnBindChange, binder:this,binding_binder: this._binding_binder_ref});//バインド変更イベント
        this._binding_binder_ref.EventHandler.fire({type: this._binding_binder_ref.EventHandlerType.OnBindChange, binder:this._binding_binder_ref,binding_binder: this._binding_binder_ref._binding_binder_ref});
    }
};
/**
 * DeviceValBinderInsとバインド可能な全ての公開バインダーのリストを列挙する
 * @param other_binding_get_flg 自分以外のオーナーがバインド済みのバインダーも取得するフラグ
 * @param RefineDevice :Device 指定時はこのデバイスに対してのバインダーのみに絞り込む
 * @constructor
 */

DeviceValBinder.prototype.GetCanBindingList=function(other_binding_get_flg,RefineDevice){
    //todo::RefineByBinder :DeviceValBinder指定時はこのデバイスに対してのバインダーのみに絞り込む
    var rs=[];
    var DeviceValBinderIns=this;
    var DVAll=DeviceValBinder_Binder_AllList;
    if(RefineDevice instanceof Object){
       var blist= RefineDevice.BinderList;
        var arr = Object.keys(blist).map(function (key) {return blist[key]});
        DVAll=arr;
    }
    for(var i=0;i<DVAll.length;i++){
        var ch_binder=DVAll[i];
        //適合する型のバインダーのみ列挙する。
        if(!DeviceValBinderIns.IsBindingTypeMatch(ch_binder)){continue;}
        //自分自身（同じデバイス内のバインダー）は除く。
        if(DeviceValBinderIns.owner===ch_binder.owner){
            continue;
        }
        //オプションが無い場合、自分以外のオーナーがバインド済みのバインダーは除く
        if(!other_binding_get_flg && ch_binder.is_bind && !DeviceValBinderIns.IsBindingTargetEq(ch_binder)){
            continue;
        }
        rs.push(ch_binder);

        //info::debug
        // if(!ch_binder.is_bind && ch_binder._binder_name=="Motor_X"){
        //     console.log("/////"+this._binder_name+" ＞ to:"+ch_binder._binder_name+" > "+DeviceValBinderIns.IsBindingTypeMatch(ch_binder)+"/////");
        //     console.log("this.allow_Comparator:"+this.allow_Comparator+"  this.type_list:"+this.type_list);
        //     console.log("ch_binder.allow_Comparator:"+ch_binder.allow_Comparator+"  ch_binder.type_list:"+ch_binder.type_list);
        //     console.log("//////////////////");
        // }
    }
    return rs;
};
/**
 * バインド先がDeviceValBinderInsと同じか? :Bool
 * 　UIでバインド済みの物にチェック付ける用
 * @param DeviceValBinderIns
 * @returns {boolean}
 * @constructor
 */
DeviceValBinder.prototype.IsBindingTargetEq=function(DeviceValBinderIns){
    if(this._binding_binder_ref==null||DeviceValBinderIns==null){return false;}
    return (this._binding_binder_ref==DeviceValBinderIns);
};

/**
 * オブジェクトの廃棄(実際に廃棄はしない(出来ない) リストからの削除と廃棄イベント発行を行う)
 * @constructor
 */
DeviceValBinder.prototype.Destory=function(){
    this.UnBinding();
    //バインダーの一覧リストから削除
    for(var i=0;i<DeviceValBinder_Binder_AllList.length;i++){
        if(DeviceValBinder_Binder_AllList[i]===this){
            console.log("DeviceValBinder Destory");
            console.dir(DeviceValBinder_Binder_AllList[i]);
            DeviceValBinder_Binder_AllList.splice(i,1);
        }
    }

    this.EventHandler.fire({type: this.EventHandlerType.OnDestory, binder:this});
}