/**
 * 制御デバイス生成コントローラー　　DeviceController　シングルトン
 *
 *●デバイスのライフサイクル　
 * ○BLEデバイス
 * ・起動時＞自動生成（全て復帰生成）
 * ・切断・ペアリング解除時 ＞ デバイス状態更新（OFFのまま残る）
 * ・再ペアリング時 ＞（OFF→ON）
 * ・新規検出 ＞ 自動生成
 * ○デバイス(ビルトイン 入力コントロール　モジュール等)
 * ・起動時＞自動生成（全て復帰生成）
 * ・ハード側で使用不可変更 ＞ デバイス状態更新（OFFのまま残る）
 *
 * ●注意
 * 　イベントなどで返されるBLEDeviceInfo（BLEデバイス情報）の値はReadOnry（内部制御使用）の為、書き換えない運用
 * ●イベント EventHandler
 *   OnCreateBLEDevice(uid,device,BLEDeviceInfo) //生成完了
 *   OnCreateBuiltinDevice(uid,device,device_type)
 *   OnStateLoadComp({StateLoadConunter})"//コントローラーの状態復帰が完了したかのカウント用
 *   OnStateSaveAtComp({uid,name})//別名保存完了
 *   OnDeleteStateIndexListAtComp({uid,name})//保存リストの削除完了
 *   OnStateLoadAtComp({uid,name})//保存リストからのロード完了
 *   OnDelete({device_uuid,device_name,device_type}) //削除完了
 *   OnInitComp({tar:this}) //初期化完了
 *   OnReplaceDeviceBLE({device_a,device_b})//BLE仮想デバイス同士でペアリングしているBLEデバイスを入れ替えた
 * ● メソッド
 *   ○ AddBLEDevice(BLEDeviceInfo) 同じBLEデバイス(デバイスUUIDが同じ)なら生成せず、接続状態を更新のみ
 *   ○ GetDevicelist 生成された全てのデバイスの情報リストを返す[GetBLEDevicelist,・]
 *   ○ GetBLEDevicelist 生成された全てのデバイスの中からBLEのみを集めたデバイスリスト[GetBLEDevicelist,・]
 *   ○ Controller_Get_state_info():{uid:name} コントローラーの保存名の情報取得
 * @constructor
 */

DeviceController=(function() {
    "use strict";
    /************************************************************************************
     *
     * プライベート領域
     *
     ************************************************************************************/

    //制御デバイスのインスタンスリスト DeviceList:Device{}
    var _class_root={};
    var _DeviceList = {};
    var _DeviceList_BLE={};//_DeviceListからBLEのみを集めたデバイスリスト

    var _ControllerStateLoadConunter=0;
    var _ControllerStateLoadConunterComp=0;
    var _state_info={uid:null,name:null};//コントローラの保存UID・保存名
    var _unload_cancel_flg=false;//保存データを呼び出し＞リスタート時に　unloadで保存されるのを防止
    /**
     * DeviceListの削除要請イベント
     * @param e
     * @private
     */
    var _DeviceListDestoryLisner=function(e){
        var device_p=e.device.PROP;
        if(device_p!==undefined){
            delete _DeviceList[device_p.UID];
            switch(device_p.device_type){
                //BLEのみ例外的に_DeviceList_BLEリストも削除
                case AbstractDeviceList_DeviceType.BLE:
                    delete _DeviceList_BLE[device_p.device_uuid];
                    break;
            }
            _class_root.EventHandler.fire({type: _class_root.EventHandlerType.OnDelete, device_uuid:device_p.device_uuid,device_name:device_p.device_name,device_type:device_p.device_type});
        }
    }

    /**
     * 全てのデータの状態復帰が完了したかのイベントカウント用（リセット）
     * @param CompCount　完了とするデータ復帰数
     * @private
     */
    var _ControllerStateLoadConunterReset=function(CompCount){
        _ControllerStateLoadConunter=0;
        _ControllerStateLoadConunterComp=CompCount?CompCount:0;
    }
    /**
     * コントローラーの状態復帰が完了したかのカウント用
     * @private
     */
    var _ControllerStateLoadConunterUP=function(){
        ++_ControllerStateLoadConunter;
        if(_ControllerStateLoadConunter >= _ControllerStateLoadConunterComp){
            var self=publicobj;
            self.EventHandler.fire({type: self.EventHandlerType.OnStateLoadComp, StateLoadConunter: _ControllerStateLoadConunter});
        }

    };


    /************************************************************************************
     *
     * パブリック領域
     *
     ************************************************************************************/
    var publicobj = {
        EventHandler:new EventTarget(),
        /**
         * イベントタイプ定数
         */
        EventHandlerType: {
            "OnCreateBLEDevice": "OnCreateBLEDevice",
            "OnReconnectBLEDevice": "OnReconnectBLEDevice",
            "OnCreateBuiltinDevice": "OnCreateBuiltinDevice",
            "OnStateLoadComp":"OnStateLoadComp",
            "OnStateSaveAtComp":"OnStateSaveAtComp",
            "OnDeleteStateIndexListAtComp":"OnDeleteStateIndexListAtComp",
            "OnStateLoadAtComp":"OnStateLoadAtComp",
            "OnDelete":"OnDelete",
            "OnInitComp":"OnInitComp",
            "OnReplaceDeviceBLE":"OnReplaceDeviceBLE"
        },
        /**
         * デバッグ用ローカル変数を取得する
         * @constructor
         */
        Debugref:function(){
            return {_DeviceList:_DeviceList,_DeviceList_BLE:_DeviceList_BLE};
        },
        /**
         * 付けようとするdevice_sub_nameがdevice_name内でユニークか判断する
         * info::アルゴリズム要改良(遅い)
         * @param device_name デバイス名
         * @param sub_name 付けようとするサブ名
         * @constructor
         */
        IsUniqueSubName:function(device_name,sub_name){
         var k= Object.keys(_DeviceList);
            for(var i=0;i<k.length;i++){
                // if(k[i].device_name===device_name){//info::getterのコスト高い
                //     if(k[i].device_sub_name===sub_name){
                //         return false;
                //     }
                // }

                if(_DeviceList[k[i]].PROP.device_name===device_name){
                    if(_DeviceList[k[i]].PROP.device_sub_name===sub_name){
                        return false;
                    }
                }
            }
            return true;
        },
        /**
         * 生成された全てのデバイスの情報リストを返す
         * @returns :DeviceList{}
         */
        GetDevicelist: function () {
            var r=[];
            var k=Object.keys(_DeviceList);
            for(var i=0;i<k.length;i++){
                r.push(_DeviceList[k[i]]);
            }
            return r;
        },
        /**
         * 生成された全てのデバイスの中からBLEのみを集めたデバイスリスト
         * @returns :DeviceList_BLE{}
         */
        GetBLEDevicelist: function () {
            var r=[];
            var k=Object.keys(_DeviceList_BLE);
            for(var i=0;i<k.length;i++){
                r.push(_DeviceList_BLE[k[i]]);
            }
            return r;
        },
        /**
         * コンストラクタ（初期化メソッド）
         * リストを初期化
         * @constructor
         */
        init: function () {
            var self = this;
            //ページ遷移(UI切り替え)時の保全処理
            window.addEventListener("unload", function __EVunload() {
                UTL_LOG("unload");
                if(!_unload_cancel_flg){//保存データを呼び出し時にバイパス用
                    self.Controller_state_save();
                }
            }, false);
            ///初回処理
            _class_root=self;
            _DeviceList={};
            _DeviceList_BLE={};
            self.Controller_state_load();
            //info::バインダーの再バインド処理
            DeviceValBinder_AllReBind();
            self.EventHandler.fire({type: self.EventHandlerType.OnInitComp, tar: self});
        },

        /**
         * コントローラーの保存名の情報取得
         * @constructor
         */
        Controller_Get_state_info:function(){
            return {uid:_state_info.uid,name:_state_info.name};
        },
        /**
         * 保存リストのインデックス
         * @returns {*}
         * @constructor
         */
        Controller_Get_state_index_list:function(){
            var save_list_index = UTL_load_storage("ROBO_INDEX");
            if(!(save_list_index instanceof Array)){
                save_list_index=[];
            }
            return save_list_index;
        },
        /**
         * 保存リストの削除
         * @param uid 削除するUID
         * @constructor
         */
        Controller_Delete_state_index_list_at:function(delete_uid){
            var save_list_index = this.Controller_Get_state_index_list();
            var delete_tar=null;
            for(var i=0;i<save_list_index.length;i++){
                if(delete_uid===save_list_index[i].uid){
                    delete_tar=save_list_index[i];
                    save_list_index.splice(i,1);
                    break;
                }
            };
            if(delete_tar){
                UTL_remove_storage("ROBO_"+delete_tar.uid);
            }
            UTL_save_storage("ROBO_INDEX",save_list_index);
            this.EventHandler.fire({type:this.EventHandlerType.OnDeleteStateIndexListAtComp,uid:delete_tar.uid,name:delete_tar.name});
        },

        /**
         * コントローラーの別名保存（デバイス編集の保存用）
         * @param name 上書き時は指定のある場合のみ名称を変更
         * @param is_over_wait 上書き:true 新規保存:false
         * @constructor
         */
        Controller_state_save_at:function(_name,is_over_wait){
            //保存リストのインデックスを取得 save_list_index[{uid:保存ユニークID名,name:保存名},,]
            var save_list_index = this.Controller_Get_state_index_list();
            //上書き・新規保存の分岐
            var save_uid=null;
            var save_name=null;
            if(is_over_wait){
                save_uid=_state_info.uid?_state_info.uid:UTL_Unique_uuid();
                save_name=_name?_name:_state_info.name?_state_info.name:"New_"+UTL_Unique_uuid();//nameの指定時は名称を変更
            }else{
                save_uid=UTL_Unique_uuid();
                save_name=_name?_name:"New_"+UTL_Unique_uuid();
            }
            //保存リストのインデックスの更新
            //既存のUIDを検索。無い場合は先頭に生成・追加
            var ch=false;
            for(var i=0;i<save_list_index.length;i++){
                if(save_uid===save_list_index[i].uid){
                    save_list_index[i].name=save_name;//名前の変更
                    save_list_index[i].date=UTL_NowDateTime();//時刻の更新
                    ch=true;
                    break;
                }
            };
            if(!ch){
                save_list_index.unshift({uid:save_uid,name:save_name,date:UTL_NowDateTime()});
            }
            UTL_save_storage("ROBO_INDEX",save_list_index);

            //コントローラーの状態を取得＞保存
            var s_data=[];
            Object.keys(_DeviceList).forEach(function (idx){
                if(_DeviceList[idx]!==undefined){
                    s_data.push( _DeviceList[idx].GetDeviceStateVals());
                }
            });
            UTL_save_storage("ROBO_"+save_uid,{DLIST:s_data});
            _state_info.uid=save_uid;
            _state_info.name=save_name;

            this.Controller_state_save();

            this.EventHandler.fire({type:this.EventHandlerType.OnStateSaveAtComp,uid:save_uid,name:save_name});
        },

        /**
         * コントローラーの状態保存（内部用）
         * @private
         */
        Controller_state_save:function(){
            //コントローラーの状態の保存
            var s_data=[];
            if(!Object.keys(_DeviceList).length){return;}//データ破損時の自動保存回避

            Object.keys(_DeviceList).forEach(function (idx){
                if(_DeviceList[idx]!==undefined){
                    s_data.push( _DeviceList[idx].GetDeviceStateVals());
                }
            });
            UTL_save_storage("DeviceController",{DLIST:s_data,uid:_state_info.uid,name:_state_info.name});
        },
        /**
         * コントローラーの状態復帰（内部用）
         * @constructor
         */
        Controller_state_load:function(){
            //todo::問題 BLEデバイスで過去に接続された古い接続の存在しないBLEデバイスが残る(BLEデバイスでデバイスUUIDが違う場合残る）
            var self = this;
            //コントローラーの状態復帰
            var SDATA = UTL_load_storage("DeviceController");
            if(!(SDATA instanceof Object)){return;}
            _state_info.uid=SDATA.uid;
            _state_info.name=SDATA.name;
            var DLIST = SDATA.DLIST;
            if(DLIST instanceof Array){
                //deviceのクラス再生成
                _DeviceList = {};
                _DeviceList_BLE={};

                _ControllerStateLoadConunterReset(DLIST.length);
                for(var i=0 ;i<DLIST.length;i++){
                    var data= DLIST[i];
                    AbstractDeviceList.CreateDeviceForSearch(data.device_name,data
                        ,function __CreateDeviceForSearch_success(_new_absdev){
                            _new_absdev.EventHandler.addListener(_new_absdev.EventHandlerType.OnDestory,_DeviceListDestoryLisner); //削除イベント
                            _DeviceList[_new_absdev.UID]=_new_absdev;
                            //デバイスのタイプ別処理
                            switch(_new_absdev.device_type){
                                case AbstractDeviceList_DeviceType.BLE://BLEデバイスのみ専用リストに登録
                                    _DeviceList_BLE[_new_absdev.device_uuid]=_new_absdev;
                                    break;
                            }
                            _ControllerStateLoadConunterUP();
                        }.bind(self)
                        ,function __CreateDeviceForSearch_failure(_device_name){
                            UTL_LOG("ERR:_Controller_state_load 生成するデバイスが見つからない:"+_device_name);
                            _ControllerStateLoadConunterUP();
                        }
                    );
                }
            }
        },

        /**
         * 指定したデータからコントローラーの状態復帰（デバイス編集のリスト選択）
         * @param load_uid
         * @constructor
         */
        Controller_state_load_at:function(load_uid){
            //指定したuidがあるか検索
            var save_list_index = this.Controller_Get_state_index_list();
            var tar=null;
            for(var i=0;i<save_list_index.length;i++){
                if(load_uid===save_list_index[i].uid){
                    tar=save_list_index[i];
                    break;
                }
            };
            //データがある場合はメインに保存してリスタート
            //info::iosはアプリの再起動は出来ない
            if(tar){
               var data= UTL_load_storage("ROBO_"+tar.uid);
                UTL_save_storage("DeviceController",{DLIST:data.DLIST,uid:tar.uid,name:tar.name});
                _unload_cancel_flg=true;
                //info::この時点でアンロード時のデータは自動保存されない。
                //info::BLEのペアリングを解除し、アプリを再起動（読み直し）する必要がある。
                this.EventHandler.fire({type:this.EventHandlerType.OnStateLoadAtComp,uid:null,name:null});
            }else{
                //新規作成
                UTL_save_storage("DeviceController",{DLIST:[],uid:UTL_Unique_uuid(),name:"New_"+UTL_Unique_uuid()});
                _unload_cancel_flg=true;
                //info::この時点でアンロード時のデータは自動保存されない。
                //info::BLEのペアリングを解除し、アプリを再起動（読み直し）する必要がある。
                this.EventHandler.fire({type:this.EventHandlerType.OnStateLoadAtComp,uid:null,name:null});
            }

        },
        /**
         * 指定したデータのエクスポート（データ交換用）
         * @param export_uid
         * @constructor
         */
        Controller_state_export_json_at:function(export_uid){
            //指定したuidがあるか検索
            var save_list_index = this.Controller_Get_state_index_list();
            var tar=null;
            for(var i=0;i<save_list_index.length;i++){
                if(export_uid===save_list_index[i].uid){
                    tar=save_list_index[i];
                    break;
                }
            };
            //データがある場合はJSONに変換して出力
            var data= UTL_load_storage("ROBO_"+tar.uid);
            var exp_data={DLIST:data.DLIST,DATA_VAR:ROBO_DATA_VAR,uid:tar.uid,name:tar.name};

            return JSON.stringify(exp_data);
        },
        
        /**
         * 外部データのインポート
         * todo::インジェクション攻撃へのサニタイズ
         * @param state_d 読み込むデバイスリストのオブジェクト 「JSON.parse(Controller_state_export_json_at)と同じ構造」
         * @constructor
         */
        Controller_state_data_inport:function(state_d){
            //保存リストのインデックスを取得 save_list_index[{uid:保存ユニークID名,name:保存名},,]
            var save_list_index = this.Controller_Get_state_index_list();

            var save_uid=UTL_Unique_uuid();
            var save_name=state_d.name?state_d.name:"New_"+UTL_Unique_uuid();
            
            //保存リストのインデックスの更新
            save_list_index.unshift({uid:save_uid,name:save_name,date:UTL_NowDateTime()});
            UTL_save_storage("ROBO_INDEX",save_list_index);
            //デバイスデータの保存
            UTL_save_storage("ROBO_"+save_uid,{DLIST:state_d.DLIST});

            this.EventHandler.fire({type:this.EventHandlerType.OnStateSaveAtComp,uid:save_uid,name:save_name});
        },
        /**
         * BLEデバイスの全消去
         * @constructor
         */
        Controller_state_Clear_BLE:function(){
            //BLEデバイスのみデバイスUUIDから検索して削除
            Object.keys(_DeviceList_BLE).forEach(function (idx) {
                var BLEDevice=_DeviceList_BLE[idx];
                BLEDevice.Destory();
            });
            this.Controller_state_save();
        },

        /**
         * 特定のDeviceTypeに該当するデバイスの全消去
         * @param DeviceType 省略時は全て消去
         * @constructor
         */
        Controller_state_Clear_DeviceType:function(DeviceType){
            if(DeviceType){
                Object.keys(_DeviceList).forEach(function (idx) {
                    var dls=_DeviceList[idx];
                   if( dls.device_type==DeviceType){
                       delete _DeviceList[idx];
                       dls.Destory();
                   }
                });
            }else{
                Object.keys(_DeviceList).forEach(function (idx) {
                    var dls=_DeviceList[idx];
                    delete _DeviceList[idx];
                    dls.Destory();
                });
            }
            this.Controller_state_save();
        },

        /**
         * BLEデバイスの状態を更新する
         * ペアリングコントローラーで認識されているBLEデバイスの状態を反映する。
         * アップデート後にステータス更新
         * @param DeviceInfo
         * @constructor
         */
        CheckBLEDeviceStateUpdate:function(BLEDeviceInfo){
            //todo::BLEDeviceInfoが古いデバイスで存在しない(false)の場合の処理
           // var self = this;
            var BLEdevice=_DeviceList_BLE[BLEDeviceInfo.device_uuid];
            if(BLEdevice){
                BLEdevice.status=BLEDeviceInfo.is_pairing;
                // KM-1のLEDモジュールの色をDeviceInfolistに反映する
                if(BLEDeviceInfo.device_name.split('#').length==2){
                    BLEDeviceInfo.LedStateColor=URL_ConvartRGBArrayFromRGBCode(BLEDeviceInfo.device_name.split('#')[1]);
                }
                if('LedStateColor' in BLEdevice){
                    BLEDeviceInfo.LedStateColor=[BLEdevice.LedStateColor.ColorR,BLEdevice.LedStateColor.ColorG,BLEdevice.LedStateColor.ColorB];
                }
                //ファームversionの反映 KMのみ
                if( BLEdevice.device_name==="ble_KeiganMotor"){//BLEdevice.ble_firmware_revision
                    KMFarmVersionChecker.setCurrentFarmVersion(BLEDeviceInfo.device_uuid,"KM-1",UTL_N(BLEdevice.ble_firmware_revision));
                }
            }
        },
        CheckBLEDeviceStateAllUpdate:function(DeviceInfolist){
            for(var i=0;i<DeviceInfolist.length;i++){
                this.CheckBLEDeviceStateUpdate(DeviceInfolist[i]);
            }
        },

        /**
         * 該当するdevice_uuidのBLEデバイスの削除
         * @param BLEDeviceInfo
         * @constructor
         */
        RemoveBLEDevice:function(BLEDeviceInfo){
            var BLEDevice=_DeviceList_BLE[BLEDeviceInfo.device_uuid];
            if(BLEDevice){
                BLEDevice.Destory();
            }
        },

        /**
         * device_nameから該当するBLE抽象化Classを検索し パッケージから生成（BLE用）
         * @param BLEDeviceInfo  info::同じBLEデバイス(デバイスUUIDが同じ)なら生成せず、接続状態を更新のみ
         * @constructor
         */
        AddBLEDevice:function(BLEDeviceInfo){
            var self = this;
            var device_uuid=BLEDeviceInfo.device_uuid;
            if(device_uuid){
                //info::既に存在するBLEデバイスなら生成せず、接続状態を更新のみ
                if(_DeviceList_BLE[device_uuid]!==undefined){
                    self.EventHandler.fire({type: self.EventHandlerType.OnReconnectBLEDevice,device:_DeviceList_BLE[device_uuid],BLEDeviceInfo:BLEDeviceInfo});
                    return;
                };
                //BLEデバイス仮想デバイスを検索し、生成
                AbstractDeviceList.CreateDeviceForSearchBLE(BLEDeviceInfo
                    ,function __CreateDeviceForSearch_success(_new_absdev){
                        //削除イベント
                        _new_absdev.EventHandler.addListener(_new_absdev.EventHandlerType.OnDestory,_DeviceListDestoryLisner);

                        _DeviceList[_new_absdev.PROP.UID]=_new_absdev;
                        _DeviceList_BLE[device_uuid]=_new_absdev;
                        self.EventHandler.fire({type: self.EventHandlerType.OnCreateBLEDevice,device:_new_absdev,BLEDeviceInfo:BLEDeviceInfo});

                    }.bind(self)
                    ,function __CreateDeviceForSearch_failure(_device_name){
                        UTL_LOG("ERR:AddBLEDevice 生成するBLEデバイスが見つからない:"+_device_name);
                    }
                );
            }
        },
        /**
         * device_nameから該当する抽象化Classを検索し パッケージから生成（ビルトイン用）
         * @param device_name
         * @param option　初期化時に渡す引数 obj
         * @constructor
         */
        AddDevice:function(device_name,option){
            var self = this;
                AbstractDeviceList.CreateDeviceForSearch(device_name,option
                    ,function __CreateDeviceForSearch_success(_new_absdev){
                        //重複したビルトインデバイスは生成しない
                        //info::問題 同じデバイス名は2つ生成出来ない（カメラが2台ある場合とかは"builtin_cam2"とかで有限数のデバイスを作成する仕様にする）　
                        //
                        //for(var idx in _DeviceList_Builtin){
                        //    if(_DeviceList_Builtin[idx].PROP["device_name"]===_new_absdev.PROP["device_name"]){
                        //        return;
                        //    }
                        //}

                        _new_absdev.EventHandler.addListener(_new_absdev.EventHandlerType.OnDestory,_DeviceListDestoryLisner); //削除イベント

                        _DeviceList[_new_absdev.PROP.UID]=_new_absdev;
                        self.EventHandler.fire({type: self.EventHandlerType.OnCreateBuiltinDevice,device:_new_absdev});

                    }.bind(self)
                    ,function __CreateDeviceForSearch_failure(_device_name){
                        UTL_LOG("ERR:AddDevice 生成するデバイスが見つからない:"+_device_name);
                    }
                );
        }
        /**
         * 特定のデバイスを削除
         * @param device
         * @constructor
         */
        ,RemoveDevice:function(device){
            Object.keys(_DeviceList).forEach(function (idx) {
                var dls=_DeviceList[idx];
                if( dls==device){
                    dls.Destory();
                }
            });
        }
        
        /**
         * BLE仮想デバイス同士でペアリングしているKeiganMotorを入れ替える（KeiganMotor用）
         * @param device_a　対象となる仮想デバイス(_AbstractDevice_Keigan_Motor)
         * @param device_b　対象となる仮想デバイス(_AbstractDevice_Keigan_Motor)
         * @constructor
         */
       ,ReplaceDeviceBLEDeviceKeiganMotor: function(device_a,device_b){
            if(!device_a||!device_b){return;}
            //------------------------//
            // 全てのKeiganモーター共通の項目
            //------------------------//
            //BLEデバイスUUIDの入れ替え
            var device_uuid_a=device_a.device_uuid;
            var device_uuid_b=device_b.device_uuid;
            device_a.PROP.device_uuid=device_uuid_b;
            device_b.PROP.device_uuid=device_uuid_a;
            //BLEデバイス名の入れ替え
            var ble_device_name_a=device_a.ble_device_name;
            var ble_device_name_b=device_b.ble_device_name;
            device_a.PROP.ble_device_name=ble_device_name_b;
            device_b.PROP.ble_device_name=ble_device_name_a;

            //statusの入れ替え
            var ast=device_a._status;
            device_a._status=device_b._status;
            device_b._status=ast;

            //todo::debug 再バインドのイベントを発生
           var akey=Object.keys(device_a.BinderList);
            for(var i=0;i<akey.length;i++){
                device_a.BinderList[akey[i]].BindingUpdateNotify();
            }
            var bkey=Object.keys(device_a.BinderList);
            for(var i=0;i<bkey.length;i++){
                device_b.BinderList[akey[i]].BindingUpdateNotify();
            }
            //------------------------//
            // モーターシリーズ毎に存在有無のある項目
            //------------------------//
            //モーターのLED色を入れ替え
            if(('LedStateColor' in device_a)&&('LedStateColor' in device_b)) {
                var aled = device_a.LedStateColor;
                device_a.LedStateColor = device_b.LedStateColor;
                device_b.LedStateColor = aled;
            }


            //リストの更新
            _DeviceList_BLE[device_uuid_a]=device_b;
            _DeviceList_BLE[device_uuid_b]=device_a;

            //仮想デバイスの値とモーターの値を同期させる
            device_a.bleMotorRefresh();
            device_b.bleMotorRefresh();

            
            this.EventHandler.fire({type: this.EventHandlerType.OnReplaceDeviceBLE,device_a:device_a,device_b:device_b});
        }
        ///
    };


    ////
    return publicobj;
}());