/**
 * ペアリングコントローラー シングルトン
 * @constructor
 *
 *
 * ●注意
 * 　イベントなどで返されるBLEDeviceInfo（BLEデバイス情報）の値はReadOnry（内部制御使用）の為、書き換えない運用 info::led色の通知で書き換えている
 *
 * ●イベント EventHandler
 * OnInitComp({tar:this})//初期化完了
 * OnPairingComp({BLEDeviceInfo:BLEDeviceInfo})　//ペアリング完了※
 * OnDisconPairingComp({BLEDeviceInfo:BLEDeviceInfo}) //ペアリング解除完了※
 * OnConnectMissing({BLEDeviceInfo:BLEDeviceInfo})　//接続を開始しようとして失敗した
 * OnConnectionLoss({BLEDeviceInfo:BLEDeviceInfo})　//接続中に接続が切れた
 * OnPairingAutoCance({BLEDeviceInfo:BLEDeviceInfo}) //デバイスが存在しない為、自動でコントローラーからペアリングを解除された（アプリが落ちた、ペリフェラルが完全に落ちた場合）
 * OnDiscovery({BLEDeviceInfo:BLEDeviceInfo}) //デバイスを発見　個々に発火
 * OnScanStateChange({isScanNing:isScanNing}) //スキャン状態
 * OnBLEChange({BLEisEnabled:BLEisEnabled}) //BLEの有効無効が切り替わった
 * OnClearDeviceComp({tar:this})//リストのクリアー
 *
 * ●ペアリングフロー
 * 1)BLEPairingController.SearchDevice(is_KMonry)でBLEデバイスをsearch is_KMonry:bool スキャン時にKEigan Motorのみ表示
 * 2)BLEPairingController.GetDeviceInfolist()でsearchしたデバイスのリストを取得> DeviceInfolist:DeviceInfo[]
 * 3)BLEPairingController.PairingDevice(DeviceInfo) で新規接続
 * 3-2)切断は BLEPairingController.DisconPairingDevice(DeviceInfo)
 *
 * その機器がペアリング中かの判断　DeviceInfo.is_pairing に格納
 * 全てのペアリングを切断し初期化　BLEPairingController.ClearDevice()
 * スマホのBLEの有効検出　BLEPairingController.GetBLEisEnabled()
 * デバイス情報からGATTを取得  BLEPairingController.GetGATTProfile(BLEDeviceInfo) （但し、一度でもペアリングしたデバイスでないと取得出来ない）
 */

BLEPairingController=(function(){

    /************************************************************************************
     *
     * プライベート領域
     *
     ************************************************************************************/

    var _isScanNing = false;
    var _BLEisEnabled = false;
    var _DeviceInfolist = [];
    var _GATTProfiles={};
    var _StopSearchDeviceTimeoutID = 0;
    var _PreviewSearchDeviceflg_is_KMonry=false;//前回のSearchDevice検索時の引数(is_KMonry)の値
    /**
     * 接続後にAPIから受信したGATTプロファイルのオブジェクト化
     * 現状はAPIから返されるデータをそのまま使用
     * @param BLEApiRawPeripheralObj
     * @private
     */
    var _CreateGATTobj= function (BLEApiRawPeripheralObj) {
        //Advertising Dataからのservice_uuidの取得処理
        //if(obj["advertising"]!==undefined){
        //    //iosのみadvertisingデータはキー付きのdictionaryで返される。AndroidはArrayBuffer
        //    BLEDeviceInfo.service_uuid=(obj.advertising["kCBAdvDataServiceUUIDs"] instanceof Array)?obj.advertising["kCBAdvDataServiceUUIDs"].concat():[];
        //    BLEDeviceInfo.local_name=obj.advertising["kCBAdvDataLocalName"]!==undefined?obj.advertising["kCBAdvDataLocalName"]:"";
        //}

        var self = publicobj;
        //TODO::必要なら使いやすい構造に加工＆メソッドを追加（現状はAPIから返されるデータをそのまま使用）
        var GATTobj=BLEApiRawPeripheralObj ? BLEApiRawPeripheralObj : {};
        return GATTobj;
    }
    /**
     * コントローラーの状態保存・復帰
     * @private
     */
   var _Controller_state_save=function(){
        UTL_save_storage("BLEPairingController",{DINFO:_DeviceInfolist,GATT:_GATTProfiles});
    };
   var _Controller_state_load=function(){
        var SDATA = UTL_load_storage("BLEPairingController");
        if(SDATA instanceof Object){
            _DeviceInfolist = (SDATA.DINFO instanceof Array) ? SDATA.DINFO : [];
            _GATTProfiles =  (SDATA.GATT instanceof Object) ? SDATA.GATT : {};
        }
    };

    /**
     * DeviceIDから該当するデバイスのリストを検索＞参照を返す
     * @param BLEDeviceInfo
     * @private
     */
    var _SearchDeviceInfolistFromDeviceID_ref=function (DeviceUUID) {
        var self = publicobj;
        for (var i = 0; i < _DeviceInfolist.length; i++) {
            if (_DeviceInfolist[i].device_uuid == DeviceUUID) {
                return _DeviceInfolist[i];
            }
        }
        return false;
    };

    /************************************************************************************
     *
     * パブリック領域
     *
     ************************************************************************************/

    var publicobj = {
        EventHandler :new EventTarget(),

        /**
         * イベントタイプ定数
         */
        
        EventHandlerType: {
            "OnInitComp":"OnInitComp",
            "OnPairingComp": "OnPairingComp",
            "OnDisconPairingComp":"OnDisconPairingComp",
            "OnConnectMissing": "OnConnectMissing",
            "OnConnectionLoss":"OnConnectionLoss",
            "OnPairingAutoCance":"OnPairingAutoCance",
            "OnDiscovery": "OnDiscovery",
            "OnBLEChange": "OnBLEChange",
            "OnScanStateChange": "OnScanStateChange",
            "OnClearDeviceComp":"OnClearDeviceComp"
        },
        ReTryAutoScanCount:5,//接続失敗時に何回失敗でオートスキャンするか
        SearchDeviceContinuousTime:3,//スキャンするデフォルトの継続時間(sec)
        DeviceRegularCheckInterval:2,//ペリフェラルの死活監視する間隔(sec)
        KeiganMotorServiceUUID:['f140ea35-8936-4d35-a0ed-dfcd795baa8c'],//info::Keigan Motor検索のみのService UUID
        /**
         * BLEデバイスの情報生成
         * @param Device
         * @private
         *
         */
        CreateBLEDeviceInfo:function(BLEApiRawObj){
            var _BLEApiRawObj = typeof(BLEApiRawObj) == "object" ? BLEApiRawObj : {};
            var _BLEDeviceInfo = new ST_BLEDeviceInfo(_BLEApiRawObj);
            //_BLEDeviceInfo.device_name=_BLEDeviceInfo.device_name+BLEApiRawObj["id"].substring(0,4)+"#F"+String(Math.floor(Math.random()*10))+String(Math.floor(Math.random()*10));//todo::info::for debug
            return _BLEDeviceInfo;
        },

         /**
         * コンストラクタ（初期化メソッド）
         * @constructor
         */
        init: function () {
            var self = this;
           // self.EventHandler = new EventTarget();

            //BLEデバイスの接続状態取得
            ble.isEnabled(function () {
                _BLEisEnabled = true;
                self.EventHandler.fire({type: self.EventHandlerType.OnBLEChange, BLEisEnabled: _BLEisEnabled});
            });


            //バックグランド・復帰時の処理
            document.addEventListener("pause", function __EVpause(){
                UTL_LOG("pause");
               // _Controller_state_save();//todo::通常はUIの画面切り替え時に保存する為不要
            }, false);

            document.addEventListener("resume", function ___EVresume(){
                setTimeout(function() {
                    UTL_LOG("resume");
                   // self.SearchDevice(_PreviewSearchDeviceflg_is_KMonry);
                    //_Controller_state_load();
                }, 0);
            }, false);

            //ページ遷移(UI切り替え)時の保全処理
            //info::DOMイベントにバインドしている node.js等では使用出来ない
            window.addEventListener("unload", function __EVunload() {
                UTL_LOG("unload");
               _Controller_state_save();
            }, false);

            ///初回処理
            _Controller_state_load();
            self.EventHandler.fire({type: self.EventHandlerType.OnInitComp, tar: self});
        },


    /**
     * スキャン状態
     * @returns {boolean}
     * @constructor
     */
    GetScanState: function () {
        return _isScanNing;
    },
    /**
     * 検出された全てのデバイスの情報リストを返す
     * @returns :BLEDeviceInfo[]
     */
    GetDeviceInfolist: function () {
        return _DeviceInfolist;
    },
    GetDeviceInfo: function (device_uuid) {
        for(var i=0;i<_DeviceInfolist.length;i++){
            if(_DeviceInfolist[i].device_uuid==device_uuid){
                return _DeviceInfolist[i];
            }
        }
       return false;
    },

    /**
     * デバイス情報からGATTを取得（但し、一度でもペアリングしたデバイスでないと取得出来ない）
     * @param BLEDeviceInfo
     * @returns {*}　GATTobj
     * @private
     */
    GetGATTProfile:function(BLEDeviceInfo){
        var self = this;
        return _GATTProfiles[BLEDeviceInfo.device_uuid];
    },
    /**
     * BLEの有効・無効状態取得
     * @returns {boolean|*}
     */
    GetBLEisEnabled: function () {
        var self = this;
        return _BLEisEnabled;
    },

    /**
     * 全てを切断しリストを初期化
     */
    ClearDevice: function () {
        var self = this;
        //切断処理
        for (var i = 0; i < _DeviceInfolist.length; i++) {
            self.DisconPairingDevice(_DeviceInfolist[i]);
        }
        _DeviceInfolist = [];
        _GATTProfiles={};
        _Controller_state_save();
        self.EventHandler.fire({type: self.EventHandlerType.OnClearDeviceComp, tar: self});
    },

    /**
     * PairingDevicesへリストアップ& is_existingをtrueにする
     * @param is_KMonry スキャン時にKEigan Motorのみ表示
     *
     * 検出済みのDeviceIDの存在を再確認　スキャン後存在しない物はis_existingをfalseに
     */
    SearchDevice: function (is_KMonry) {
        _PreviewSearchDeviceflg_is_KMonry=is_KMonry;
        var self = this;
        var StopTimeSec =  self.SearchDeviceContinuousTime;
        if (_isScanNing) {
            return;
        }
        
        //デバイスの存在確認用マーカー初期化
        for (var i = 0; i < _DeviceInfolist.length; i++) {
            _DeviceInfolist[i]._exisScan=true;
        }

        //発見した物と検出済みのDeviceIDが同じ物はデバイスの存在を有りに。無い物は新規追加
        //todo::一旦ペアリング済みの物が__startScansuccessが発生しない。ペアリング済みの物は ble.isConnectedでチェックする必要がある
        _isScanNing = true;
        UTL_LOG("Start SearchDevice");
        //ペアリング済みの物は ble.isConnectedでチェック（一旦ペアリング済みの物はble.startScanで検出出来ない為）
        for (var i = 0; i < _DeviceInfolist.length; i++) {
            var devinfo = _DeviceInfolist[i];
            if(devinfo.is_pairing) {
                //info::forループの中で外部処理系からのコールバックが発生する場合は、コールバック中にループ変数が変化するので、クロージャーで行う
                (function (devinfo, self) {
                    ble.isConnected(devinfo.device_uuid
                        , function __isConnectedSuccess() {
                            //存在あり
                            devinfo._exisScan=false;
                        }
                        , function __isConnectedFailure() {
                            //存在無し
                        }
                    );
                }(devinfo, self));
            }
        }

        //ペアリング済み以外の物の検索
        //ble.startScanWithOptions([], {reportDuplicates:false},function __startScansuccess(device) { //info::ペアリングした物は重複検出でも検出されない（バグ？）
        var services=is_KMonry?self.KeiganMotorServiceUUID:[];//info::Keigan Motor Service UUID

        ble.startScan(services, function __startScansuccess(device) {
            var devinfo;
            for (var i = 0; i < _DeviceInfolist.length; i++) {
                devinfo = _DeviceInfolist[i];
                if (devinfo.device_uuid == device["id"]) {
                    devinfo._exisScan=false;
                    //デバイスの存在を再確認した物は発見イベント発行
                    if (!devinfo.is_existing) {
                        devinfo.is_existing = true;
                        self.EventHandler.fire({type: self.EventHandlerType.OnDiscovery, BLEDeviceInfo: devinfo});
                    }
                    return;
                }
            }
            //無い物は新規追加
            devinfo = self.CreateBLEDeviceInfo(device);
            _DeviceInfolist.push(devinfo);
            self.EventHandler.fire({type: self.EventHandlerType.OnDiscovery, BLEDeviceInfo: devinfo});

        }, function __startScanfailure() {
            //スキャンエラー
            UTL_LOG("SearchDevice Error");
            self.StopSearchDevice();
        });

        //StopTimeSec秒後に検索停止
        clearTimeout(_StopSearchDeviceTimeoutID);
        _StopSearchDeviceTimeoutID = setTimeout(function () {
            self.StopSearchDevice();
           // UTL_LOG(_DeviceInfolist);
        }, StopTimeSec * 1000);

        self.EventHandler.fire({type: self.EventHandlerType.OnScanStateChange, isScanNing: _isScanNing});

    },

    /**
     * 検索停止　スキャン後存在しない物はis_existingをfalseに
     * @constructor
     */
    StopSearchDevice: function () {
        var self = this;
        clearTimeout(_StopSearchDeviceTimeoutID);

        if (_isScanNing) {
            UTL_LOG("Stop SearchDevice");
            _isScanNing = false;
            ble.stopScan();

            //デバイスの存在確認処理
            for (var i = 0; i < _DeviceInfolist.length; i++) {
                var dv=_DeviceInfolist[i];
                dv.is_existing=(!dv._exisScan);
                //todo::一旦ペアリング済みの物が__startScansuccessが発生しない為dv._exisScanはtrueのまま、存在しない事になってしまう。
                //todo::ペアリング済みの物は ble.isConnectedでチェックする必要がある
                dv._exisScan=false;
            }

            self.EventHandler.fire({type: self.EventHandlerType.OnScanStateChange, isScanNing: _isScanNing});
        }
    },

    /**
     * 接続
     * info:: Androidではble.connectの完了前にble.connectを重複発行するとプラグイン内でスレッドが重複してble.disconnectでも切断出来ない問題がある為、ble.isConnectedでチェックしてから各種処理を行う
     * @param BLEDeviceInfo
     */
    PairingDevice: function (BLEDeviceInfo) {
        var self = this;
        if (!BLEDeviceInfo) {
            return;
        }
        var devinfo = _SearchDeviceInfolistFromDeviceID_ref(BLEDeviceInfo["device_uuid"]);
        if (!devinfo) {
            return;
        }
        if (devinfo["is_pairing"]||devinfo["_connectTry"]) {
            return;
        }
        //info::重複接続の回避
        devinfo["_connectTry"]=true;
        ble.isConnected(BLEDeviceInfo["device_uuid"],
            function(){
                devinfo["_connectTry"]=false;
            },
            function(){
                ble.connect(BLEDeviceInfo["device_uuid"]
                    ,function __connectsuccess(peripheral) {
                        //接続成功　UTL_LOG("PairingDevice 接続成功");
                        devinfo["_connectTry"]=false;
                        devinfo["is_pairing"] = true;
                        _GATTProfiles[devinfo.device_uuid]=_CreateGATTobj(peripheral);//GATTプロファイルは接続後に取得可能
                        self.EventHandler.fire({type: self.EventHandlerType.OnPairingComp, BLEDeviceInfo: devinfo});
                    }
                    ,function __connectfailure() {
                        devinfo["_connectTry"]=false;
                        //接続エラー又は意図せず切断された
                        UTL_LOG("PairingDevice 接続エラー又は意図せず切断された");
                        if (devinfo["is_pairing"]) {
                            //接続中＞切断になった場合
                            devinfo["is_pairing"] = false;
                            self.EventHandler.fire({type: self.EventHandlerType.OnConnectionLoss, BLEDeviceInfo: devinfo});
                        } else {
                            //切断＞接続で失敗した場合
                            self.EventHandler.fire({type: self.EventHandlerType.OnConnectMissing, BLEDeviceInfo: devinfo});
                        }
                    }
                );
        });

    },

    /**
     * 切断
     * @param BLEDeviceInfo
     */
    DisconPairingDevice: function (BLEDeviceInfo) {
        var self = this;
        if (!BLEDeviceInfo) {
            return;
        }
        //info::この処理は必要なのか↓↓
        var devinfo = _SearchDeviceInfolistFromDeviceID_ref(BLEDeviceInfo["device_uuid"]);
        if (!devinfo) {
            return;
        }

        ble.disconnect(BLEDeviceInfo["device_uuid"], function () {
            devinfo["is_pairing"] = false;
            self.EventHandler.fire({type: self.EventHandlerType.OnDisconPairingComp, BLEDeviceInfo: devinfo});
        }, function () {
            //切断エラー
            throw new Error("DisconPairingDevice Disconnect error");//切断エラー
        });

    }



};
////
    return publicobj;

}());