/**
 * キャラクタリスティック更新Class　シングルトン
 * 殆どbleのラッパー
 */
BLECharacteristicController=(function(){
    /************************************************************************************
     *
     * プライベート領域
     *
     ************************************************************************************/
    var _BLELogDatas=[];
    var _isRec=false;

    var _recdate = Date.now();
    /**
     * ログデータの生成
     * @private
     */
    var _CreateBLELogData=function(device_uuid, service_uuid, characteristic_uuid,  value){
        var BLELogData={time:Date.now()-_recdate,d_uid:device_uuid, s_uid:service_uuid, c_uid:characteristic_uuid,val:value};
        console.log(BLELogData);
        return BLELogData;
    }

    /**
     * コントローラーの状態保存・復帰 ログのみ
     * @private
     */
    var _Controller_state_save=function(){
        UTL_save_storage("BLECharacteristicController",{LogData:_BLELogData});

    }
    var _Controller_state_load=function(){
        var SDATA = UTL_load_storage("BLECharacteristicController");
        if(SDATA instanceof Object){
            _BLELogData = (SDATA.LogData instanceof Array) ? SDATA.LogData : [];
        }

    }
    /************************************************************************************
     *
     * パブリック領域
     *
     ************************************************************************************/
    var publicobj = {
        Send :function (device_uuid, service_uuid, characteristic_uuid,  value, success, failure){
            // var ch_debug=new Uint8Array(value,0);//info::debug
            // console.log("Send characteristic_uuid:"+ characteristic_uuid+" 0x "+ch_debug[0].toString(16));//info::debug
            ble.write(device_uuid, service_uuid, characteristic_uuid,  value, success, failure);
            if(_isRec){
                _BLELogDatas.push(_CreateBLELogData(device_uuid, service_uuid, characteristic_uuid,  value));
            }

        },
        SendwriteWithoutResponse :function (device_uuid, service_uuid, characteristic_uuid,  value, success, failure){
            ble.writeWithoutResponse(device_uuid, service_uuid, characteristic_uuid,  value, success, failure);
            if(_isRec){
                _BLELogDatas.push(_CreateBLELogData(device_uuid, service_uuid, characteristic_uuid,  value));
            }
        },
        Read :function(device_uuid,service_uuid,characteristic_uuid,success, failure){
            ble.read(device_uuid, service_uuid, characteristic_uuid, success, failure);
        },
        StartNotification: function (device_uuid, service_uuid, characteristic_uuid, success, failure){
            ble.startNotification (device_uuid, service_uuid, characteristic_uuid, success, failure);
        },
        StopNotification: function (device_uuid, service_uuid, characteristic_uuid, success, failure){
          ble.stopNotification(device_uuid, service_uuid, characteristic_uuid, success, failure);
        },
        /**
         * 通信の記録初期化
         * @constructor
         */
        ClearRec:function(){
            _recdate = Date.now();
            _BLELogDatas=[];
        },
        /**
         * 通信の記録開始
         * @constructor
         */
        StartRec:function(){
            _isRec=true;
        },
        /**
         * 通信の記録一時停止
         * @constructor
         */
        StopRec:function(){
            _isRec=false;
        },
        /**
         * ログデータの取得
         * @constructor
         */
        GetRecDatas:function(){
            return UTL_clone(_BLELogDatas);
        },
        /**
         * 記録中か？
         * @returns {boolean}
         * @constructor
         */
        GetIsRec:function(){
            return _isRec;
        }
    }

    ////
    return publicobj;

}());