/**
 *AbstractDeviceListUIDelegateList
 * 制御デバイス抽象化Class(AbstractDeviceList.js)に対応する、DOMのUIを生成する為のパッケージ。
 * (DOMを使用しないソリューション(node.js等)に対応する為にDOM部分のロジックを分離)
 *
 * UIを生成する物のみ記述。AbstractDeviceList_ClassOptions.device_nameと同じプロパティ名で記述。
 * info::基本的に入力デバイス用。現状では詳細設定の操作パネルが出ない為、BLEデバイスは記述しても設定画面側からは使えない。
 *
 * ●メソッド
 *  ○AbstractDeviceDOMUIList.CreateUI(AbstractDeviceIns,ParentDOM)
 *  　デバイスに対応するUIを生成
 */

/************************************************************************************
 *
 * section::AbstractDeviceListUIDelegateList定義
 *
 ************************************************************************************/
AbstractDeviceListUIDelegateList=(function(){
    "use strict";
    //制御デバイス抽象化Classのデバイス名に紐付くUIの生成Delegateリスト
    var DeviceName_Ties_DelegateDictionary={
        // "Keigan_Motor":function(AbstractDeviceIns,ParentDOM){
        //     //テキストの変更時
        //     AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnIconLabelChange,"Keigan_Motor_OnIconLabelChange_lis");
        //     AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnIconLabelChange,function Keigan_Motor_OnIconLabelChange_lis(e){
        //     });
        // },

        //-------------------------------------------------------------//
        //
        //section::ローテーションスイッチ
        //
        //-------------------------------------------------------------//
        /**
         * コンストラクター
         * @param AbstractDeviceIns
         * @param ParentDOM
         */
        "inputctl_rotation":function(AbstractDeviceIns,ParentDOM){
            var DeviceName=AbstractDeviceIns.device_name;
            var HandleUnit=AbstractDeviceIns.handle_unit;

            var InputSeekIntervalCnt={val:0};//入力から取得する値の取得間隔
            var inputctl_rotation_jq=$('<div class="inputctl_rotation"></div>');
            var d_jq=$('<input type="text" value="0" class="inputctl_rotation_dial">');
            var ct_jq=$('<div class="InputSeekIntervalCntSW fa fa-2x fa-plug" aria-hidden="true"></div>');//UIの取得間隔通知ランプ
            var integ_jq=$('<div class="integ_val" >0.00</div>');//積算値
            //--------------------//
            //section::入力イベントハンドラ
            //--------------------//
            /**
             * compassからのインプット変更時
             * @param flg compass_input_mode センサー入力:true UI入力:false
             * @constructor
             */
            function CompassImputModeChange(compass_input_mode){
                AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnCompassSencerValChange,"OnCompassSencerValChangeLisner");
                if(compass_input_mode){ //コンパスセンサーからの入力モード
                    InputSeekIntervalCnt.val=0;
                    //clearInterval(InputSeekIntervalID);
                    //センサーからの値変更時にUIに反映
                    AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnCompassSencerValChange,OnCompassSencerValChangeLisner);
                    //UIを読み取り専用に
                    d_jq.trigger('configure',{
                        readOnly:true,
                        change:null
                    });
                }else{//UIからの入力モード
                    //UIからの値変更時にUIに反映
                    AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnCompassSencerValChange,OnCompassSencerValChangeLisner);
                    d_jq.trigger('configure',{
                        readOnly:false,
                        change:OnUIInputValChangeLisner
                    });
                }
            };

            /**
             * バインダー(接続先)からの値の変更
             */
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnRotvalChange,"inputctl_rotation_OnRotvalChange");
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnRotvalChange,function inputctl_rotation_OnRotvalChange(e){
                d_jq.val(e.Rotval).trigger('change');
            });

            /**
             * センサーからの値反映
             * UI表示の更新のみ（値自体はAbstractDeviceInsからバインダーに直接送信）
             * @param e
             * @constructor
             */
            var OnCompassSencerValChangeLisner=function OnCompassSencerValChangeLisner(e){
                //UTL_LOG("センサー入力:"+e.Rotval);
                d_jq.val(e.Rotval).trigger('change');
            };

            /**
             * UIからの値反映
             * @param ui_val
             * @constructor
             */
            var OnUIInputValChangeLisner=function OnUIInputValChangeLisner(ui_val){
                //UTL_LOG("UI入力:"+drg);
                //取得間隔以内の入力はUI以外に通知しない
                var utime=(+new Date());//UNIXTIME ShortCode
                if(utime-InputSeekIntervalCnt.val < AbstractDeviceIns.UIInput_watch_time){
                    //UTL_LOG("UI入力通知:スキップ");
                    ct_jq.toggleClass("on",false);
                    return;
                }
                InputSeekIntervalCnt.val=utime;

                AbstractDeviceIns._SetRotval(ui_val);
                ct_jq.toggleClass("on",true);
                //UTL_LOG("UI入力通知:"+ui_val);
            };
            /**
             * 取り扱う単位の切り替え時にダイヤルの表示を切り替え
             * @param new_handle_unit
             * @constructor
             */
            var HandleUnitChange=function HandleUnitChange(handle_unit){
                switch(handle_unit){
                    case AbstractDeviceIns.HANDLE_UNIT.RADIANS:
                        var conv_val=UTL_conv_deg_to_radi(UTL_N(d_jq.val()));
                        //$('.inputctl_rotation_dial').trigger('configure',{"min":0, "max":6.283185307179586,"step":0.0175});
                        $('.inputctl_rotation_dial').trigger('configure',{"min":0, "max":6.283185307179586,"step":0.01});
                        d_jq.val(conv_val).trigger('change');
                        break;
                    case AbstractDeviceIns.HANDLE_UNIT.DEGREE:
                        var conv_val=UTL_conv_radi_to_deg(UTL_N(d_jq.val()));
                        $('.inputctl_rotation_dial').trigger('configure',{"min":0, "max":360,"step":0.01});
                        //$('.inputctl_rotation_dial').trigger('configure',{"min":0, "max":360,"step":1});
                        d_jq.val(conv_val).trigger('change');
                        break;
                }
                HandleUnit=handle_unit;
            };
            /**
             * OUTPUT_ROTMODE別の積算値の表示変更
             * @param output_rotmode
             * @constructor
             */
            var OutputRotmodeChange=function OutputRotmodeChange(output_rotmode){
                if(output_rotmode === AbstractDeviceIns.OUTPUT_ROTMODE.INTEGRATION){
                    //積算モード
                    integ_jq.toggle(true);
                    d_jq.toggle(false);
                }else {
                    //絶対・相対モード
                    integ_jq.toggle(false);
                    d_jq.toggle(true);
                }



              //  inputctl_rotation_dial
            };

            /**
             * 出力時のダイヤルの角度値のモード変更
             */
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnOutputRotmodeChange,"inputctl_rotation_OnOutputRotmodeChange_lis");
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnOutputRotmodeChange,function inputctl_rotation_OnOutputRotmodeChange_lis(e){
                OutputRotmodeChange(e.output_rotmode);
            });
            /**
             * 積算値の変更（積算モードのみ）
             */
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnIntegvalChange,"inputctl_rotation_OnIntegvalChange_lis");
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnIntegvalChange,function inputctl_rotation_OnIntegvalChange_lis(e){
                integ_jq.text(e.Integval.toFixed(2));//小数第二位
            });

            //コンパスセンサーからの入力モード時はUIは表示のみ、それ以外は入力可能
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnCompassImputModeChange,"inputctl_rotation_OnCompassImputModeChange_lis");
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnCompassImputModeChange,function inputctl_rotation_OnCompassImputModeChange_lis(e){
                CompassImputModeChange(e.compass_input_mode);
            });
            //取り扱う単位の切り替え時
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnHandleUnitChange,"inputctl_rotation_OnHandleUnitChange_lis");
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnHandleUnitChange,function inputctl_rotation_OnHandleUnitChange_lis(e){
                HandleUnitChange(e.handle_unit);
            });

            // -------------------//
            // section::エントリポイント
            //--------------------//
            //UIの生成とDOMへのバインド
            inputctl_rotation_jq.append(d_jq).append(ct_jq).append(integ_jq);
            $(ParentDOM).append(inputctl_rotation_jq);
            //todo::compass_input_mode のONOFFで値を表示のみ(READONRY か入力モードかの分岐)
            //jQuery Kontrol (http://anthonyterrien.com/kontrol/)
           //$(".inputctl_rotation_dial").knob({
            var w=$(ParentDOM).width();
            d_jq.knob({
                "fgColor":"#0284ED"
                ,"cursor":true
                ,width:w
                ,height:w
                ,"min":0
                ,"max":(HandleUnit===AbstractDeviceIns.HANDLE_UNIT.RADIANS?6.283185307179586:360)
                ,"step":(HandleUnit===AbstractDeviceIns.HANDLE_UNIT.RADIANS?0.0175:1)
            });
            HandleUnitChange(AbstractDeviceIns.handle_unit);
            CompassImputModeChange(AbstractDeviceIns.compass_input_mode);
            OutputRotmodeChange(AbstractDeviceIns.output_rotmode);

        },

        //-------------------------------------------------------------//
        //
        //section::XYドラッグUI
        //
        //-------------------------------------------------------------//
        /**
         * コンストラクター
         * @param AbstractDeviceIns
         * @param ParentDOM
         */
        "inputctl_XYPad":function(AbstractDeviceIns,ParentDOM){
            var DeviceName=AbstractDeviceIns.device_name;
            var InputSeekIntervalCnt={val:0};//入力から取得する値の取得間隔
            var inputctl_XYPad_jq=$('<div class="inputctl_XYPad"></div>');

            var pad_jq = $('<fieldset class="inputctl_XYPad_Pad" ><legend>XY Pad</legend><input name="x" value=0><input name="y" value=0></fieldset>');
            pad_jq.css({display:'none'});//パッド内に数値を表示しない設定
            var ct_jq=$('<div class="InputSeekIntervalCntSW fa fa-2x fa-plug" aria-hidden="true"></div>');//UIの取得間隔通知ランプ

            var _vector2=new ST_Vector2();
            var _fastflg=false;
            var _centerfix_flg=false;//中央固定モードでセンター（起点）をタップしたか
            var _tuchflg=false;
            var _min_move_dist_color='rgba(56, 153, 187,0.5)';//最小範囲の円の色
            var _max_move_dist_color='rgba(56, 153, 187,0.5)';//最台範囲の円の色
            var _line_color='rgb(255, 39, 0)';//ベクトルの色
            var start_p=[0,0];
            //--------------------//
            //section::入力イベントハンドラ
            //--------------------//
            /**
             * UIからの値反映
             * min_move_dist以上ドラッグしたら、max_move_distを最大として、その方向分のベクトルを算出する
             * @param ui_val
             * @constructor
             */
            var OnUIInputValChangeLisner=function (xy_val_obj){
                var now=new ST_Vector2(xy_val_obj[0],xy_val_obj[1]);//現在の位置
                var min_dist=AbstractDeviceIns.min_move_dist;
                var max_dist=AbstractDeviceIns.max_move_dist;
               // console.log("now:"+now.x+","+now.y);
                switch(AbstractDeviceIns.UIInput_mode){
                    case AbstractDeviceIns.UI_INPUT_MODE.RELATIVE://相対モード
                        if(_fastflg){
                            _vector2.x=xy_val_obj[0];
                            _vector2.y=xy_val_obj[1];//タッチ地点の登録
                            var s_p= this.valxy2(_vector2.x,_vector2.y);//canvas座標に変換
                            start_p[0]=s_p[0];
                            start_p[1]=s_p[1];
                            _fastflg=false;
                            InputSeekIntervalCnt.val=0;//最初に取得してから検出範囲まではタイムラグ無しで行う
                            AbstractDeviceIns._SetPoint(new ST_Vector2(),new ST_Vector2());
                            return;
                        }

                    break;
                    case AbstractDeviceIns.UI_INPUT_MODE.CENTER_FIXED://中央固定モード
                        if(_fastflg){
                            _vector2.x=0;
                            _vector2.y=0;//タッチ地点の登録
                            var s_p= this.valxy2(_vector2.x,_vector2.y);//canvas座標に変換
                            start_p[0]=s_p[0];
                            start_p[1]=s_p[1];
                            _fastflg=false;
                            //0点から(min_move_dist)以内を起点としてタップしていないと無効（処理しない）
                            var _ini_dist=_vector2.Distance(now);//0地点からのタッチの距離
                            if(_ini_dist>min_dist){
                                _centerfix_flg=false;
                                return;
                            };

                            _centerfix_flg=true;
                            InputSeekIntervalCnt.val=0;//最初に取得してから検出範囲まではタイムラグ無しで行う
                            AbstractDeviceIns._SetPoint(new ST_Vector2(),new ST_Vector2());

                            return;
                        }
                        if(!_centerfix_flg){
                            return;
                        }
                        break;
                };

                //最小移動距離の閾値以下は無視
                var rad=_vector2.Radian(now);//タッチ地点からの角度
                var dist=_vector2.Distance(now);//タッチ地点からの距離
                if(dist<min_dist){
                    InputSeekIntervalCnt.val=0;
                   // console.log("閾値以下 "+AbstractDeviceIns.min_move_dist);
                    return;
                }
                dist=dist>max_dist?max_dist:dist;

                
                //取得間隔以内の入力はUI以外に通知しない
                var utime=(+new Date());//UNIXTIME ShortCode
                if(utime-InputSeekIntervalCnt.val < AbstractDeviceIns.UIInput_watch_time){
                    ct_jq.toggleClass("on",false);
                   // console.log("取得間隔以内 ");
                    return;
                }
                InputSeekIntervalCnt.val=utime;
                //移動座標を算出。 最小移動距離の境界を0、最大移動距離を1として座標を正規化
                //info::もっと簡単な計算に出来るハズ
                var sd=(dist-min_dist)/(max_dist-min_dist)*-1;//最小-最大間で正規化した距離
                var u=new ST_Vector2(Math.cos(rad)*sd,Math.sin(rad)*sd);
               // console.log("sd:"+sd+" u_x:"+u.x+" u_y"+u.y);
                AbstractDeviceIns._SetPoint(u,_vector2.Clone());
                ct_jq.toggleClass("on",true);
            };

            // -------------------//
            // section::エントリポイント
            //--------------------//
            var r_jq=$('<div style="display: inline-block;border:5px solid #BBB"></div>').append(pad_jq);
            inputctl_XYPad_jq.append(r_jq).append(ct_jq);
            $(ParentDOM).append(inputctl_XYPad_jq);

            var w=$(ParentDOM).width()-8;//data-width="'+w+'" data-height="'+w+'"
            var h=$(ParentDOM).height()-8;
            pad_jq.xy({
                displayPrevious:false
                , min : -100
                , max : 100
                ,width:w
                ,height:h
                , cursor:1
                , fgColor:"#222222"
                , bgColor:"#EEEEEE"

                ,start:function () {//タッチダウン
                    _fastflg=true;
                    _tuchflg=true;
                }
                ,change : OnUIInputValChangeLisner
                ,release:function () {//タッチアップ
                    _vector2.x=_vector2.y=0;
                    _fastflg=false;
                    _tuchflg=false;
                    _centerfix_flg=false;
                    AbstractDeviceIns._SetPoint(new ST_Vector2(),new ST_Vector2());//停止
                    //console.log("release : ");
                }

                ,draw:function () {

                    //console.log("tuch_start_x "+this.tuch_start_x+","+this.tuch_start_y);
                    //タッチダウン時のスタートの最小範囲円と最大範囲円・ベクトルラインの描画
                    if(_tuchflg){
                        var graphic=this.g;
                            graphic.beginPath();
                            graphic.fillStyle = _min_move_dist_color;
                            // graphic.arc(_graph_pt[0],_graph_pt[1],AbstractDeviceIns.min_move_dist,0,Math.PI*2,false);
                            graphic.arc(start_p[0],start_p[1],AbstractDeviceIns.min_move_dist,0,Math.PI*2,false);
                            graphic.fill();

                            graphic.beginPath();
                            graphic.strokeStyle = _max_move_dist_color;
                            //graphic.arc(_graph_pt[0],_graph_pt[1],AbstractDeviceIns.max_move_dist,0,Math.PI*2,false);
                            graphic.arc(start_p[0],start_p[1],AbstractDeviceIns.max_move_dist,0,Math.PI*2,false);
                            graphic.stroke();

                            graphic.beginPath();
                            graphic.lineWidth=2;
                            graphic.strokeStyle = _line_color;
                        // graphic.moveTo(_graph_pt[0],_graph_pt[1]);
                            graphic.moveTo(start_p[0],start_p[1]);
                            graphic.lineTo(this.m[0],this.m[1]);
                            graphic.stroke();
                    }else{
                        //タッチアップ時の描画を消去
                        this.clear();
                        switch(AbstractDeviceIns.UIInput_mode){
                            case AbstractDeviceIns.UI_INPUT_MODE.CENTER_FIXED://中央固定モード
                                var st= this.valxy2(_vector2.x,_vector2.y);
                                start_p[0]=st[0];
                                start_p[1]=st[1];
                                var graphic=this.g;
                                graphic.beginPath();
                                graphic.fillStyle = _min_move_dist_color;
                                // graphic.arc(_graph_pt[0],_graph_pt[1],AbstractDeviceIns.min_move_dist,0,Math.PI*2,false);
                                graphic.arc(start_p[0],start_p[1],AbstractDeviceIns.min_move_dist,0,Math.PI*2,false);
                                graphic.fill();
                            break;
                        }

                    };

                }
                // ,cancel:function (value) {
                //     console.log("cancel : ", value);
                // }

            });//info::border*2 分だけ座標がズレる;

        },

        //-------------------------------------------------------------//
        //
        //section::PUSHボタン
        //
        //-------------------------------------------------------------//
        /**
         * コンストラクター
         * @param AbstractDeviceIns
         * @param ParentDOM
         */
        "inputctl_PushBtn":function(AbstractDeviceIns,ParentDOM){
            var inputctl_PushBtn_jq=$('<div class="inputctl_PushBtn"></div>');
            var btn_jq=$('<input type="button" class="btn btn-default" value="PUSH">');
            inputctl_PushBtn_jq.append(btn_jq);
            $(ParentDOM).append(inputctl_PushBtn_jq);

            btn_jq.on('click',function(){
                AbstractDeviceIns._SendBtnPush();
            });

            //ボタンテキストの変更時
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnBtnTextChange,"inputctl_PushBtn_OnBtnTextChange_lis");
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnBtnTextChange,function inputctl_PushBtn_OnBtnTextChange_lis(e){
                btn_jq.val(e.BtnText);
            });

            btn_jq.val(AbstractDeviceIns.BtnText);

        },
        //-------------------------------------------------------------//
        //
        //section::数値生成スライダー
        //
        //-------------------------------------------------------------//
        /**
         * コンストラクター
         * @param AbstractDeviceIns
         * @param ParentDOM
         */

        "inputctl_NumberSlider":function(AbstractDeviceIns,ParentDOM){
            var StackSafe_Interval=40;//info::iosは40ms以内だとBLEコマンドがスタックされ遅延の元になる為、リアルタイム入力の間隔を制限
            var stack_time={time:0};//送信間隔調整用
            //DOM生成
            var inputctl_NumberSlider_jq=$('<div class="inputctl_NumberSlider"></div>');
            var jq_num=$('<input type="number" class="input_num form-control" pattern="[0-9.+-]*" />');//  inputmode="numeric" ios13 iphoneで小数点がでない
            var jq_range=$('<input type="range" class="input_range form-control" />');

            inputctl_NumberSlider_jq.append(jq_range).append(jq_num);
            $(ParentDOM).append(inputctl_NumberSlider_jq);

            ///イベント
            //仮想デバイスからの値の変更
            function NumberSlider_ChangeValelis(e){
                jq_num.val(e.val);
                jq_range.val(e.val);
            }
            //UIのレンジ変更
            function NumberSlider_ChangeRangelis(){
                _ChangeRangeUI(AbstractDeviceIns.Low,AbstractDeviceIns.Max,AbstractDeviceIns.Step);
            }

            //スライド中の値変更監視フラグ変更時 又は、固定モードの時は値はリアルタイム変更
            function NumberSlider_RealtimeChangelis(v){
                if(AbstractDeviceIns.RealtimeChange||AbstractDeviceIns.FixMidpoint){
                    jq_range.off('input',_ChangeTouchinputUI);
                    jq_range.on('input',_ChangeTouchinputUI);
                    jq_range.off('change',_ChangeInnerValelis);
                   // _ChangeTouchUpUI();
                }else {
                    jq_range.off('input',_ChangeTouchinputUI);
                    jq_range.on('change',_ChangeInnerValelis);
                }
            }

            //スライダの反転
            function NumberSlider_ValueInvertChangelis(e){
               jq_range.css({direction: AbstractDeviceIns.ValueInvert?"rtl":"ltr"});
            }

            // //自動で中央に戻る値の変更
            // function NumberSlider_FixMidpointChangelis(){
            //
            // }

            //内部UIからの値の変更
            function _ChangeInnerValelis(){
                var val=$(this).val();
                var enterval=$(this).data("enterval");
                $(this).data("enterval",null);
                if(enterval===val){return;}//EnterKey送信>changeでの二重送信防止
                _ChangeInnerValeSet(UTL_N(val));
            }
            function _ChangeInnerValeSet(val){
                console.log("_ChangeInnerValeSet:"+val);
                jq_num.val(val);
                jq_range.val(val);
                AbstractDeviceIns._SetVal(val);
            }

            //UIのレンジ変更関数
            function _ChangeRangeUI(_low,_max,_step){
                jq_num.prop('min',_low).prop('max',_max).prop('step',_step);
                jq_range.prop('min',_low).prop('max',_max).prop('step',_step);
            }


            //スライド中のUIリアルタイム変更 内部から info::iosは40ms以内だとBLEコマンドがスタックされ遅延の元になる為、入力送信間隔に制限
            function _ChangeTouchinputUI(){
                var now=+new Date();
                if(now-stack_time.time>StackSafe_Interval){//入力がスタックしない限界値
                    stack_time.time=now;
                    var val=UTL_N($(this).val());
                    _ChangeInnerValeSet(val);
                }
            }

            //スライドのタッチアップ時
            function _ChangeTouchUpUI(){
                //FixMidpointが有効の場合は　スライダーを中央に戻す
                if(AbstractDeviceIns.FixMidpoint){
                    var val=AbstractDeviceIns.Low+(AbstractDeviceIns.Max-AbstractDeviceIns.Low)/2;
                   setTimeout(function(){
                       _ChangeInnerValeSet(val);
                   },StackSafe_Interval);

                }
            }
            // function _ChangeinputUI(){
            //
            // }
           //jq_num.on('change',_ChangeinputUI);

            jq_range.on('touchend',_ChangeTouchUpUI);
            jq_range.on('mouseup',_ChangeTouchUpUI);

            jq_num.on('change',_ChangeInnerValelis);
            //inputフィールド　enterキーでの値確定
            jq_num.keypress( function ( e ) {
                if ( e.keyCode == 13 ) {
                    var val=$(this).val();
                    $(this).data("enterval",val);//EnterKey送信>changeでの二重送信防止
                    _ChangeInnerValeSet(UTL_N(val));
                }
            } );


            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnValChange,"NumberSlider_ChangeValelis");
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnLowChange,"NumberSlider_ChangeRangelis");
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnMaxChange,"NumberSlider_ChangeRangelis");
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnRealtimeChange,"NumberSlider_RealtimeChangelis");
           AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnFixMidpointChange,"NumberSlider_RealtimeChangelis");
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnValueInvertChange,"NumberSlider_ValueInvertChangelis");
            //仮想デバイスからのイベントバインド
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnValChange,NumberSlider_ChangeValelis);
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnLowChange,NumberSlider_ChangeRangelis);
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnMaxChange,NumberSlider_ChangeRangelis);
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnStepChange,NumberSlider_ChangeRangelis);
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnRealtimeChange,NumberSlider_RealtimeChangelis);
           AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnFixMidpointChange,NumberSlider_RealtimeChangelis);
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnValueInvertChange,NumberSlider_ValueInvertChangelis);


            //初回処理

            _ChangeRangeUI(AbstractDeviceIns.Low,AbstractDeviceIns.Max,AbstractDeviceIns.Step);
            NumberSlider_ChangeValelis({val:AbstractDeviceIns.SliderVal});
            NumberSlider_RealtimeChangelis();//RealtimeChangeの初回の検出
            NumberSlider_ValueInvertChangelis();
        },
        //-------------------------------------------------------------//
        //
        //section::RECコントロール
        //
        //-------------------------------------------------------------//
        /**
         * コンストラクター
         * @param AbstractDeviceIns
         * @param ParentDOM
         */
        "RecCTL":function(AbstractDeviceIns,ParentDOM){
            var inputctl_PushBtn_jq={};
            var rec_btn_jqs=[];
            var play_btn_jqs=[];
            //ボタンの生成
            function _create_btn(){
                var ButtonLength=AbstractDeviceIns.ButtonLength;
                var PossionMemorys=AbstractDeviceIns._PossionMemorys;
                $(ParentDOM).empty();
                inputctl_PushBtn_jq=$('<div class="RecCTL"></div>');
                rec_btn_jqs=[];
                play_btn_jqs=[];
                //メモリクリア位置初期化ボタン
                var cbtn_jq_wrap=$('<div class="btn_set"></div>');
                var clear_poss_btn_jq=$('<div class="btn btn-default clear_poss_btn"><i class="fa fa-compass"></i>SetZero</div>');
                var clear_mem_btn_jq=$('<div class="btn btn-default clear_mem_btn"><i class="fa fa-trash" aria-hidden="true"></i>ResetRecPos</div>');
                cbtn_jq_wrap.append(clear_mem_btn_jq).append(clear_poss_btn_jq);
                inputctl_PushBtn_jq.append(cbtn_jq_wrap);

                var hm_clear_poss_btn = new Hammer.Manager(clear_poss_btn_jq.get(0));
                hm_clear_poss_btn.add(new Hammer.Tap({taps: 1}));
                hm_clear_poss_btn.on("tap", function(event) {
                    AbstractDeviceIns._SendClearPossionBtnPush();
                });

                var hm_clear_mem_btn = new Hammer.Manager(clear_mem_btn_jq.get(0));
                hm_clear_mem_btn.add(new Hammer.Tap({taps: 1}));
                hm_clear_mem_btn.on("tap", function(event) {
                    AbstractDeviceIns._SendClearMemoryBtnPush();
                });


                //記録ボタン
                for(var i=0;i<ButtonLength;i++){
                    var rec_btn_jq=$('<div class="btn btn-default rec_btn"><i class="fa fa-circle"></i></div>');
                    var play_btn_jq=$('<div class="btn btn-default play_btn"><i class="fa fa-play"></i></div>').toggleClass('disabled',!Boolean(PossionMemorys[i]));

                    rec_btn_jqs.push(rec_btn_jq);
                    play_btn_jqs.push(play_btn_jq);
                    var btn_jq_wrap=$('<div class="btn_set"></div>');
                    inputctl_PushBtn_jq.append(btn_jq_wrap.append(rec_btn_jq).append(play_btn_jq));
                    $(rec_btn_jq).data('idx',i);
                    $(play_btn_jq).data('idx',i);

                    //info::ロングタップイベント使用の為、全てHammer経由のイベントを使用
                    var hm_rec_btn = new Hammer.Manager(rec_btn_jq.get(0));
                    hm_rec_btn.add(new Hammer.Tap({taps: 1,time: HAMMER_TAP_MAX_TIME}));//

                    var on_rec_btn_tap_lis=function(event){
                        AbstractDeviceIns._SendRecBtnPush(this[0].idx);
                    };
                    on_rec_btn_tap_lis.idx=i;
                    hm_rec_btn.on("tap", on_rec_btn_tap_lis);

                    var hm_play_btn = new Hammer.Manager(play_btn_jq.get(0));
                    hm_play_btn.add(new Hammer.Tap({taps: 1}));
                    var on_play_btn_tap_lis=function(event){
                        AbstractDeviceIns._SendPlayBtnPush(this[0].idx);
                    };
                    on_play_btn_tap_lis.idx=i;
                    hm_play_btn.on("tap", on_play_btn_tap_lis);
      
                }

                $(ParentDOM).append(inputctl_PushBtn_jq);
            }

            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnBtnLengthChange,"inputctl_PushBtnList_OnBtnLengthChange_lis");
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnBtnLengthChange,function inputctl_PushBtnList_OnBtnLengthChange_lis(e){
                _create_btn();
            });
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnPossionMemorysChange,"inputctl_PushBtnList_OnPossionMemorysChange_lis");
            AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnPossionMemorysChange,function inputctl_PushBtnList_OnPossionMemorysChange_lis(e){
                _refreshBtn();
            });

            function _refreshBtn(){
                var PossionMemorys=AbstractDeviceIns._PossionMemorys;

                for(var i=0;i<rec_btn_jqs.length;i++){
                    play_btn_jqs[i].toggleClass('disabled',!Boolean(PossionMemorys[i]));
                }
            }
            _create_btn();
            _refreshBtn();
        },
        //-------------------------------------------------------------//
        //
        //section::モーターコントロールセット（学習用）
        //
        //-------------------------------------------------------------//
        /**
         * コンストラクター
         * @param AbstractDeviceIns
         * @param ParentDOM
         */
        "inputctl_MTControlKit":function(AbstractDeviceIns,ParentDOM){
            var inputctl_MTControlKit_jq={};
            var rec_btn_jqs=[];
            var play_btn_jqs=[];
            var StackSafe_Interval=40;//info::iosは40ms以内だとBLEコマンドがスタックされ遅延の元になる為、リアルタイム入力の間隔を制限
            var stack_time=0;//送信間隔調整用
            var stack_time_rot=0;//回転情報取得間隔用
            //UIの生成
            function _create_btn(){

                $(ParentDOM).empty();
                var PossionMemorys=AbstractDeviceIns._PossionMemorys;

                inputctl_MTControlKit_jq=$('<div class="inputctl_MTControlKit"></div>');
                //再生停止ボタン
                var SpeedMode_active_btn_jq=$('<div class="btn btn-default SpeedMode_play_btn">SetActive</div>');
                var PositionMode_active_btn_jq=$('<div class="btn btn-default PositionMode_active_btn">SetActive</div>');
                //回転情報表示
                var info_MTRotState_jq=$('<div class="info_MTRotState"></div>');
                //トルク・スピード・位置　各種スライダーセット
                var sp_st_jq=$('<div class="Range_set"><div class="lt"><span class="st">Spd(rpm)</span><span class="info_Speed"></span></div><input type="range" class="input_range form-control SpeedMode_SpeedRange" min="-200" max="200" step="1"/></div>');
                var sp_pst_jq=$('<div class="Range_set"><div class="lt"><span class="st">Speed</span><span class="info_PosSpeed"></span></div><input type="range" class="input_range form-control PositionMode_SpeedRange" min="0" max="200" step="1"/></div>');
                var sp_ptq_jq=$('<div class="Range_set"><div class="lt"><span class="st">Torque</span><span class="info_PosTorque"></span></div><input type="range" class="input_range form-control PositionMode_TorqueRange" min="1" max="0.3" step="0.05"/></div>');
                var sp_pps_jq=$('<div class="Range_set"><div class="lt"><span class="st">Position</span><span class="info_PosPosition"></span></div><input type="range" class="input_range form-control PositionMode_PositionRange" min="-100" max="100" step="0.1"/></div>');
                //入力情報表示
                var info_Speed_jq=sp_st_jq.find('.info_Speed');
                var info_PosSpeed_jq=sp_pst_jq.find('.info_PosSpeed');
                var info_PosTorque_jq=sp_ptq_jq.find('.info_PosTorque');
                var info_PosPosition_jq=sp_pps_jq.find('.info_PosPosition');
                //レンジ
                var SpeedMode_SpeedRange_jq=sp_st_jq.find('.SpeedMode_SpeedRange');
                var PositionMode_SpeedRange_jq=sp_pst_jq.find('.PositionMode_SpeedRange');
                var PositionMode_TorqueRange_jq=sp_ptq_jq.find('.PositionMode_TorqueRange');
                var PositionMode_PositionRange_jq=sp_pps_jq.find('.PositionMode_PositionRange');
                //位置記憶
                var Rec_set_jq=$('<div class="Rec_set"><div class="btn_set"><div class="btn btn-default ResetPosition_btn">ResetRecPos</div><div class="btn btn-default MotorSTOP_btn">Free</div></div></div>');
                var ResetPosition_btn_jq=Rec_set_jq.find('.ResetPosition_btn');
                var MotorSTOP_btn_jq=Rec_set_jq.find('.MotorSTOP_btn');
                var play_btn_jq_list=[];
                //記録ボタン
                for(var i=0;i<3;i++){
                    var rec_btn_jq=$('<div class="btn btn-default rec_btn"><i class="fa fa-circle"></i></div>').data('idx',i);
                    var play_btn_jq=$('<div class="btn btn-default play_btn"><i class="fa fa-play"></i></div>').data('idx',i);
                    var btn_jq_wrap=$('<div class="btn_set"></div>');
                    Rec_set_jq.append(btn_jq_wrap.append(rec_btn_jq).append(play_btn_jq));

                    rec_btn_jq.on('click',function(event) {
                        var val=$(this).data('idx');
                        AbstractDeviceIns._SetRecPosition(val);

                    });
                    play_btn_jq.on('click',function(event) {
                        var val=$(this).data('idx');
                        AbstractDeviceIns._SetPlayPosition(val);
                    });

                    play_btn_jq_list.push(play_btn_jq);
                }
                //記録情報表示
                var info_PossionMemorys_jq=$('<div class="info_PossionMemorys"></div>');

                //DOM生成
                inputctl_MTControlKit_jq.append(info_MTRotState_jq).append('<div class="s_title">Speed</div>')
                    .append(sp_st_jq).append(SpeedMode_active_btn_jq).append($('<div class="s_title">Position</div>'))
                    .append(sp_pst_jq).append(sp_ptq_jq).append(sp_pps_jq).append(PositionMode_active_btn_jq)
                    .append($('<div class="s_title">REC(Position)</div>')).append(Rec_set_jq).append(info_PossionMemorys_jq);

                //UIイベント
                SpeedMode_active_btn_jq.on('click',function(){
                    AbstractDeviceIns._SetSpeedModeActive();
                });
                PositionMode_active_btn_jq.on('click',function(){
                    AbstractDeviceIns._SetPositionModeActive();
                });
                SpeedMode_SpeedRange_jq.on('change',function(){
                    if(!is_CanUpdateVal()){return;}
                    var v=UTL_N($(this).val());
                    AbstractDeviceIns._SetSpeed(v);
                    info_Speed_jq.text(v);
                });
                PositionMode_SpeedRange_jq.on('change',function(){
                    if(!is_CanUpdateVal()){return;}
                    var v=UTL_N($(this).val());
                    AbstractDeviceIns._SetPosSpeed(v);
                    info_PosSpeed_jq.text(v);
                });
                PositionMode_TorqueRange_jq.on('change',function(){
                    if(!is_CanUpdateVal()){return;}
                    var v=UTL_N($(this).val());
                    AbstractDeviceIns._SetPosTorque(v);
                    info_PosTorque_jq.text(v);
                });
                PositionMode_PositionRange_jq.on('change',function(){
                    if(!is_CanUpdateVal()){return;}
                    var v=UTL_N($(this).val());
                    AbstractDeviceIns._SetPosPosition(v);
                    info_PosPosition_jq.text(v);
                });
                //位置初期化
                ResetPosition_btn_jq.on('click',function(){
                    AbstractDeviceIns._SetResetPosition();
                    AbstractDeviceIns._SendStop();
                });
                //モーター停止
                MotorSTOP_btn_jq.on('click',function(){
                    AbstractDeviceIns._SendStop();
                });

                //再生停止のボタントグル表示
                function _UpdatePSbtnUI(){
                    SpeedMode_active_btn_jq.text(AbstractDeviceIns._IsSpeedModePlay?'Stop':'SetActive');
                    PositionMode_active_btn_jq.text(AbstractDeviceIns._IsPositionModePlay?'Stop':'SetActive');
                }
                //スライド中のUIリアルタイム変更 制限
                function is_CanUpdateVal(){
                    var now=+new Date();
                    if(now-stack_time>StackSafe_Interval){//入力がスタックしない限界値
                        stack_time=now;
                       return true;
                    }
                    return false;
                }
                //位置記憶状況の表示
                function _UpdatePossionMemorys(){
                    var st="";
                    var dic={};
                    var s_key=Object.keys(AbstractDeviceIns._PossionMemorys);
                    for(var ct=0;ct<s_key.length;ct++){
                        var pos_n_obj=AbstractDeviceIns._PossionMemorys[s_key[ct]];
                        var kys=Object.keys( pos_n_obj);
                        for(var i=0;i<kys.length;i++){
                            var pn=kys[i];
                            if(!dic[pn]){dic[pn]=[];}
                            dic[pn][s_key[ct]]=pos_n_obj[pn];
                        }
                    }
                    var dic_kys=Object.keys(dic);
                    for(var di=0;di<dic_kys.length;di++){
                        var ld=AbstractDeviceIns._Rev_LedStateColor[dic_kys[di]];
                        var led=ld instanceof ST_MTLedState?'<div class="clm"><span class="led" style="color:rgb('+(ld.GetValArray().slice(1))+');">●</span>':'<span>●</span>';
                        var listst=dic[dic_kys[di]].join('</span><span class="pos">');
                        st+=led+'<span class="pos">'+listst+'</span></div>';
                    }
                    info_PossionMemorys_jq.html(st);

                    for(var i=0;i<play_btn_jq_list.length;i++){
                        play_btn_jq_list[i].toggleClass('disabled',!Boolean(AbstractDeviceIns._PossionMemorys[i]));
                    }
                }

                $(ParentDOM).append(inputctl_MTControlKit_jq);

                //仮想デバイスからのイベントバインド
                AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnModePlayChange,"OnModePlayChangelis");
                AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnModePlayChange,function OnModePlayChangelis(){
                    _UpdatePSbtnUI();
                });

                //回転情報の更新
                AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnMTRotStateChange,"OnMTRotStateChangelis");
                AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnMTRotStateChange,function OnMTRotStateChangelis(){
                    var now=+new Date();
                    //回転情報は200ms毎の更新
                    if(now-stack_time_rot<200){return;}
                    stack_time_rot=now;
                    //回転情報の表示
                    var st="";
                    var kys=Object.keys( AbstractDeviceIns._Rev_MTRotState);
                    for(var i=0;i<kys.length;i++){
                        var ld=AbstractDeviceIns._Rev_LedStateColor[kys[i]];
                        var led=ld instanceof ST_MTLedState?'<span class="led" style="color:rgb('+(ld.GetValArray()).slice(1)+');">●</span>':'<span>●</span>';


                       var rot= AbstractDeviceIns._Rev_MTRotState[kys[i]];
                       st+=led+" Pos:"+rot.Position+"&#009;Spd:"+rot.Speed+"&#009;Trq:"+rot.Torque+"&#010;";
                        // st+=led+" Pos:"+rot.Position+"&#009;Spd:"+rot.Speed+"&#010;";
                    }
                    info_MTRotState_jq.html(st);
                });

                //REC情報の更新
                AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnPossionMemorysChange,"OnPossionMemorysChangelis");
                AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnPossionMemorysChange,function OnPossionMemorysChangelis(){
                    _UpdatePossionMemorys();
                });

                ///初回処理
                _UpdatePSbtnUI();
                _UpdatePossionMemorys();

            }



            function _refreshBtn(){

            }
            _create_btn();
            _refreshBtn();
        },
        //-------------------------------------------------------------//
        //
        //section::デバッグトレース
        //
        //-------------------------------------------------------------//
        /**
         * コンストラクター
         * @param AbstractDeviceIns
         * @param ParentDOM
         */
        "Debug_Trace":function(AbstractDeviceIns,ParentDOM){
            var Debug_Trace_jq=$('<div class="Debug_Trace"></div>');
            Debug_Trace_jq.toggleClass('off' ,AbstractDeviceIns.Active);
            $(ParentDOM).append(Debug_Trace_jq);
            //デバッグデータの変更時
            AbstractDeviceIns.EventHandler.removeListener(AbstractDeviceIns.EventHandlerType.OnDataChange,"Debug_Trace_OnDataChange_lis");

            if(AbstractDeviceIns.Active){
                AbstractDeviceIns.EventHandler.addListener(AbstractDeviceIns.EventHandlerType.OnDataChange,function Debug_Trace_OnDataChange_lis(e){
                    Debug_Trace_jq.text(e.data);
                });
            }
        }
    };

    // -------------------//
    // パブリック領域
    //--------------------//
    var publicobj = {
        //デバイスに対応するUIを生成
        CreateUI:function (AbstractDeviceIns,ParentDOM) {
            if(!AbstractDeviceIns){return;}
            if(!DeviceName_Ties_DelegateDictionary[AbstractDeviceIns.device_name]){return;}
            DeviceName_Ties_DelegateDictionary[AbstractDeviceIns.device_name](AbstractDeviceIns,ParentDOM);
        },
        IsUIExist:function(AbstractDeviceIns){
            if(!DeviceName_Ties_DelegateDictionary[AbstractDeviceIns.device_name]){return false;}
            var r=Boolean(DeviceName_Ties_DelegateDictionary[AbstractDeviceIns.device_name]);
            return r;
        }
    };
    /************************************************************************************
     * END AbstractDeviceDomUIList
     ************************************************************************************/
    ///
    return publicobj;
}());